<?php
$mainmenu = $this->mainmenu->buildMenu($session_data['utype'], 2);
$prof_inf = $this->messages->getUserInf($session_data['id']);
$data['title'] = "OFFICE";
$data['mainmenu'] = $mainmenu;
$data['profinf'] = $prof_inf;
$data['userinf'] = $session_data;
if (isset($msg)) {
    $data['msg'] = $this->messages->getMessage($msg);
}
$this->load->view('layout/header2', $data);
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Add Office
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i>Edit Office</a></li>
        </ol>
    </section>
    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">Edit Office Name, Description, Owner, and Status</h3>
            </div>
            <div class="box-body">
                <?php echo form_open('settings/save_office', 'id="form1" data-parsley-validate class=""'); ?>
                <div class="row">
                    <div class="col-md-6">
                        <label for="first-name"> Office Name <span class="required">*</span>
                        </label>
                        <?php
                        echo form_hidden('OfficeID', $office['OfficeID']);
                        echo form_input('OfficeName', $office['OfficeName'], 'class="form-control"'); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="last-name"> Office Description <span class="required">*</span>
                        </label>
                        <?php
                         $officedata = array(
                            'name' => 'OfficeDescription',
                            'id' => 'OfficeDescription',
                            'value' => $office['OfficeDescription'],
                            'class' => 'form-control',
                            'rows' => '4',
                            'cols' => '20'
                          );
                          //echo form_input('OfficeDescription', $office['OfficeDescription'], 'class="form-control"'); 
                          echo form_textarea($officedata); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="email"> Owner <span class="required">*</span>
                        </label>
                        <?php
                        echo form_dropdown('OwnerID', $owners, $office['OwnerID'], 'class="form-control col-md-7 col-xs-12"');?>
                    </div>
                    <div class="col-md-6">
                        <label for="password"> Active <span class="required">*</span>
                        </label>
                        <?php
                        echo form_dropdown('Active', $active, $office['Active'], 'class="form-control col-md-7 col-xs-12"');?>
                    </div>
                </div>

                <br>
                <div class="box-footer">
                    <button type="submit" value="Validate!" class="btn btn-success pull-right">Submit</button>
                </div>
                <?php echo form_close(); ?>
            </div>

        </div>

    </section>
</div>

<?php
$this->load->view('layout/footer2');
?>
<script type="text/javascript" src="<?php echo base_url(); ?>layout/js/jquery.validate.js"></script>
<script>
    $(document).ready(function () {
        jQuery.validator.addMethod("lettersonly", function (value, element) {
            return this.optional(element) || /^[a-z]+$/i.test(value);
        }, "Please enter only letters without space.");
        $("#form1").validate({
            errorElement: "p",
            rules: {
                OfficeName: {
                    required: true,
                },
                OfficeDescription: {
                    required: true,
                },
                OwnerID: {
                    required: true
                }
            },
            errorPlacement: function (error, element) {
                error.appendTo(element.parent());
            }
        });
    });

</script>