 <!-- Datatable style -->
<link rel="stylesheet" href="<?= base_url() ?>public/plugins/datatables/dataTables.bootstrap.css">  

<div class="datalist" style="overflow-y: auto;">
    <table id="rent_demand_reg" class="table table-bordered  table-hover" >
        <thead>
			<tr><td colspan="7"></td><td colspan="2"><select name="financial_year" id="financial_year" class="form-control show-tick" style="width:200px" >
												<option value="">-- वित्तीय वर्ष --</option>
											<?php
                        foreach($year as $yr)
                        {
                         ?>
                         <option value="<?php echo $yr->id ?>" ><?php echo $yr->year ?></option>
                         <?php
                        }
                        ?>																					
											</select></td>
											<td colspan="13"></td></tr>
			<tr>
				
				
				<th colspan="17" style="text-align: center;">Financial Year - <span id="fnyear"><?php echo date('Y', strtotime("now")).' - '.date('Y', strtotime("+1 years"));?></span></th>
				
			    <th colspan="15" style="text-align: right;"><?php echo date('F').', '.date('d-m-Y h:i:sa');?></th>
			    
			    
			</tr>
			<tr>
                <th colspan="11"></th>
				
				<th colspan="6" style="text-align: center;">माँग पक्ष</th>
				
			    <th colspan="9" style="text-align: center;">जमा पक्ष</th>
			    
			    <th colspan="5" style="text-align: center;">अवशेष </th>			    				
            </tr>
            <tr>
                <th>क्र.स०</th>
				<th></th>
                <th>आई.डी.न०</th>
                <th>भवन संख्या</th>
                <th>वार्ड का नाम</th>    
                <th>मोहल्ले का नाम</th>
                <th>बाजार का नाम</th>
                <th>उपभोक्ता का नाम S/O पिता / पति का नाम</th>
				<th>मोबाइल न०</th>	
				<th>कनेक्शन नंबर</th>	
				<th>जल मूल्य दर प्रति माह</th>
				<th>जल मूल्य प्रतिवर्ष</th>
				<th>बकाया जल मूल्य</th>
				<th>कुल योग</th>
				<th>जीसटी वर्तमान जल मूल्य</th>
				<th>जीसटी बकाया जल मूल्य</th>
				<th>कुल जीसटी </th>
			    <th>चालू जमा</th>
			    <th>बकाया जमा</th>
			    <th>कुल देय धनराशि</th>	
			    <th>जीसटी वर्तमान जमा</th>
			    <th>जीसटी बकाया जमा</th>
			    <th>कुल जीसटी </th>
			    <th>बुक संख्या सहित रसीद संख्या</th>
			    <th>रसीद जमा तिथि</th>
			    <th>जमा कर्ता नाम</th>
			    <th>चालू</th>		
			    <th>बकाया</th>
			    <th>जीसटी</th> 
			    <th>कुल अवशेष धनराशि</th>
                <th>टिप्पड़ी</th>				
            </tr>
        </thead>       
    </table>
</div>


<!-- DataTables -->
<script src="<?= base_url() ?>public/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>public/plugins/datatables/dataTables.bootstrap.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.0.0/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.html5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script>
  $(function () {	 
	$("#financial_year").on("change",function(){
		var financial_year=$("#financial_year").val();
		if(financial_year ==2)$("#fnyear").html('2020 - 2021');
		if(financial_year ==3)$("#fnyear").html('2021 - 2022');
    $("#rent_demand_reg").DataTable({
			"destroy": true,
			"dom": 'lBrtip',
			"aLengthMenu": [[25, 50, 75, 100, 300, 500], [25, 50, 75, 100, 300, 500]],
            "pageLength": 25, 
            "buttons": ['print', 'excel'],
      "processing": true,
      "serverSide": true,
      "ajax": "<?=base_url('index.php/admin/rent/advance_datatable_json/"+financial_year+"')?>",
      "order": [[0,'asc']],
      "columnDefs": [
        { "targets": 0, "name": "rent_demand_registerid", 'searchable':false, 'orderable':false},
        { "targets": 1, "name": "button", 'searchable':false, 'orderable':false},
		{ "targets": 2, "name": "property_id_number", 'searchable':true, 'orderable':true},
        { "targets": 3, "name": "property_number", 'searchable':true, 'orderable':true},
        { "targets": 4, "name": "ward", 'searchable':true, 'orderable':true},
        { "targets": 5, "name": "village_address", 'searchable':true, 'orderable':true},
        { "targets": 6, "name": "market", 'searchable':true, 'orderable':true},
        { "targets": 7, "name": "father_name", 'searchable':true, 'orderable':true},
        { "targets": 8, "name": "mobile_number", 'searchable':true, 'orderable':true},		
		{ "targets": 9, "name": "allotment_date", 'searchable':false, 'orderable':false},
		{ "targets": 10, "name": "month_name", 'searchable':false, 'orderable':false},
		{ "targets": 11, "name": "demand_current_month_rent", 'searchable':false, 'orderable':false},
		{ "targets": 12, "name": "demand_due_rent", 'searchable':false, 'orderable':false},
		{ "targets": 13, "name": "demand_gst", 'searchable':false, 'orderable':false},
		{ "targets": 14, "name": "demand_bakaya_gst", 'searchable':false, 'orderable':false},
		{ "targets": 15, "name": "demand_total_gst", 'searchable':false, 'orderable':false},		
		{ "targets": 16, "name": "total_annual_deposit_money", 'searchable':false, 'orderable':false},
		{ "targets": 17, "name": "demand_total_deposit_money_yog", 'searchable':false, 'orderable':false},
		{ "targets": 18, "name": "demand_total_deposit_money", 'searchable':false, 'orderable':false},
		{ "targets": 19, "name": "deposit_current_month", 'searchable':false, 'orderable':false},
		{ "targets": 20, "name": "deposit_outstanding_deposit", 'searchable':false, 'orderable':false},
		{ "targets": 21, "name": "deposit_gst", 'searchable':false, 'orderable':false},
		{ "targets": 22, "name": "deposit_bakaya_gst", 'searchable':false, 'orderable':false},
		{ "targets": 23, "name": "deposit_total_gst", 'searchable':false, 'orderable':false},
		{ "targets": 24, "name": "deposit_total_pay", 'searchable':false, 'orderable':false},
		{ "targets": 25, "name": "awashesh_amount", 'searchable':false, 'orderable':false},
		{ "targets": 26, "name": "deposit_receipt_number", 'searchable':true, 'orderable':true},
		{ "targets": 27, "name": "deposit_receipt_date", 'searchable':false, 'orderable':false},
		{ "targets": 28, "name": "deposit_depositor", 'searchable':false, 'orderable':false},
		{ "targets": 29, "name": "deposit_comment", 'searchable':false, 'orderable':false},	
		{ "targets": 30, "name": "deposit_comment", 'searchable':false, 'orderable':false}		
      ],
	  
    });
  });
   });
</script> 