 <section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-body">
                <div class="col-md-6">
                    <h4><i class="fa fa-list"></i> &nbsp; Payment Gateway</h4>
                </div>
                <div class="col-md-6 text-right">
                    <?php if( $this->rbac->check_operation_permission('add') || 1 == 1 ): ?>
                        <a href="<?= base_url('admin/payment_gateway/add'); ?>" class="btn btn-success"><i class="fa fa-plus"></i> Add New Payment Gateway</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="box">
        <div class="box-header">
        </div>
        <!-- /.box-header -->
        <div class="box-body table-responsive">
            <table id="na_datatable" class="table table-bordered table-striped" width="100%">
                <thead>
                    <tr>
                        <th>#ID</th>
                        <th>Client</th>
                        <th>Name</th>
                        <th>Login</th>
                        <th>Key</th>
                        <?php /*<th>Url</th>*/ ?>
                        <th>Test Login</th>
                        <th>Test Key</th>
                        <?php /*<th>Test Url</th>*/ ?>
                        <th>Sandbox</th>
                        <th>Active</th>
                        <th class="text-right">Action</th>
                    </tr>
                </thead>
            </table>
        </div>
        <!-- /.box-body -->
    </div>
    <!-- /.box -->

    <?php if( 1 == 2 ){ ?>
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group" role="group">
                    <button type="button" class="btn btn-default">Left</button>
                    <button type="button" class="btn btn-default">Middle</button>
                    <button type="button" class="btn btn-default">Right</button>
                </div>
                <div class="btn-group btn-group-justified" role="group">
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-default">Left</button>
                    </div>
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-default">Middle</button>
                    </div>
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-default">Right</button>
                    </div>
                </div>
                <a title="View" class="btn btn-sm btn-success" href="#"> <i class="fa fa-plus-circle"></i></a>
            </div>
        </div>
    <?php } ?>
</section>  

<!-- Modal -->
<div id="confirm-delete" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Delete</h4>
            </div>
            <div class="modal-body">
                <p>As you sure you want to delete.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <a class="btn btn-danger btn-ok">Delete</a>
            </div>
        </div>
    </div>
</div>


<!-- DataTables -->
<script src="<?= base_url() ?>public/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>public/plugins/datatables/dataTables.bootstrap.min.js"></script>
<script>
    //---------------------------------------------------
    var table = $('#na_datatable').DataTable( {
        "processing": true,
        "serverSide": true,
        "ajax": "<?=base_url('admin/payment_gateway/get_datatable_json')?>",
        "order": [[0,'asc']],
        "columnDefs": [
            { "targets": 0, "name": "pg_id", 'searchable':true, 'orderable':true},
            { "targets": 1, "name": "name", 'searchable':true, 'orderable':true},
            { "targets": 2, "name": "pg_name", 'searchable':true, 'orderable':true},
            { "targets": 3, "name": "loginid", 'searchable':true, 'orderable':true},
            { "targets": 4, "name": "api_key", 'searchable':true, 'orderable':true},
            //{ "targets": 5, "name": "api_url", 'searchable':true, 'orderable':true},
            { "targets": 5, "name": "loginid_test", 'searchable':true, 'orderable':true},
            { "targets": 6, "name": "api_key_test", 'searchable':true, 'orderable':true},
            //{ "targets": 8, "name": "api_url_test", 'searchable':true, 'orderable':true},
            { "targets": 7, "name": "sandbox_on", 'searchable':true, 'orderable':true},
            { "targets": 8, "name": "is_active", 'searchable':true, 'orderable':true},
            { "targets": 9, "name": "Action", 'searchable':false, 'orderable':false,'width':'250px'}
        ]
    });
</script>

<script type="text/javascript">
    $('#confirm-delete').on('show.bs.modal', function(e) {
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
    });
</script>

<script type="text/javascript">
    $("body").on("change",".tgl_checkbox",function(){
        console.log('checked');
        $.post('<?=base_url("admin/payment_gateway/change_status")?>',
        {
            '<?php echo $this->security->get_csrf_token_name(); ?>' : '<?php echo $this->security->get_csrf_hash(); ?>',
            id : $(this).data('id'),
            status : $(this).is(':checked') == true?1:0
        },
        function(data, status){
            $.notify("Status Changed Successfully", "success");
            //alert(data); // this is to test the result
        });
    });
    
    $("body").on("change",".tgl_sandbox",function(){
        console.log('checked');
        $.post('<?=base_url("admin/payment_gateway/change_sandbox")?>',
        {
            '<?php echo $this->security->get_csrf_token_name(); ?>' : '<?php echo $this->security->get_csrf_hash(); ?>',
            id : $(this).data('id'),
            sandbox : $(this).is(':checked') == true?1:0
        },
        function(data, status){
            $.notify("Sandbox Changed Successfully", "success");
            //alert(data); // this is to test the result
        });
    });
</script>