<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_role extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'RoleID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'RoleName' => array(
                'type' => 'VARCHAR',
                'constraint' => 12,
                'null' => TRUE
            ),
            'RoleDescription' => array(
                'type' => 'VARCHAR',
                'constraint' => 128,
                'null' => TRUE
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('RoleID', TRUE);
        $this->dbforge->create_table('roles');

        $data = array(
            array('RoleName' => 'SuperAdmin','RoleDescription' => 'super admin'),
            array('RoleName' => 'Admin','RoleDescription' => 'This will include Account Managers'),
            array('RoleName' => 'Contractor','RoleDescription' => 'contractor'),
            array('RoleName' => 'Agent','RoleDescription' => 'agent')
        );
        $this->db->insert_batch('roles', $data);
    }

    public function down() {
        $this->dbforge->drop_table('roles');
    }

}