<?php
use Restserver\Libraries\REST_Controller;
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';

class Vicidata_api extends REST_Controller  {

    function __construct($config = 'rest') {
        parent::__construct($config);
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Authorization");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $method = $_SERVER['REQUEST_METHOD'];
        
       
        if ($method == "OPTIONS") {
            die();
        }
        
        
        $this->load->helper('my_api');
        
        $this->methods['report']['limit'] = 100;
        
    }
    
    
    public function report_get($time_range = null){
            
            $data=array();
            if(!empty($time_range)){
                $time_range = urldecode($time_range);
                $timeRangeSplit = explode("to",$time_range);
                $time_range = $timeRangeSplit[0] ." to ".$timeRangeSplit[1];
                 $query = "SELECT U.HourlyRate,count(A.AppointmentID) as sales, COUNT(IF(A.Status = 'Rejected' || A.Status = 'Duplicate' || A.Status = 'Call Back Needed', 1, NULL)) as declines ,`USER`, V.*, Quota, perappt, hourlyrate, A.Status, A.Created_at FROM `Vicidata` V inner join users U on U.Vici_ID = V.vici_ID left outer join appointments A on U.UserID = A.AssignedTo where `TimeRange` ='".$time_range."' and (A.Created_at BETWEEN '".trim($timeRangeSplit[0])."' and '".trim($timeRangeSplit[1])."' or A.Created_at is NULL ) group by Vici_ID ORDER BY V.USER ASC, A.AppointmentID";
                $result = $this->db->query($query);
                $count= 0;
                
                
                foreach ($result->result_array() as $row){
                   
                    $callToSecDiscPortion = ($row['CALLS']*60)/4;
                    
                    if($this->timeToSec($row['DISPO']) > $callToSecDiscPortion){
                        $over_dispo = $this->timeToSec($row['DISPO']) - $callToSecDiscPortion;
                        $row['over_dispo'] =  $this->secToTime($over_dispo);
                        $data['total']['over_dispo'] = isset($data['total']['over_dispo'])? $data['total']['over_dispo']  + $over_dispo : $over_dispo;
                       
                        
                    }else{
                        $row['over_dispo'] = '00:00';
                        $data['total']['over_dispo'] = isset($data['total']['over_dispo'])? $data['total']['over_dispo'] : 0;
                    }
                    $row['net_sale'] = $row['sales'] -$row['declines'];
                    
                    $data['total']['sales'] = isset($data['total']['sales'])? $data['total']['sales'] + $row['sales'] : $row['sales'];
                    $data['total']['declines'] = isset($data['total']['declines'])? $data['total']['declines'] + $row['declines'] : $row['declines'];
                    
                    
                    $workingHours = ($this->timeToSec($row['WAIT']) + $this->timeToSec($row['TALK']) + $this->timeToSec($row['DISPO'])) - $this->timeToSec($row['over_dispo'].":00");
                    $data['total']['works_hours'] = isset($data['total']['works_hours'])? $data['total']['works_hours'] + $workingHours : $workingHours;
                    $row['works_hours'] = $this->secToTime($workingHours);
                    
                    $quota_hours = $this->timeToSec($row['Quota']) * ($row['net_sale']);
                    $row['quota_hours'] = $this->secToTime($quota_hours);
                    $data['total']['quota_hours'] = isset($data['total']['quota_hours'])? $data['total']['quota_hours']  + $quota_hours : $quota_hours;
                    
                    $max_paid_hours = MIN($this->timeToSec($row['quota_hours'].":00"),$this->timeToSec($row['works_hours'].":00"));
                    $row['max_paid_hours'] = $this->secToTime($max_paid_hours);
                    $data['total']['max_paid_hours'] = isset($data['total']['max_paid_hours'])? $data['total']['max_paid_hours']  + $max_paid_hours : $max_paid_hours;
                    
                    $row['appts_per_hour'] = ($row['net_sale']) == 0 ? round($this->timeToSec($row['works_hours'].":00") /(60*60),2) : round((($row['net_sale']) * 60*60)/$this->timeToSec($row['max_paid_hours'].":00"),2); 
                    
                    $row['appts_per_hour_is_postive'] = ($row['net_sale']) == 0 ? 0 : 1;
                    $row['decline_rate'] = $row['sales'] == 0 ? '' :round((($row['declines']  /$row['sales'])*100),2)."%";
                    $row['appts_per_1k'] = $row['CALLS'] == 0 ? 0 : round(($row['sales']/$row['CALLS'])*1000,2);
                    $row['rank'] = 0;
                    
                    $row['rank_sort_parameter'] = $row['appts_per_hour'] + $row['net_sale'];
                    
                    $pay = ($this->timeToSec($row['max_paid_hours'].":00")/3600) * $row['HourlyRate'] + ($row['net_sale'] *  $row['perappt'] );
                    $row['pay'] = round($pay,2);
                    $data['total']['pay'] = round(isset($data['total']['pay'])? $data['total']['pay']  + $pay : $pay,2);
                    
                    $row['cost_per_lead'] = ($pay <= 0 || $row['net_sale'] <= 0) ? 0 :round( $pay/$row['net_sale'],2);
                   
                    
                    
                    
                    $data['data'][] = $row;
                    $data['total']['CALLS'] = isset($data['total']['CALLS'])? $data['total']['CALLS']  + $row['CALLS'] : $row['CALLS'];
                    $data['total']['net_sale'] = isset($data['total']['net_sale'])? $data['total']['net_sale']  + $row['net_sale'] : $row['net_sale'];
                    
                    
                   
                    
                    $count++;
                }
                
                $rankToSort = array_column($data['data'], 'rank_sort_parameter');
                
                arsort($rankToSort);
                
                $rankCounter = 1;
                foreach($rankToSort as $keySort => $valSort){
                    $rank = 0;
                    if($valSort >= 8){
                        $rank = $rankCounter;
                        $rankCounter++;
                    }
                    
                    if($rank == 1){
                       $data['data'][$keySort]['bonus'] =  $data['data'][$keySort]['net_sale'] * 5;
                    }elseif($rank ==2){
                        $data['data'][$keySort]['bonus'] =  $data['data'][$keySort]['net_sale'] * 2;
                    }elseif($rank ==3){
                        $data['data'][$keySort]['bonus'] =  $data['data'][$keySort]['net_sale'] * 1;
                    }else{
                        $data['data'][$keySort]['bonus'] = 0; 
                    }
                    
                    $data['total']['bonus'] = isset($data['total']['bonus'])? $data['total']['bonus']  + $data['data'][$keySort]['bonus'] : $data['data'][$keySort]['bonus'];
                    
                    $data['data'][$keySort]['rank'] = $rank;
                }
                
                $data['total']['over_dispo'] = $this->secToTime($data['total']['over_dispo']);
                $data['total']['works_hours'] = $this->secToTime($data['total']['works_hours']);
                $data['total']['quota_hours'] = $this->secToTime($data['total']['quota_hours']);
                $data['total']['max_paid_hours'] = $this->secToTime($data['total']['max_paid_hours']);
                
                 $data['total']['cost_per_lead'] = round(($data['total']['pay']/$data['total']['net_sale']),2);
                
          
            }
            echo json_encode($data);
        
    }
    
    private function timeToSec($time) {
    	list($h, $m, $s) = explode(':', $time);
    	return ($h * 3600) + ($m * 60) + $s;
    }

    private function secToTime($seconds,$secondAllowed=false) {
      $hours = floor($seconds / 3600);
      $hours = str_pad($hours,2,"0",STR_PAD_LEFT);
      $minutes = floor(($seconds / 60) % 60);
      $minutes = str_pad($minutes,2,"0",STR_PAD_LEFT);
      $seconds = $seconds % 60;
      $seconds = str_pad($seconds,2,"0",STR_PAD_LEFT);
      if($secondAllowed){
         return "$hours:$minutes:$seconds"; 
      }else{
          return "$hours:$minutes";
      }
      
    }

   
}