<?php defined('BASEPATH') OR exit('No direct script access allowed');
    class Segment extends MY_Controller {
        function __construct(){
            parent::__construct();
            $this->load->model('admin/segment_model', 'segmentmd');
            $this->load->library('datatable'); // loaded my custom serverside datatable library
            
           // $this->rbac->check_module_access();
        }

        public function index(){
            //echo $this->session->userdata('admin_role_id')."<br />";
            //echo $this->session->userdata('admin_role')."<br />";
            //$data['modaccess'] = $this->rbac->get_module_access();
            //$sess_arr = $this->session->userdata();
            //$sess_arr = $this->session->userdata('module_access');
            //echo "<pre>"; print_r($sess_arr); echo "</pre>";
            $data['view'] = 'admin/segment/segment_list';
            $this->load->view('layout', $data);
        }

        public function get_datatable_json(){
            $this->load->library('utils');
            $op = $this->utils->action_validate_role( $this->session->userdata('admin_role') ); //echo "op: ".$op."<br />";

            $rec = $this->segmentmd->segment_get_all();
            $data = array();
            $i=0;
            foreach ($rec['data']  as $row){
                $status = ($row['is_active'] == 1)? 'checked': '';

                $lnk_mod    = base_url('admin/segment/edit/'.$row['segment_id']);
                $lnk_del    = base_url('admin/segment/delete/'.$row['segment_id']);
                $lnk_sflow  = base_url('admin/segment_flow/'.$row['segment_id']);
                $lnk_assign = base_url('admin/segment/assigned_prods/'.$row['segment_id']);

                // shop/SEGOPT001/1231230001/4564560001/50101/30101
                $rnum    = mt_rand();
                $npart1 = substr($rnum, -4);
                $npart2 = substr($rnum, 0, 3);
                $segcode = $row['segment_code'];
                $cspn    = '123123'.$npart1;
                $did     = '456456'.$npart1;
                $agentid = '50'.$npart2;
                $recid   = '30'.$npart2;
                
                $lnk_test   = base_url().'shop/'.$segcode.'/'.$cspn.'/'.$did.'/'.$agentid.'/'.$recid;

                $action = '';
                //$action .= '<a title="View" class="view btn btn-sm btn-info" href="'.base_url('admin/segment/edit/'.$row['segment_id']).'"> <i class="fa fa-eye"></i></a> ';
                $action .= '<a title="Edit" class="update btn btn-sm btn-warning" href="'.$lnk_mod.'"> <i class="fa fa-pencil-square-o"></i></a> ';
                $action .= '<a title="Delete" class="delete btn btn-sm btn-danger" data-href="'.$lnk_del.'" data-toggle="modal" data-target="#confirm-delete"> <i class="fa fa-trash-o"></i></a> ';
                $action .= '<a title="Manage Segment Flow" class="view btn btn-sm btn-success" href="'.$lnk_sflow.'">Seg. Flow</a> ';
                $action .= '<a title="Assign Products to Segment" class="view btn btn-sm btn-blue1" href="'.$lnk_assign.'">Assign Prod</a> ';
                if( $row['is_init'] == '1' ){
                    $action .= '<a title="View" class="view btn btn-sm btn-white_red1" href="'.$lnk_test.'" target="_blank">Test Seg.</a> ';
                }

                $segment_text = $this->utils->mysql_decode_val($row['segment_text']);
                $segment_text = $this->utils->get_truncate_str($segment_text, 6);
                $rec_client = $this->segmentmd->get_client_by_id($row['client_pid']);
                $is_init = 'No';
                if( $row['is_init'] == '1' ){ $is_init = 'Yes'; }

                $data[]= array(
                    ++$i,
                    $row['segment_name'],
                    $row['segment_code'],
                    $segment_text.'...',
                    $row['segment_question'],
                    $is_init,
                    '<input class="tgl_checkbox tgl-ios" data-id="'.$row['segment_id'].'" id="cb_'.$row['segment_id'].'" type="checkbox" '.$status.'><label for="cb_'.$row['segment_id'].'"></label>',
                    $rec_client['name'],
                    $action
                );
            }
            $rec['data']=$data;
            echo json_encode($rec); 
        }

        public function delete($id = 0){
            $this->rbac->check_operation_access();
            
            //$segment_id = $this->uri->segment(4);
            $this->segmentmd->segment_delete($id);
            $this->session->set_flashdata('msg', 'The Segment has been deleted successfully!');
            redirect(base_url('admin/segment'));
        }

        public function change_status(){
            $status = $this->input->post('status');
            $id = $this->input->post('id');
            $res = $this->segmentmd->segment_change_status($id, $status);
            //echo "affected rows: ".$res;
        }

        public function add(){
            $this->rbac->check_operation_access();
            
            $this->load->library('utils');

            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_segment_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_segment_code', 'Code', 'trim|required');
                $this->form_validation->set_rules('fv_segment_text', 'Text', 'trim|required');
                $this->form_validation->set_rules('fv_segment_question', 'Question', 'trim|required');
                $this->form_validation->set_rules('fv_is_init', 'Is Initial', 'trim|required');
                $this->form_validation->set_rules('fv_is_active', 'Status', 'trim|required');
                $this->form_validation->set_rules('fv_client', 'Client', 'trim|required');

                if ($this->form_validation->run() == FALSE) {
                    $rec_client = $this->segmentmd->get_clients();
                    $data['rec_client'] = $rec_client;
                    $data['view'] = 'admin/segment/segment_add';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                        'segment_name'     => $this->utils->mysql_encode_val($this->input->post('fv_segment_name')),
                        'segment_code'     => $this->input->post('fv_segment_code'),
                        'segment_text'     => $this->utils->mysql_encode_val($this->input->post('fv_segment_text')),
                        'segment_question' => $this->utils->mysql_encode_val($this->input->post('fv_segment_question')),
                        'is_init'          => $this->input->post('fv_is_init'),
                        'is_active'        => $this->input->post('fv_is_active'),
                        'client_pid'       => $this->input->post('fv_client')
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->segmentmd->segment_add($data);
                    if($result){
                        $this->session->set_flashdata('msg', 'Segment has been added successfully!');
                        redirect(base_url('admin/segment'));
                    }
                }
            }
            else{
                $rec_client = $this->segmentmd->get_clients();
                $data['rec_client'] = $rec_client;
                $data['view'] = 'admin/segment/segment_add';
                $this->load->view('layout', $data);
            }
        }

        public function get_segment_decoded($id){
            $data_arr = array();
            $rec = $this->segmentmd->get_segment_by_id($id); //echo "<pre>"; print_r($rec); echo "</pre>";
            
            $data_arr['segment_id'] = $rec['segment_id'];
            $data_arr['segment_name'] = $this->utils->mysql_decode_val($rec['segment_name']);
            $data_arr['segment_code'] = $rec['segment_code'];
            $data_arr['segment_text'] = $this->utils->mysql_decode_val($rec['segment_text']);
            $data_arr['segment_question'] = $this->utils->mysql_decode_val($rec['segment_question']);
            $data_arr['is_init'] = $rec['is_init'];
            $data_arr['is_active'] = $rec['is_active'];
            $data_arr['client_pid'] = $rec['client_pid'];

            return $data_arr;
        }

        public function edit($id = 0){
            $this->rbac->check_operation_access();

            $this->load->library('utils');

            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_segment_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_segment_code', 'Code', 'trim|required');
                $this->form_validation->set_rules('fv_segment_text', 'Text', 'trim|required');
                $this->form_validation->set_rules('fv_segment_question', 'Question', 'trim|required');
                $this->form_validation->set_rules('fv_is_init', 'Is Initial', 'trim|required');
                $this->form_validation->set_rules('fv_is_active', 'Status', 'trim|required');
                $this->form_validation->set_rules('fv_client', 'Client', 'trim|required');

                if( $this->form_validation->run() == FALSE ){
                    
                    $rec['segment_id'] = $id;
                    $rec['segment_name'] = $this->input->post('fv_segment_name');
                    $rec['segment_code'] = $this->input->post('fv_segment_code');
                    $rec['segment_text'] = $this->input->post('fv_segment_text');
                    $rec['segment_question'] = $this->input->post('fv_segment_question');
                    $rec['is_init'] = $this->input->post('fv_is_init');
                    $rec['is_active'] = $this->input->post('fv_is_active');
                    $rec['client_pid'] = $this->input->post('fv_client');
                
                    $rec_client = $this->segmentmd->get_clients();
                    
                    $data['rec'] = $rec;
                    $data['rec_client'] = $rec_client;
                    $data['view'] = 'admin/segment/segment_edit';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                        'segment_name'     => $this->utils->mysql_encode_val($this->input->post('fv_segment_name')),
                        'segment_code'     => $this->input->post('fv_segment_code'),
                        'segment_text'     => $this->utils->mysql_encode_val($this->input->post('fv_segment_text')),
                        'segment_question' => $this->utils->mysql_encode_val($this->input->post('fv_segment_question')),
                        'is_init'          => $this->input->post('fv_is_init'),
                        'is_active'        => $this->input->post('fv_is_active'),
                        'client_pid'       => $this->input->post('fv_client')
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->segmentmd->segment_edit($data, $id);
                    if($result){
                        $this->session->set_flashdata('msg', 'Segment has been updated successfully!');
                        redirect(base_url('admin/segment'));
                    }
                }
            }
            else{
                $rec = $this->get_segment_decoded($id); //echo "<pre>"; print_r($rec); echo "</pre>";
                $rec_client = $this->segmentmd->get_clients();

                $data['rec'] = $rec;
                $data['rec_client'] = $rec_client;
                $data['view'] = 'admin/segment/segment_edit';
                $this->load->view('layout', $data);
            }
        }
        
        //public function prodlist($cod01){
        public function assigned_prods($cod01){
            $this->rbac->check_operation_access();

            $data['rec'] = $this->segmentmd->get_segment_by_id($cod01);
            $data['cod01'] = $cod01;
            $data['view'] = 'admin/segment/segment_assignedprods';
            $this->load->view('layout', $data);

        }

        public function get_prod_datatable_json( $segment_id ){
            $this->load->library('utils');
            //$op = $this->utils->action_validate_role( $this->session->userdata('admin_role') ); //echo "op: ".$op."<br />";

            $rec = $this->segmentmd->segment_product_get_all( $segment_id );
            $data = array();
            $i=0;
            foreach ($rec['data']  as $row){
                //$status = ($row['is_active'] == 1)? 'checked': '';
                $action = '<a title="Delete" class="delete btn btn-sm btn-danger" data-href="'.base_url('admin/segment/delete_prod/'.$row['segment_pid'].'/'.$row['product_pid']).'" data-toggle="modal" data-target="#confirm-delete"> <i class="fa fa-trash-o"></i></a>';
                $data[]= array(
                    ++$i,
                    $row['product_name'],
                    $row['product_sku'],
                    $row['price'],
                    //'<input class="tgl_checkbox tgl-ios" data-id="'.$row['segment_id'].'" id="cb_'.$row['segment_id'].'" type="checkbox" '.$status.'><label for="cb_'.$row['segment_id'].'"></label>',
                    $action
                );
            }
            $rec['data']=$data;
            echo json_encode($rec); 
        }

        public function delete_prod($cod01 = 0, $id){
            $this->rbac->check_operation_access();
            
            //$segment_id = $this->uri->segment(4);
            $this->segmentmd->segment_delete_prod($cod01, $id);
            $this->session->set_flashdata('msg', 'The Product has been removed successfully!');
            redirect(base_url('admin/segment/assigned_prods/'.$cod01.'/'));
        }

        public function get_prodlist_datatable_json( $cod01 ){
            $rec = $this->segmentmd->product_get_all();
            $data = array();
            $i=0;
            foreach ($rec['data']  as $row){
                //$status = ($row['is_active'] == 1)? 'checked': '';
                $assignLink = base_url('admin/segment/prodlist/sub1/'.$cod01.'/'.$row['product_id']);
                $action = '';
                //$action .= '<a title="Delete" class="delete btn btn-sm btn-danger" data-href="'.base_url('admin/segment/delete_prod/'.$cod01.'/'.$row['product_id']).'" data-toggle="modal" data-target="#confirm-delete"> <i class="fa fa-trash-o"></i></a>';
                $action .= '<a title="Manage Segment Flow" class="view btn btn-sm btn-blue1" href="'.$assignLink.'">Assign this</a>';
                $data[]= array(
                    ++$i,
                    $row['product_name'],
                    $row['product_sku'],
                    $row['price'],
                    $action
                );
            }
            $rec['data']=$data;
            echo json_encode($rec);
        }

        public function prodlist( $flag, $cod01, $prodid ){
            $this->rbac->check_operation_access();
            
            $msg = "";
            if( $flag == 'sub1' ){
                
                //echo "cod01: ".$cod01."<br />";
                //echo "prodid: ".$prodid."<br />";

                $rs = $this->segmentmd->product_segment($cod01, $prodid);
        
                if( count( $rs ) == 0 ){
                    $data = array(
                        'segment_pid' => $cod01,
                        'product_pid' => $prodid,
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->segmentmd->product_segment_add($data);
                    if($result){
                        $this->session->set_flashdata('msg', 'Product has been assigned successfully!');
                        redirect(base_url('admin/segment/assigned_prods/'.$cod01));
                    }
                }
                else{
                    $data['msg'] = "The Product is already assigned"; //$msg;
                    $data['rec'] = $this->segmentmd->get_segment_by_id($cod01);
                    $data['cod01'] = $cod01;
                    $data['view'] = 'admin/segment/segment_prodlist';
                    $this->load->view('layout', $data);
                }
                
                
            }
            else{
                $data['msg'] = $msg;
                $data['rec'] = $this->segmentmd->get_segment_by_id($cod01);
                $data['cod01'] = $cod01;
                $data['view'] = 'admin/segment/segment_prodlist';
                $this->load->view('layout', $data);
            }
            
        }

        public function prodadd($cod01, $prod_id){
            $data = array(
                'q_pid' => $q_id,
                'admin_pid' => $user_id,
                'user_type' => 'u',
                'is_done' => '0',
                'data' => '',
                'date_n' => '0',
                'date_d' => '00-00-00 00:00:00'

            );
            $data = $this->security->xss_clean($data);
            $result = $this->user_question_model->assign($data);
            if($result){
                $this->session->set_flashdata('msg', 'Support file has been assigned successfully!');
                redirect(base_url('admin/user_question/'.$params));
            }
        }
    }
?>