<?php defined('BASEPATH') OR exit('No direct script access allowed');

	class Rent extends MY_Controller {
		function __construct(){
        parent::__construct();
        $this->load->library('rbac');
        $this->load->model('admin/rent_model', 'rent');
		$this->load->model('admin/payment_model', 'payment_model');
        $this->rbac->check_module_access();
		}	
	
		public function rent_demand_register(){
			
			$data['autoid'] = $this->rent->get_rent_last_id();
			$data['wards'] = $this->rent->get_all_wards();
			$data['year'] = $this->rent->get_finnacial_year_latest();
			$data['property'] = $this->rent->get_property_type();
			$data['title']="Rent";
			$data['view'] = 'admin/rents/add';
			$this->load->view('layout', $data);
		}

		public function get_mohalla()
		{
			$ward_id=$this->input->post("ward");

			$ward=$this->security->xss_clean($ward_id);
			
			$ward_sno = $this->rent->get_ward_no($ward);
			//print_r($ward_no['ward_no']);
			$ward_no = $ward_sno[0]->ward_no;
			$mohalla = $this->rent->get_all_mohalla($ward);

			$output="<option value='' >-- मोहल्ले का नाम --</option>";

			if(!$mohalla=='')
			{
				foreach($mohalla as $moh)
				{
					$output.="<option value='".$moh->id."' >".$moh->name."</option>";
				}
				
			}
			else
			{
				$output.="<option>No mohalla founds</option>";
			}
			$wardnewid = str_pad($ward_no,3,"0",STR_PAD_LEFT);
			$proidNum = '484'.$wardnewid.''.$this->rent->get_rent_last_id();
			echo json_encode(array('output'=>$output,'pronum'=>$proidNum));


		}
		public function get_market()
		{
			$ward_id=$this->input->post("ward");
			$village_id=$this->input->post("village");

			$ward=$this->security->xss_clean($ward_id);
			
			$ward_sno = $this->rent->get_ward_no($ward);
			
			$ward_no = $ward_sno[0]->ward_no;
			
			$village=$this->security->xss_clean($village_id);
			
			$village_sno = $this->rent->get_mohalla_no($village);
			$village_no = $village_sno[0]->mohalla_code;
			$mohalla = $this->rent->get_all_market($ward,$village);

			$output="<option value='' >-- बाजार का नाम --</option>";

			if(!$mohalla=='')
			{
				foreach($mohalla as $moh)
				{
					$output.="<option value='".$moh->id."' >".$moh->market_name."</option>";
				}
				
			}
			else
			{
				$output.="<option>No Market founds</option>";
			}
			$wardnewid = str_pad($ward_no,3,"0",STR_PAD_LEFT);
			$villnewid = str_pad($village_no,2,"0",STR_PAD_LEFT);
			$proidNum = '484'.$wardnewid.''.$villnewid.''.$this->rent->get_rent_last_id();
			echo json_encode(array('output'=>$output,'pronum'=>$proidNum));

		}
		public function get_auto_pronum()
		{
			$ward_no=$this->input->post("ward");
			$village_no=$this->input->post("village");
			$market_no=$this->input->post("market");
			
			$ward=$this->security->xss_clean($ward_no);
			$ward_sno = $this->rent->get_ward_no($ward);
			
			$ward_no = $ward_sno[0]->ward_no;
			$village=$this->security->xss_clean($village_no);
			$village_sno = $this->rent->get_mohalla_no($village);
			$village_no = $village_sno[0]->mohalla_code;
			$market=$this->security->xss_clean($market_no);			
			$wardnewid = str_pad($ward_no,3,"0",STR_PAD_LEFT);
			$villnewid = str_pad($village_no,2,"0",STR_PAD_LEFT);
			if($market_no>0)$marketnewid = str_pad($market_no,3,"0",STR_PAD_LEFT);
			$proidNum = '484'.$wardnewid.''.$villnewid.''.$marketnewid.''.$this->rent->get_rent_last_id();
			echo json_encode(array('pronum'=>$proidNum));

		}

		public function pay(){
			$data['title']="Rent Payment";
			$data['view'] = 'admin/rents/pay';
			$this->load->view('layout', $data);
		}
		public function view_bill(){
			$data['title']="View bill";
			$data['view'] = 'admin/rents/view_bill';
			$this->load->view('layout', $data);
		}
		public function defaulter(){
			$data['title']="Defaulter List";
			$data['info'] = $this->rent->get_all();
			$data['year'] = $this->rent->get_finnacial_year();
			//$data['view'] = 'admin/rents/lists';
			//$this->load->view('layout', $data);
			$data['view'] = 'admin/rents/defaulter';
			$this->load->view('layout', $data);
		}

		public function defaulter_active_data_by_search()
		{
			
			$typeby=$this->input->post("type_by");
			$selectbox=$this->input->post('select_box');
			$listby=$this->input->post('list_by');			
			$type_by=$this->security->xss_clean($typeby);
			$select_box=$this->security->xss_clean($selectbox);
			$list_by=$this->security->xss_clean($listby);
			$draw=intval($this->input->post("draw"));
			$start=$this->input->post("start");
			$length=$this->input->post("length");
			//$total_rows=$this->rent->count_search($select_box,$type_by,$list_by);
			$data['draw'] = $draw;
    		//$data['recordsTotal'] = $total_rows;
    		//$data['recordsFiltered'] = $total_rows;
			$result=$this->rent->show_table_search($select_box,$length,$start,$type_by,$list_by);
			// echo"<pre>";
			 //print_r($result);
			// die;		
			$res=array();
    		
    		foreach($result as $r)
			{
				$Market_names = $this->rent->get_MarketALL($r['market']);

				$res[]=array(
						"rent_demand_registerid"=>$r['rent_demand_registerid'],
						"property_id_number"=>$r['property_id_number'],
						"property_number"=>$r['property_number'],
						"ward_no"=>$r['ward'],
						"m_name"=>$r['village_address'],
						"market"=>$Market_names[0]->market_name,
						"father_name"=>$r['father_name'],
						"mobile_number"=>$r['mobile_number'],
						"property"=>$r['property_type'],
						"allotment_date"=>$r['allotment_date'],
						"month_name"=>$r['month_name'],
						"demand_current_month_rent"=>$r['demand_current_month_rent'],
						"demand_due_rent"=>$r['demand_due_rent'],
						"demand_gst"=>$r['demand_gst'],
						"demand_late_fee"=>$r['demand_late_fee'],
						"demand_total_deposit_money"=>$r['demand_total_deposit_money'],
						"deposit_current_month"=>$r['deposit_current_month'],
						"deposit_outstanding_deposit"=>$r['deposit_outstanding_deposit'],
						"deposit_gst"=>$r['deposit_gst'],
						"deposit_late_fee"=>$r['deposit_late_fee'],
						"deposit_total_pay"=>$r['deposit_total_pay'],
						"deposit_receipt_number"=>$r['deposit_receipt_number'],
						"deposit_receipt_date"=>$r['deposit_receipt_date'],
						"deposit_depositor"=>$r['deposit_depositor'],
						"deposit_comment"=>$r['deposit_comment'],
				);
			}	
			$data['data']=$res;
			echo json_encode($data);
		}
		
		public function advance_datatable_json($id){
			//echo $id;
			$records = $this->rent->get_all_by_json_search($id);
			$data = array();
			$i=0;
			foreach ($records['data']  as $row) 
			{  
				$status = ($row['is_active'] == 1)? 'checked': '';
				$Market_names = $this->rent->get_MarketALL($row['market']);
				$bakaya = $row['demand_due_rent']-$row['deposit_outstanding_deposit'];
				if($bakaya> 0)
				{
					$bakaya = $bakaya;
				}else
				{
					$bakaya = 0;
				}
				$bakayagst = $row['demand_total_gst']-$row['deposit_total_gst'];
				$awashesh_amount = $row['awashesh_amount'];
				if($bakayagst<0) $awashesh_amount = $row['awashesh_amount'] - abs($bakayagst);
				if($bakayagst >0 )
				{
					$bakayagst = $bakayagst;
				}
				else{
					$bakayagst = 0;
				}
				if($awashesh_amount < 0) $awashesh_amount =0;
				$currentamount = $row['total_annual_deposit_money'];
				if($awashesh_amount <= 0) $currentamount = 0;
				//echo $Market_names[0]->market_name;
				/*<a href="delete/'.$row['rent_demand_registerid'].'/'.$id.'" onclick="return confirm("are you sure to delete?")" title="Delete" class="btn btn-danger btn-xs"><i class="fa fa-remove"></i></a>*/
				$allotment_date ='';
				if($row['allotment_date']>0)$allotment_date = date_time($row['allotment_date']);
				$data[]= array(
					$row['rent_demand_registerid'],
					'<a href="edit/'.$row['rent_demand_registerid'].'/'.$id.'" class="btn btn-warning btn-xs mr5" title="Edit" ><i class="fa fa-edit"></i></a>',
					$row['property_id_number'],
					$row['property_number'],
					$row['ward_name'],
					$row['m_name'],
					$Market_names[0]->market_name,
					$row['father_name'],
					$row['mobile_number'],					
					$row['month_name'],
					$row['demand_current_month_rent'],
					$row['total_annual_deposit_money'],
					$row['demand_due_rent'],
					$row['demand_total_deposit_money_yog'],
					$row['demand_gst'],
					$row['demand_bakaya_gst'],
					$row['demand_total_gst'], 
					$row['deposit_current_month'],					
					$row['deposit_outstanding_deposit'],
					$row['deposit_total_pay'],					
					$row['deposit_gst'],
					$row['deposit_bakaya_gst'],
					$row['deposit_total_gst'],
					$row['deposit_receipt_number'],
					$row['deposit_receipt_date'],
					$row['deposit_depositor'],
					$currentamount,
					$bakaya,
					$bakayagst,
					$awashesh_amount,					
					$row['deposit_comment']
				);
			}
			$records['data']=$data;
			echo json_encode($records);						   
		}
		function insert_rent_demand()
		{			
			$message = 1;    
			$this->load->library('form_validation');
			$this->load->model('rent_model');       
			$data = $this->input->post();
			
			$this->form_validation->set_data($data);
			$data['created_at']= date('Y-m-d');
			$data['is_active'] = 0;
			$table = 'rent_demand_register_details_'.trim($data['financial_year']);
			//print_r($data);
			//die;
			$this->db->insert($table,$data);			
			redirect('admin/rent/rent_demand_register/'. $message);
		}
		function update_rent_demand()
		{
			
			$message = 0;    
			$this->load->library('form_validation');
			$this->load->model('rent_model');       
			$data = $this->input->post();
			$this->form_validation->set_data($data);
			$id = $this->input->post('rent_demand_registerid');
			$data['created_at']= date('Y-m-d');
			$data['is_active'] = 1;
			$result = $this->rent->edit_admin($data, $id);
			//print_r($result);
			if($this->input->post('deposit_total_pay') >0 && $this->input->post('demand_total_deposit_money') >0){
			$total_records=$this->payment_model->get_total_records();
			$receiptno=$total_records+1;
			$paydata['rent_demand_registerid']=$this->input->post('rent_demand_registerid');
			$paydata['property_id_number']=$this->input->post('property_id_number');
			$paydata['financial_year']=$this->input->post('financial_year');
			$paydata['deposit_outstanding_deposit']=$this->input->post('deposit_outstanding_deposit');
			$paydata['deposit_gst']=$this->input->post('deposit_bakaya_gst');
			$paydata['deposit_late_fee']=$this->input->post('deposit_late_fee');
			$paydata['deposit_total_pay']=$this->input->post('deposit_total_pay');
			$paydata['deposit_receipt_number']=$this->input->post('deposit_receipt_number');
			$paydata['deposit_receipt_date']=$this->input->post('deposit_receipt_date');
			$paydata['deposit_depositor']=$this->input->post('deposit_depositor');
			$paydata['deposit_comment']=$this->input->post('deposit_comment');
			$paydata['paid_at']=date('Y-m-d');
			$paydata['paid_amount']=$this->input->post('deposit_total_pay')-$this->input->post('deposit_total_gst');
			$paydata['paid_partial_or_full']='partial';
			$paydata['payment_mode']='cash';
			$this->db->insert('rent_demand_register_payments',$paydata);
			$recept_id = $this->db->insert_id();
			if($recept_id){
				
			//$this->db->set('demand_total_gst',$this->input->post('demand_total_gst')-$this->input->post('deposit_bakaya_gst'));
			//$this->db->set('demand_total_deposit_money_yog',$this->input->post('demand_total_deposit_money_yog')-$this->input->post('deposit_outstanding_deposit'));			
			//$this->db->set('demand_bakaya_gst',$this->input->post('demand_bakaya_gst')-$this->input->post('deposit_bakaya_gst'));
			//$this->db->set('demand_due_rent',$this->input->post('demand_due_rent')-$this->input->post('deposit_outstanding_deposit'));
			//$this->db->set('demand_total_deposit_money',$this->input->post('demand_total_deposit_money')-$this->input->post('deposit_total_pay'));
			$awashesh_amount_pending = $this->input->post('demand_total_deposit_money') - $this->input->post('deposit_total_pay');
			$this->db->set('awashesh_amount ',$awashesh_amount_pending);
			$table = 'rent_demand_register_details_'.trim($data['financial_year']);
			$this->db->where('rent_demand_registerid',$id);
			$this->db->update($table);
			
			}
			//echo $this->input->post('demand_total_deposit_money') - $this->input->post('deposit_total_pay');
			/*if($this->input->post('demand_total_deposit_money') === $this->input->post('deposit_total_pay') && !empty($recept_id))
			{			
			 $this->db->set('awashesh_amount ',0);
			 $this->db->where('property_id_number',$this->input->post('property_id_number'));
			 $this->db->update('rent_demand_register_details');	
			}else
			{
			$awashesh_amount_pending = $this->input->post('demand_total_deposit_money') - $this->input->post('deposit_total_pay');
			 $this->db->set('awashesh_amount ',0);
			 $this->db->where('property_id_number',$this->input->post('property_id_number'));
			 $this->db->update('rent_demand_register_details');
			}*/
			}
			//print_r($paydata);
			//die;
            if( $result ){
                            //$this->session->set_flashdata('msg', 'Admin has been updated successfully!');
						   $message = 3;  
                           redirect('admin/rent/rent_demand_register/'. $message);
                         }
			//$this->db->insert('rent_demand_register_details',$data);        
			//$this->rent_model->insert($data);
			//redirect('admin/rent/rent_demand_register/'. $message);
		}
		function list_data(){
			$this->session->set_userdata('property_id_number',$this->input->post('property_id_number'));
			$this->session->set_userdata('property_number',$this->input->post('property_number'));
			$this->session->set_userdata('market',$this->input->post('market'));
			$this->session->set_userdata('father_name',$this->input->post('father_name'));
			$data['year'] = $this->rent->get_finnacial_year();
			$data['info'] = $this->rent->get_all();
			$data['view'] = 'admin/rents/lists';
			$this->load->view('layout', $data);
		}
		
		public function edit($id="",$fny=""){
			
			$data['title']="Rent";
			$this->load->library('utils');
			$jma_rent = $this->rent->getdata_rentpayment($id,$fny);
			$total = $jma_rent['total'];
			$paidtotal = $jma_rent['paidtotal'];
			$pendingamt = ($total - $paidtotal);// totalamt - totalpaidamt
			$pendingtotal = $pendingamt; //total pending amt
			$currentm = $jma_rent['deposit_outstanding_deposit'];
			$currentgst = $jma_rent['deposit_gst'];
			$currentlatefee = $jma_rent['deposit_late_fee'];			
			$deposit_month = $jma_rent['paid_at'];
			$month = explode("-",$deposit_month);			
			$depo_month = empty($month[1]); //deposit date month 
			$current_month= date('Y-m-d');		
			$cmonth = explode("-",$current_month);
			$curent_month = $cmonth[1]; // current running month
			$month_latefee = $curent_month-$depo_month;
			$total_latefee = $month_latefee * $currentlatefee; // total late fee (depost mont - curent month = latefee x month)			
			$currentpending = $pendingtotal;			
			$totallate ='';
			if($total !== $paidtotal) $totallate = $currentlatefee; // if tatol mag != total jma (then charge late_fee)
			$total_currentamt = (($currentm * $month_latefee)+ ($currentgst * $month_latefee)+ $total_latefee + $currentpending);			
			//$data['demand'] = $this->rent->getdata_rentpayment($id);
			$data['pending']= $pendingtotal;
			$data['currentmonth']= $currentm * $month_latefee;
			$data['gst']= $currentgst * $month_latefee;
			$data['late_fee']= $total_latefee;
			$data['receipt_number']= $jma_rent['deposit_receipt_number'];
			$data['receipt_date']= $jma_rent['deposit_receipt_date'];
			$data['deposit_depositor']= $jma_rent['deposit_depositor'];
			$data['deposit_comment']= $jma_rent['deposit_comment'];
			$data['totalgrantamt']= $total_currentamt;
			$rent = $this->rent->get_rent_by_id($id,$fny);
			$data['rent']=$rent;
			
			$data['market']= $this->rent->get_MarketALL($rent['market']);

			$data['mohalla'] = $this->rent->get_all_mohalla($rent['ward']);

			$data['view'] = 'admin/rents/edit';

			$data['wards'] = $this->rent->get_all_wards();

			$data['year'] = $this->rent->get_finnacial_year();
			
			$data['property'] = $this->rent->get_property_type();

			$this->load->view('layout', $data);
			
		}
		
		}
