<?php defined('BASEPATH') OR exit('No direct script access allowed');

	class Master extends MY_Controller {
		function __construct(){
        parent::__construct();
        $this->load->library('rbac');
        $this->load->model('admin/master_model', 'master');
        $this->rbac->check_module_access();
		}	
	
		public function add_year_page()
		{

			$data['title']="Finnancial Year";
			$data['view'] = 'admin/master/add_year';
			$this->load->view('layout', $data);
		}

		public function year_datatable_json()
		{

			$draw=intval($this->input->post("draw"));
			$start=$this->input->post("start");
			$length=$this->input->post("length");

			$total_rows=$this->master->count_all_year();
			$filtered=$total_rows;


			$result=$this->master->get_all_year($length,$start);
			
			$data['draw'] = $draw;
    		$data['recordsTotal'] = $total_rows;
    		$data['recordsFiltered'] = $total_rows;
			$i=0;
			
			foreach($result as $r)
			{
				
				
			$res[]=array(
					"no" => ++$i,
					"year"=>$r->year,
					"is_active"=>($r->is_active==1?'Active' : 'Deactive'),
					"date"=>date_time($r->created_at),
					"action"=>'<a href="edit_year_page/'.$r->id.'" class="btn btn-warning btn-xs mr5 edit_year" title="Edit" data-id="'.$r->id.'" ><i class="fa fa-edit"></i></a>
                    <a href="" data-id="'.$r->id.'" title="Delete" class="btn btn-danger btn-xs dlt_year"><i class="fa fa-remove"></i></a>'
					
				);
				$data['data']=$res;

			}


			echo json_encode($data);



		}

		public function delete_year()
		{
			$i_d=$this->input->post('id');
			$id=$this->security->xss_clean($i_d);
			$result=$this->master->delet_year($id);

			if($result)
			{
				echo json_encode(array('statusCode'=>200));
			}
		

		}

		public function insert_year()
		{

			$this->form_validation->set_rules('year','Year','required|trim');

			if($this->form_validation->run())
			{
				$year=$this->input->post('year');

			$date=date('Y-m-d');

			$is_active=1;

			$da_ta=array(
				'year' =>$year,
				'is_active' => $is_active,
				'created_at' => $date
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->insert_finnancial_year($data);

			if($result)
			{
				redirect('admin/master/add_year_page');
			}
			}
			else
			{
				$this->add_year_page();
			}

		}

		public function edit_year_page($id)
		{
			$data['year']=$this->master->get_year_by_id($id);

			$data['title']='Edit Year';

			$data['view']='admin/master/edit_year';

			$this->load->view('layout', $data);
		}

		public function edit_year()
		{
			$this->form_validation->set_rules('year','Year','required|trim');
			$this->form_validation->set_rules('is_active','Status','required|trim');

			$id=$this->input->post('year_id');

			if($this->form_validation->run())
			{
				$year=$this->input->post('year');
				$is_active=$this->input->post('is_active');

			$da_ta=array(
				'year' =>$year,
				'is_active' => $is_active,
				
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->edit_finnancial_year($data,$id);

			if($result)
			{
				$this->session->set_flashdata('success','Finnancial year updated successfully');
				redirect('admin/master/edit_year_page/'. $id);
				//$this->edit_year_page($id);			
			}
			}
			else
			{
				$this->edit_year_page($id);
			}
		}

		public function add_ward_page()
		{
			$data['title']="Add New Ward";
			$data['view'] = 'admin/master/add_ward';
			$this->load->view('layout', $data);
		}

		public function ward_datatable_json()
		{
			$draw=intval($this->input->post("draw"));
			$start=$this->input->post("start");
			$length=$this->input->post("length");

			$total_rows=$this->master->count_all_ward();
			$filtered=$total_rows;


			$result=$this->master->get_all_ward($length,$start);
			
			$data['draw'] = $draw;
    		$data['recordsTotal'] = $total_rows;
    		$data['recordsFiltered'] = $total_rows;
			$i=0;
			
			foreach($result as $r)
			{
				
				
			$res[]=array(
					"no" => ++$i,
					"ward_no"=>$r->ward_no,
					"ward_name"=>$r->ward_name,
					"is_active"=>($r->is_active==1?'Active' : 'Deactive'),
					"date"=>date_time($r->created_at),
					"action"=>'<a href="edit_ward_page/'.$r->id.'" class="btn btn-warning btn-xs mr5 edit_year" title="Edit" data-id="'.$r->id.'" ><i class="fa fa-edit"></i></a>
                    <a href="" data-id="'.$r->id.'" title="Delete" class="btn btn-danger btn-xs dlt_ward"><i class="fa fa-remove"></i></a>'
					
				);
				$data['data']=$res;

			}


			echo json_encode($data);

		}

		public function delete_ward()
		{
			$i_d=$this->input->post('id');
			$id=$this->security->xss_clean($i_d);
			$result=$this->master->delet_ward($id);

			if($result)
			{
				echo json_encode(array('statusCode'=>200));
			}
		}

		public function insert_ward()
		{
			$this->form_validation->set_rules('ward_no','Ward No.','required|trim|is_unique[ward.ward_no]');
			$this->form_validation->set_rules('ward_name','Ward Name','required|trim');

			if($this->form_validation->run())
			{
				$ward_no=$this->input->post('ward_no');
				$ward_name=$this->input->post('ward_name');

			$date=date('Y-m-d');

			$is_active=1;

			$da_ta=array(
				'ward_no' =>$ward_no,
				'ward_name' =>$ward_name,
				'is_active' => $is_active,
				'created_at' => $date
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->insert_ward_no($data);

			if($result)
			{
				redirect('admin/master/add_ward_page');
			}
			}
			else
			{
				$this->add_ward_page();
			}
		}

		public function edit_ward_page($id)
		{
			$data['ward']=$this->master->get_ward_by_id($id);

			$data['title']='Edit Ward';

			$data['view']='admin/master/edit_ward';

			$this->load->view('layout', $data);
		}

		public function edit_ward()
		{
			$id=$this->input->post('id');
			$detail=$this->master->get_ward_by_id($id);
			$is_unique =  '';
			$ward_no=$detail->ward_no;
			if($this->input->post('ward_no') != $ward_no) 
			{
   				$is_unique .=  '|is_unique[ward.ward_no]';
			} 
			else
			{
   				$is_unique .=  '';
			}

			$this->form_validation->set_rules('ward_no','Ward No.','required|trim'.$is_unique);
			$this->form_validation->set_rules('ward_name','Ward Name','required|trim');
			$this->form_validation->set_rules('is_active','Status','required|trim');

			

			if($this->form_validation->run())
			{
				$ward_no=$this->input->post('ward_no');
				$ward_name=$this->input->post('ward_name');
				$is_active=$this->input->post('is_active');

			$da_ta=array(
				'ward_no' =>$ward_no,
				'ward_name' =>$ward_name,
				'is_active' => $is_active,
				
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->edit_wardd($data,$id);

			if($result)
			{
				$this->session->set_flashdata('success','Ward updated successfully');
				redirect('admin/master/edit_ward_page/'. $id);
				//$this->edit_year_page($id);			
			}
			}
			else
			{
				$this->edit_ward_page($id);
			}
		}

		public function add_mohalla_page()
		{
			$data['ward_list']=$this->master->get_ward_list();
			$data['title']="Add Mohalla";
			$data['view'] = 'admin/master/add_mohalla';
			$this->load->view('layout', $data);
		}

		public function mohalla_datatable_json()
		{
			$draw=intval($this->input->post("draw"));
			$start=$this->input->post("start");
			$length=$this->input->post("length");

			$total_rows=$this->master->count_all_mohalla();
			$filtered=$total_rows;


			$result=$this->master->get_all_mohalla($length,$start);
			
			$data['draw'] = $draw;
    		$data['recordsTotal'] = $total_rows;
    		$data['recordsFiltered'] = $total_rows;
			$i=0;
			
			foreach($result as $r)
			{
				
				
			$res[]=array(
					"no" => ++$i,
					"mohalla"=>$r->name,
					"mohalla_code"=>$r->mohalla_code,
					"ward"=>$r->ward_no.','.$r->ward_name,
					"is_active"=>($r->is_active==1?'Active' : 'Deactive'),
					"date"=>date_time($r->created_at),
					"action"=>'<a href="edit_mohalla_page/'.$r->id.'" class="btn btn-warning btn-xs mr5 edit_year" title="Edit" data-id="'.$r->id.'" ><i class="fa fa-edit"></i></a>
                    <a href="" data-id="'.$r->id.'" title="Delete" class="btn btn-danger btn-xs dlt_mohalla"><i class="fa fa-remove"></i></a>'
					
				);
				$data['data']=$res;

			}


			echo json_encode($data);
		}

		public function delete_mohalla()
		{
			$i_d=$this->input->post('id');
			$id=$this->security->xss_clean($i_d);
			$result=$this->master->delet_mohalla($id);

			if($result)
			{
				echo json_encode(array('statusCode'=>200));
			}
		}

		public function edit_mohalla_page($id)
		{
			$data['ward_list']=$this->master->get_ward_list();

			$data['mohalla']=$this->master->get_mohalla_by_id($id);

			$data['title']='Edit Mohalla';

			$data['view']='admin/master/edit_mohalla';

			$this->load->view('layout', $data);
		}

		public function edit_mohalla()
		{
			$id=$this->input->post('id');
			

			$this->form_validation->set_rules('mohalla','Mohalla Name','required|trim');
			$this->form_validation->set_rules('mohalla_code','Mohalla Code','required|trim');
			$this->form_validation->set_rules('ward','Ward','required|trim');
			$this->form_validation->set_rules('is_active','Status','required|trim');

			

			if($this->form_validation->run())
			{
				$mohalla=$this->input->post('mohalla');
				$mohalla_code=$this->input->post('mohalla_code');
				$ward=$this->input->post('ward');
				$is_active=$this->input->post('is_active');

			$da_ta=array(
				'name' =>$mohalla,
				'mohalla_code' =>$mohalla_code,
				'ward_id' =>$ward,
				'is_active' => $is_active,
				
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->edit_mohallaa($data,$id);

			if($result)
			{
				$this->session->set_flashdata('success','Mohalla updated successfully');
				redirect('admin/master/edit_mohalla_page/'. $id);
				//$this->edit_year_page($id);			
			}
			}
			else
			{
				$this->edit_mohalla_page($id);
			}
		}

		public function insert_mohalla()
		{
			$this->form_validation->set_rules('mohalla','Mohalla Name','required|trim');
			$this->form_validation->set_rules('mohalla_code','Mohalla Code','required|trim');
			$this->form_validation->set_rules('ward','Ward','required|trim');
			

			

			if($this->form_validation->run())
			{
				$mohalla=$this->input->post('mohalla');
				$mohalla_code=$this->input->post('mohalla_code');
				$ward=$this->input->post('ward');
				$is_active=1;
				$date=date('Y-m-d');

			$da_ta=array(
				'name' =>$mohalla,
				'mohalla_code' =>$mohalla_code,
				'ward_id' =>$ward,
				'is_active' => $is_active,
				'created_at' => $date
				
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->insert_mohallaa($data);

			if($result)
			{
				redirect('admin/master/add_mohalla_page');
			}
			}
			else
			{
				$this->add_mohalla_page();
			}

		}
		public function insert_market()
		{
			$this->form_validation->set_rules('market','Market Name','required|trim');
			$this->form_validation->set_rules('village_address','village_address','required|trim');
			$this->form_validation->set_rules('ward','Ward','required|trim');			
			
			if($this->form_validation->run())
			{
				$market=$this->input->post('market');
				$mohalla=$this->input->post('village_address');
				$ward=$this->input->post('ward');
				$is_active=1;
				$date=date('Y-m-d');

			$da_ta=array(
				'market_name' =>$market,
				'ward_id' =>$ward,
				'mohalla_id' =>$mohalla,				
				'is_active' => $is_active,
				'created_at' => $date			
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->insert_market($data);

			if($result)
			{
				redirect('admin/master/add_market');
			}
			}
			else
			{
				$this->add_mohalla_page();
			}

		}

		public function add_property_page()
		{
			$data['title']="Add New Property Type";
			$data['view'] = 'admin/master/add_property_type';
			$this->load->view('layout', $data);
		}
		public function add_market()
		{
			$data['ward_list']=$this->master->get_ward_list();
			$data['title']="Add New Market";
			$data['view'] = 'admin/master/add_market';
			$this->load->view('layout', $data);
		}

		public function property_datatable_json()
		{
			$draw=intval($this->input->post("draw"));
			$start=$this->input->post("start");
			$length=$this->input->post("length");

			$total_rows=$this->master->count_all_property();
			$filtered=$total_rows;


			$result=$this->master->get_all_property($length,$start);
			
			$data['draw'] = $draw;
    		$data['recordsTotal'] = $total_rows;
    		$data['recordsFiltered'] = $total_rows;
			$i=0;
			
			foreach($result as $r)
			{
				
				
			$res[]=array(
					"no" => ++$i,
					"property"=>$r->type,
					"is_active"=>($r->is_active==1?'Active' : 'Deactive'),
					"date"=>date_time($r->created_at),
					"action"=>'<a href="edit_prop_page/'.$r->id.'" class="btn btn-warning btn-xs mr5 edit_prop" title="Edit" data-id="'.$r->id.'" ><i class="fa fa-edit"></i></a>
                    <a href="" data-id="'.$r->id.'" title="Delete" class="btn btn-danger btn-xs dlt_prop"><i class="fa fa-remove"></i></a>'
					
				);
				$data['data']=$res;

			}


			echo json_encode($data);

		}
		public function market_datatable_json()
		{
			$draw=intval($this->input->post("draw"));
			$start=$this->input->post("start");
			$length=$this->input->post("length");

			$total_rows=$this->master->count_all_market();
			$filtered=$total_rows;


			$result=$this->master->get_all_market($length,$start);
			
			$data['draw'] = $draw;
    		$data['recordsTotal'] = $total_rows;
    		$data['recordsFiltered'] = $total_rows;
			$i=0;
			
			foreach($result as $r)
			{
				
			$wards = $this->master->get_ward_by_id($r->ward_id);
			$mohalla = $this->master->get_mohalla_by_id($r->mohalla_id);
			$res[]=array(
					"no" => ++$i,
					"market_name"=>$r->market_name,
					"ward_name"=>$wards->ward_name,
					"mohalla_name"=>$mohalla->name,
					"is_active"=>($r->is_active==1?'Active' : 'Deactive'),
					"date"=>date_time($r->created_at),
					"action"=>'<a href="edit_market/'.$r->id.'" class="btn btn-warning btn-xs mr5 edit_prop" title="Edit" data-id="'.$r->id.'" ><i class="fa fa-edit"></i></a>
                    <a href="" data-id="'.$r->id.'" title="Delete" class="btn btn-danger btn-xs dlt_prop"><i class="fa fa-remove"></i></a>'
					
				);
				$data['data']=$res;

			}
			echo json_encode($data);

		}
		public function edit_market($id)
		{
			$data['ward_list']=$this->master->get_ward_list();
			
			$data['market']=$this->master->get_market_by_id($id);

			$data['title']='Edit Market';

			$data['view']='admin/master/edit_market';

			$this->load->view('layout', $data);
		}

		public function delete_prop()
		{
			$i_d=$this->input->post('id');
			$id=$this->security->xss_clean($i_d);
			$result=$this->master->delet_property($id);

			if($result)
			{
				echo json_encode(array('statusCode'=>200));
			}
		}
		public function delete_market()
		{
			$i_d=$this->input->post('id');
			$id=$this->security->xss_clean($i_d);
			$result=$this->master->delet_market($id);

			if($result)
			{
				echo json_encode(array('statusCode'=>200));
			}
		}
		

		public function insert_prop()
		{
			
			$this->form_validation->set_rules('property','Property Type','required|trim');

			if($this->form_validation->run())
			{
				$property=$this->input->post('property');
				//$ward_name=$this->input->post('ward_name');

			$date=date('Y-m-d');

			$is_active=1;

			$da_ta=array(
				'type' =>$property,
				'is_active' => $is_active,
				'created_at' => $date
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->insert_property($data);

			if($result)
			{
				redirect('admin/master/add_property_page');
			}
			}
			else
			{
				$this->add_property_page();
			}
		}

		public function edit_prop_page($id)
		{
			$data['property']=$this->master->get_prop_by_id($id);

			$data['title']='Edit Year';

			$data['view']='admin/master/edit_property_type';

			$this->load->view('layout', $data);
		}

		public function edit_prop()
		{
			$this->form_validation->set_rules('property','Property Type','required|trim');
			$this->form_validation->set_rules('is_active','Status','required|trim');

			$id=$this->input->post('id');

			if($this->form_validation->run())
			{
				$property=$this->input->post('property');
				$is_active=$this->input->post('is_active');

			$da_ta=array(
				'type' =>$property,
				'is_active' => $is_active,
				
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->edit_property($data,$id);

			if($result)
			{
				$this->session->set_flashdata('success','Property type updated successfully');
				redirect('admin/master/edit_prop_page/'. $id);
				//$this->edit_year_page($id);			
			}
			}
			else
			{
				$this->edit_prop_page($id);
			}
		}
		public function update_market()
		{
			$this->form_validation->set_rules('market','Market Name','required|trim');
			$this->form_validation->set_rules('village_address','village_address','required|trim');
			$this->form_validation->set_rules('ward','Ward','required|trim');			
			$id=$this->input->post('id');
			if($this->form_validation->run())
			{
				$market=$this->input->post('market');
				$mohalla=$this->input->post('village_address');
				$ward=$this->input->post('ward');
				$date=date('Y-m-d');

			$da_ta=array(
				'market_name' =>$market,
				'ward_id' =>$ward,
				'mohalla_id' =>$mohalla			
						
			);

			$data=$this->security->xss_clean($da_ta);

			$result=$this->master->update_market($data,$id);

			if($result)
			{
				$this->session->set_flashdata('success','Market updated successfully');
				redirect('admin/master/add_market');
				//$this->edit_year_page($id);			
			}
			}
			else
			{
				$this->edit_market($id);
			}
		}

	
		
}
