<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Office extends MY_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library(array('session'));
        if($this->session->userdata('login_data'))
        {
            $session_data = $this->session->userdata('login_data');
        }
        else
        {
            redirect('user/sighIn');
        }

    }
    public function offices($msg = null)
    {
        if ($msg)
            $data['msg'] = $msg;
        $this->load->model('user_model');
        $this->load->model('office_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        //$data['owners'] = $this->user_model->as_dropdown('FirstName')->get_all();
        $data['offices'] = $this->office_model->list();
        $this->load->view('office/offices', $data);
    }

    public function add_office($id = null)
    {
        $this->load->model('user_model');
        $this->load->model('office_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['owners'] = $this->user_model->dropdown_active();
        $data['active'] = array(1=>'Yes',2=>'No');
        $data['office'] = null;
        if ($id) {
            $data['office'] = $this->office_model->where(array('OfficeID' => $id))->get();
        }
        $this->load->view('office/add_office', $data);
    }

    public function lock_office($id=null) {
        $message = 2;
        if ($id) {
            $this->load->model('office_model');
            $this->office_model->update( array('Active' => 2),$id);
            $message = 1;
        }
        redirect('office/offices/' . $message);
    }

    public function unlock_office($id=null) {
        $message = 2;
        if ($id) {
            $this->load->model('office_model');
            $this->office_model->update( array('Active' => 1),$id);
            $message = 1;
        }
        redirect('office/offices/' . $message);
    }

    public function save_office()
    {
        $message = 2;
        $id = $this->input->post('OfficeID');
        $this->load->library('form_validation');
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_office'));
        $this->form_validation->set_data($data);
        if ($this->form_validation->run('save_office') != false) {
            $this->load->model('office_model');
            if ($id) {
                if ($this->office_model->update($data, $id)) {
                    $message = 1;
                }
            } else {
                $this->office_model->insert($data);
                $message = 1;
            }
        }
        redirect('office/office/' . $message);
    }

    public function delete_office()
    {
        $this->load->model('office_model');
        $id = $this->input->post('OfficeID');
        $message = 2;
        if ($id) {
            $this->office_model->update(array('Stat' => 2), $id);
            $message = 1;
        }
        redirect('office/office/' . $message);
    }

    public function detail($id)
    {
            $this->load->library('encryption');
            $this->load->model('insurance_model');
            $this->load->model('user_model');
            $this->load->model('contractor_model');
            $this->load->model('office_model');
            $this->load->model('schedule_model');
            $this->load->model('contractor_billing_model');
            $this->load->model('contractor_insurance_model');
            $this->load->model('appointment_limit_model');
            $this->load->model('office_note_model'); 
            $this->load->model('role_model');          
           
            $data['session_data'] = $this->user_model->getLoginSession();
            $data['schedulevalue']= array(0=>0,1=>1,2=>2,3=>3,4=>4,5=>5);
            $data['limits'] = $this->appointment_limit_model->where(array('Stat' => 1))->get_all();
            $data['insurances'] = $this->insurance_model->where(array('Stat' => 1))->get_all();
            $data['office'] = $this->office_model->where(array('OfficeID' =>  $id))->get();
            $data['contractor'] = $this->contractor_model->contractor_detail($id);
            $ouid = $data['office']['OwnerID'];
            $cid=$data['contractor'][0]['UserID'];
            
                $data['user'] = $this->user_model->where(array('UserID' => $ouid))->get();
                $data['user']['Password'] = $this->encryption->decrypt($data['user']['Password']);
            
            $data['office_notes'] = $this->office_note_model->office_notes($id);             
            $data['schedule'] = $this->schedule_model->where(array('ContractorID' => $data['contractor'][0]['ContractorID']))->get();
            $data['time_8']= explode(',', $data['schedule']['Time_8']);
            $data['time_9']= explode(',', $data['schedule']['Time_9']);
            $data['time_10']= explode(',', $data['schedule']['Time_10']);
            $data['time_11']= explode(',', $data['schedule']['Time_11']);
            $data['time_12']= explode(',', $data['schedule']['Time_12']);
            $data['time_13']= explode(',', $data['schedule']['Time_13']);
            $data['time_14']= explode(',', $data['schedule']['Time_14']);
            $data['time_15']= explode(',', $data['schedule']['Time_15']);
            $data['time_16']= explode(',', $data['schedule']['Time_16']);
            $data['time_17']= explode(',', $data['schedule']['Time_17']);
            $data['time_18']= explode(',', $data['schedule']['Time_18']);
            $data['time_19']= explode(',', $data['schedule']['Time_19']);
            $data['time_20']= explode(',', $data['schedule']['Time_20']);
            // print_r($data['user']);  
           
            if($cid=$data['contractor'][0]['UserID'])
              $this->load->view('office/detail', $data);
           else
           $this->load->view('office/detailReadUser', $data);
          //print_r($data['contractor']);
          $this->load->view('office/detail', $data);
        }

    public function add_office_note()
    {
        $this->load->library('form_validation');
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_note'));
        $this->form_validation->set_data($data);
        if ($this->form_validation->run('save_note') != false) 
        {
            $this->load->model('office_note_model');
            $this->office_note_model->insert($data);
        }
        redirect('office/detail/'.$data['OfficeID']);
    }

    public function save_contractor()
    {
        //print_r($this->input->post());
        $message = 2;
        $uid = $this->input->post('UserID');
        $cid = $this->input->post('ContractorID');
        $bid = $this->input->post('BillID');
        $sid = $this->input->post('ScheduleID');
        $oid = $this->input->post('OfficeID');
        $asphalt = 0;
        $flat = 0;
        $metal = 0;
        $tile = 0;
        $shake = 0;
        $timing = 0;
        $spanish = 0;
        $cash = 0;
        $deniedclaims = 0;
     
        $this->load->library('encryption');
        $this->load->library('form_validation');
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('inhouse_edit_contractor'));
        //print_r($data);
        $this->form_validation->set_data($data);
        if ($this->form_validation->run('save_contractor') != false) {
            //print_r('Form Validated!');           
            $this->load->model('user_model');
            $this->load->model('contractor_model');
            $this->load->model('office_model');
            $this->load->model('schedule_model');
            $this->load->model('contractor_billing_model');
            $this->load->model('contractor_insurance_model');
    
            $post = $this->input->post();
            //print_r($data);
 
     
            $data['Password'] = $this->encryption->encrypt($data['Password']);
                if ($cid) {
                    $this->user_model->update($data, $uid);
    
                   /* $odata = array(
                        'OfficeName'=>  $this->input->post('OfficeName'),
                        'OfficeDescription'=>  $this->input->post('OfficeDescription'),
                        'OwnerID' => $uid
                    );
    
                    if(!$oid){
                        $oid = $this->office_model->insert($odata);
                    }
                    */
    
                    if(isset($post['RAsphalt'])){
                        $asphalt= 1;
                    }
                    if(isset($post['RFlat'])){
                        $flat= 1;
                    }
                    if(isset($post['RMetal'])){
                        $metal= 1;
                    }
                    if(isset($post['RTile'])){
                        $tile= 1;
                    }
                    if(isset($post['RShake'])){
                        $shake= 1;
                    }
                    if(isset($post['Timing'])){
                        $timing= 1;
                    }
                    if(isset($post['QSpanish'])){
                        $spanish= 1;
                    }
                    if(isset($post['QCash'])){
                        $cash= 1;
                    }
                    if(isset($post['QDeniedClaims'])){
                        $deniedclaims= 1;
                    }
                    if(isset($post['RoofAge']))
                        $roofage= $post['RoofAge'];
                        else $roofage = 1;
                                       
                    if(isset($post['ValueCode']))
                        $valuecode= $post['ValueCode'];
                        else $valuecode = 1;
                       
                    $contractor = array(
                        'UserID'=>$uid,
                        'BasePrice'=>80,
                        'TotalPrice'=>$post['TotalPrice'],
                        'Zip'=>$post['QZip'],
                        'OfficeID'=>$oid,
                        'RAsphalt'=>$asphalt,
                        'RFlat'=>$flat,
                        'RMetal'=>$metal,
                        'RTile'=>$tile,
                        'RShake'=>$shake,
                        'Timing'=>$timing,
                        'QSpanish'=>$spanish,
                        'QCash'=>$cash,
                        'QDeniedClaims'=>$deniedclaims,
                        'RoofAge'=>$roofage,
                        'ValueCode'=>$valuecode,
                        'TargetAreas'=>$post['TargetAreas']
                    );
                    //print_r($contractor);
                    $this->contractor_model->update($contractor,$cid);
    
                    $count = $post['Count'];
                    $this->contractor_insurance_model->where(array('ContractorID'=>$cid))->delete();
    
                    for ($int = 1; $int < $count; $int++) {
                        if ($this->input->post('ins_' . $int) == 1) {
                            $mid = $this->input->post('ins_id_' . $int);
                            $data = array(
                                'ContractorID' => $cid,
                                'InsuranceID' => $mid
                            );
                            $this->contractor_insurance_model->insert($data);
                        }
                    }
    
                    $time_8 = array();
                    $time_9 = array();
                    $time_10 = array();
                    $time_11 = array();
                    $time_12 = array();
                    $time_13 = array();
                    $time_14 = array();
                    $time_15 = array();
                    $time_16 = array();
                    $time_17 = array();
                    $time_18 = array();
                    $time_19 = array();
                    $time_20 = array();
    
                    for ($int = 1; $int < 8; $int++) {
                        $key1 = '8_' . $int;
                        $key2 = '9_' . $int;
                        $key3 = '10_' . $int;
                        $key4 = '11_' . $int;
                        $key5 = '12_' . $int;
                        $key6 = '13_' . $int;
                        $key7 = '14_' . $int;
                        $key8 = '15_' . $int;
                        $key9 = '16_' . $int;
                        $key10 = '17_' . $int;
                        $key11 = '18_' . $int;
                        $key12 = '19_' . $int;
                        $key13 = '20_' . $int;
    
                        $time_8[$key1]= $this->input->post('8_' . $int);
                        $time_9[$key2]= $this->input->post('9_' . $int);
                        $time_10[$key3]= $this->input->post('10_' . $int);
                        $time_11[$key4]= $this->input->post('11_' . $int);
                        $time_12[$key5]= $this->input->post('12_' . $int);
                        $time_13[$key6]= $this->input->post('13_' . $int);
                        $time_14[$key7]= $this->input->post('14_' . $int);
                        $time_15[$key8]= $this->input->post('15_' . $int);
                        $time_16[$key9]= $this->input->post('16_' . $int);
                        $time_17[$key10]= $this->input->post('17_' . $int);
                        $time_18[$key11]= $this->input->post('18_' . $int);
                        $time_19[$key12]= $this->input->post('19_' . $int);
                        $time_20[$key13]= $this->input->post('20_' . $int);
                    }
                    $data = array(
                        'ContractorID' => $cid,
                        'Time_8' => implode(',',$time_8),
                        'Time_9' => implode(',',$time_9),
                        'Time_10' => implode(',',$time_10),
                        'Time_11' => implode(',',$time_11),
                        'Time_12' => implode(',',$time_12),
                        'Time_13' => implode(',',$time_13),
                        'Time_14' => implode(',',$time_14),
                        'Time_15' => implode(',',$time_15),
                        'Time_16' => implode(',',$time_16),
                        'Time_17' => implode(',',$time_17),
                        'Time_18' => implode(',',$time_18),
                        'Time_19' => implode(',',$time_19),
                        'Time_20' => implode(',',$time_20)
                    );
    
                    $this->schedule_model->update($data,$sid);
                    /*
                    $billinginfo = array(
                        'ContractorID'=> $cid,
                        'CardType'=> $post['CardType'],
                        'CardName'=>$this->encryption->encrypt($post['CardName']),
                        'CardNumber'=> $this->encryption->encrypt($post['CardNumber']),
                        'Expiration'=>$post['Expiration'],
                        'Code'=> $this->encryption->encrypt($post['Code']),
                        'City'=>$post['BCity'],
                        'Zip'=> $post['BZip'],
                        'State'=> $post['BState'],
                        'Address'=> $post['BAddress']
                    );
    
                    $this->contractor_billing_model->update($billinginfo,$bid);
                    */
                    $message = 1;
    
                } else {
                    //$uid = $this->user_model->insert($data);
    
                   // $odata = array(
                    //    'OfficeName'=>  $this->input->post('OfficeName'),
                    //    'OfficeDescription'=>  $this->input->post('OfficeDescription'),
                    //    'OwnerID' => $uid
                   // );
    
                   // if(!$oid){
                   //     $oid = $this->office_model->insert($odata);
                   // }
    
                    if(isset($post['RAsphalt'])){
                        $asphalt= 1;
                    }
                    if(isset($post['RFlat'])){
                        $flat= 1;
                    }
                    if(isset($post['RMetal'])){
                        $metal= 1;
                    }
                    if(isset($post['RTile'])){
                        $tile= 1;
                    }
                    if(isset($post['RShake'])){
                        $shake= 1;
                    }
                    if(isset($post['Timing'])){
                        $timing= 1;
                    }
                    if(isset($post['QSpanish'])){
                        $spanish= 1;
                    }
                    if(isset($post['QCash'])){
                        $cash= 1;
                    }
                    if(isset($post['QDeniedClaims'])){
                        $deniedclaims= 1;
                    }
                    if(isset($post['RoofAge']))
                    $roofage= $post['RoofAge'];
                    else $roofage = 1;
                                   
                if(isset($post['ValueCode']))
                    $valuecode= $post['ValueCode'];
                    else $valuecode = 1;                   
    
                    $contractor = array(
                        'UserID'=>$uid,
                        'BasePrice'=>80,
                        'TotalPrice'=>$post['TotalPrice'],
                        'Zip'=>$post['QZip'],
                        'OfficeID'=>$oid,
                        'RAsphalt'=>$asphalt,
                        'RFlat'=>$flat,
                        'RMetal'=>$metal,
                        'RTile'=>$tile,
                        'RShake'=>$shake,
                        'Timing'=>$timing,
                        'QSpanish'=>$spanish,
                        'QCash'=>$cash,
                        'QDeniedClaims'=>$deniedclaims,
                        'RoofAge'=>$roofage,
                        'ValueCode'=>$valuecode,
                        'TargetAreas'=>$post['TargetAreas']
                    );
                    $cid = $this->contractor_model->insert($contractor);
    
                    $count = $post['Count'];
    
                    for ($int = 1; $int < $count; $int++) {
                        if ($this->input->post('ins_' . $int) == 1) {
                            $mid = $this->input->post('ins_id_' . $int);
                            $data = array(
                                'ContractorID' => $cid,
                                'InsuranceID' => $mid
                            );
                            $this->contractor_insurance_model->insert($data);
                        }
                    }
    
                    $time_8 = array();
                    $time_9 = array();
                    $time_10 = array();
                    $time_11 = array();
                    $time_12 = array();
                    $time_13 = array();
                    $time_14 = array();
                    $time_15 = array();
                    $time_16 = array();
                    $time_17 = array();
                    $time_18 = array();
                    $time_19 = array();
                    $time_20 = array();
    
                    for ($int = 1; $int < 8; $int++) {
                        $key1 = '8_' . $int;
                        $key2 = '9_' . $int;
                        $key3 = '10_' . $int;
                        $key4 = '11_' . $int;
                        $key5 = '12_' . $int;
                        $key6 = '13_' . $int;
                        $key7 = '14_' . $int;
                        $key8 = '15_' . $int;
                        $key9 = '16_' . $int;
                        $key10 = '17_' . $int;
                        $key11 = '18_' . $int;
                        $key12 = '19_' . $int;
                        $key13 = '20_' . $int;
    
                        $time_8[$key1]= $this->input->post('8_' . $int);
                        $time_9[$key2]= $this->input->post('9_' . $int);
                        $time_10[$key3]= $this->input->post('10_' . $int);
                        $time_11[$key4]= $this->input->post('11_' . $int);
                        $time_12[$key5]= $this->input->post('12_' . $int);
                        $time_13[$key6]= $this->input->post('13_' . $int);
                        $time_14[$key7]= $this->input->post('14_' . $int);
                        $time_15[$key8]= $this->input->post('15_' . $int);
                        $time_16[$key9]= $this->input->post('16_' . $int);
                        $time_17[$key10]= $this->input->post('17_' . $int);
                        $time_18[$key11]= $this->input->post('18_' . $int);
                        $time_19[$key12]= $this->input->post('19_' . $int);
                        $time_20[$key13]= $this->input->post('20_' . $int);
                    }
                    $data = array(
                        'ContractorID' => $cid,
                        'Time_8' => implode(',',$time_8),
                        'Time_9' => implode(',',$time_9),
                        'Time_10' => implode(',',$time_10),
                        'Time_11' => implode(',',$time_11),
                        'Time_12' => implode(',',$time_12),
                        'Time_13' => implode(',',$time_13),
                        'Time_14' => implode(',',$time_14),
                        'Time_15' => implode(',',$time_15),
                        'Time_16' => implode(',',$time_16),
                        'Time_17' => implode(',',$time_17),
                        'Time_18' => implode(',',$time_18),
                        'Time_19' => implode(',',$time_19),
                        'Time_20' => implode(',',$time_20)
                    );
    
                    $this->schedule_model->insert($data);
                    /*
                    $billinginfo = array(
                        'ContractorID'=> $cid,
                        'CardType'=> $post['CardType'],
                        'CardName'=>$this->encryption->encrypt($post['CardName']),
                        'CardNumber'=> $this->encryption->encrypt($post['CardNumber']),
                        'Expiration'=>$post['Expiration'],
                        'Code'=> $this->encryption->encrypt($post['Code']),
                        'City'=>$post['BCity'],
                        'Zip'=> $post['BZip'],
                        'State'=> $post['BState'],
                        'Address'=> $post['BAddress']
                    );
    
                    $this->contractor_billing_model->insert($billinginfo);
                    */
    
                    $message = 1;
                    
                }
                
            }
     
           //print_r(validation_errors());
         redirect('office/offices/'.$message);
       
    }

}
?>

