<?php
    defined('BASEPATH') OR exit('No direct script access allowed');

    class Payment_gateway_model extends CI_Model{
        
        public function __construct(){
            parent::__construct();
        }

        public function payment_gateway_get_all(){
            $wh =array();
            $SQL ='SELECT g.*,c.name FROM `tbl_pgateway` g 
            LEFT JOIN tbl_client c ON c.client_id = g.client_pid';
            //$wh[] = "";
            if(count($wh)>0){
                $WHERE = implode(' and ',$wh);
                return $this->datatable->LoadJson($SQL,$WHERE);
            }
            else{
                return $this->datatable->LoadJson($SQL);
            }
        }
		
		public function payment_gateway_get_clients(){
			$query = $this->db->order_by('name', 'ASC')->get_where('tbl_client', array('is_active' => '1')); 
            return $query->result();
        }
        
        public function get_payment_gateway_by_id( $id ){
            $query = $this->db->get_where('tbl_pgateway', array('pg_id' => $id));
            return $result = $query->row_array();
        }

        public function payment_gateway_delete($id = 0){
            $this->db->delete('tbl_pgateway', array('pg_id' => $id));
            return true;
        }

        public function payment_gateway_status($id, $status){
            $this->db->set('is_active', $status);
            $this->db->where('pg_id', $id);
            $this->db->update('tbl_pgateway');
            return $this->db->affected_rows();
        }
		
		public function payment_gateway_sandbox($id, $sandbox){
            $this->db->set('sandbox_on', $sandbox);
            $this->db->where('pg_id', $id);
            $this->db->update('tbl_pgateway');
            return $this->db->affected_rows();
        }

        public function payment_gateway_add($data){
            $this->db->insert('tbl_pgateway', $data);
            return true;
        }
        
        public function payment_gateway_edit($data, $id){
            $this->db->where('pg_id', $id);
            $this->db->update('tbl_pgateway', $data);
            return true;
        }

    }
?>