<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_user extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'UserID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'FirstName' => array(
                'type' => 'VARCHAR',
                'constraint' => 14,
                'null' => TRUE
            ),
            'LastName' => array(
                'type' => 'VARCHAR',
                'constraint' => 14,
                'null' => TRUE
            ),
            'RoleID' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE
            ),
            'Phone' => array(
                'type' => 'VARCHAR',
                'constraint' => 15,
                'null' => TRUE
            ),
            'Address' => array(
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ),
            'Website' => array(
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ),
            'City' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => TRUE
            ),
            'State' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => TRUE
            ),
            'Zip' => array(
                'type' => 'VARCHAR',
                'constraint' => 10,
                'null' => TRUE
            ),
            'InBusiness' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'TimeZone' => array(
                'type' => 'VARCHAR',
                'constraint' => 10,
                'null' => TRUE
            ),
            'CompanyName' => array(
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ),
            'BBBRating' => array(
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ),
            'OtherService' => array(
                'type' => 'VARCHAR',
                'constraint' => 200,
                'null' => TRUE
            ),
            'CustomScript' => array(
                'type' => 'VARCHAR',
                'constraint' => 2000,
                'null' => TRUE
            ),
            'Email' => array(
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE,
                'unique' => TRUE
            ),
            'Password' => array(
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => TRUE
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('UserID', TRUE);
        $this->dbforge->create_table('users');

        $data = array(
            array('FirstName' => 'Admin','LastName' => '1','Phone' => '0114564521','Email' => 'admin@gmail.com','Password' => '5b0acdeb4ab3a70c6da5ced308a375680afe36d70504a453d1d58bb136bc962aee60a9a93f35c07a879914bf3f4bcb58cc1614ac9d69f3233514a973493255036hhpRiO3MHxOZ80SQUYWqWZTFkVKMcduFUErSz7YG2c=','RoleID' => 1)
        );
        $this->db->insert_batch('users', $data);
    }

    public function down() {
        $this->dbforge->drop_table('users');
    }

}