<?php
use Restserver\Libraries\REST_Controller;
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';

class Appointment_api extends REST_Controller  {

    function __construct($config = 'rest') {
        parent::__construct($config);
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Authorization");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $method = $_SERVER['REQUEST_METHOD'];
        if ($method == "OPTIONS") {
            die();
        }
        $this->load->helper('my_api');
        $this->methods['appointment_get']['limit'] = 100;
    }

    public function appointment_get($datefrom=null,$dateto=null){
        $this->load->model('user_model');
        $this->load->model('office_model');
        $this->load->model('insurance_model');
        $this->load->model('appointment_model');

        $insurancename = "-";
        $insurance = $this->insurance_model->as_dropdown('InsuranceName')->get_all();
        $user = $this->user_model->as_dropdown('FirstName')->get_all();
        $office= $this->office_model->as_dropdown('OfficeName')->get_all();
        $ladder = array(''=>'--Select--',1=>'yes',2=>'no');
        $rooftype = array(''=>'--Select--',1=>'Asphalt',2=>'Shake',3=>'Tile',4=>'Metal',5=>'Flat');
        if($datefrom&&$dateto){
            $appointments= $this->appointment_model->fromto($datefrom,$dateto);
        }else {
            $appointments = $this->appointment_model->get_all();
        }

        $arry = ' { "data" : [ ';
        if(!empty($appointments)) {
            foreach ($appointments as $appointment) {
                $id = $appointment['AppointmentID'];
                $url1 = base_url() . "index.php/appointment/add_appointment/" . $id;
                $url2 = base_url() . "index.php/appointment/delete_appointment/" . $id;
                if ($appointment['Stat'] == 1) {
                    $btn1 = "<a href='$url1' class='btn  btn-success' > <i class='fa fa-pencil'></i>   </a>";
                }
                $btn2 = "<a href='$url1' class='btn  btn-danger' > <i class='fa fa-eye'></i>   </a>";
                if($appointment['InsuranceCompany']){
                    $insurancename = $insurance[$appointment['InsuranceCompany']];
                }
                if($appointment['OfficeID']) 
                    $officename = $office[$appointment['OfficeID']]; 
                if($appointment['AssignedTo']) 
                    $assignedto = $user[$appointment['AssignedTo']];
                if($appointment['Insured'] == 1) $isinsured = 'Yes';
                  else $isinsured = 'No';

                $arry .= ' [ "' . $appointment['AppointmentID'] . '","' . $appointment['When'] . '", "'. $appointment['FirstName'] . '" ,"' . $appointment['LastName'] . '" ,"' . $appointment['Email'] . '" ,"'  . $appointment['City'] . '", "' . $appointment['State'] . '", "' . $appointment['Phone'] . '", "' . $isinsured. '", "' . $appointment['Status'] . '", "'.$officename . '", "' . $assignedto . '", " '.  $appointment['Created_at']  . '", " ' . $btn1 . ' " ], ';
            }
        }
        $arry .= ' [ "" ,"","" ,"" ,"","","" ,"","" ,"" ,"","","" ,"","" ,"" ,"","","",""] ';
        $arry .= " ] } ";
        echo($arry);
    }

    public function appointment2_get($datefrom=null,$dateto=null){
        $this->load->model('user_model');
        $this->load->model('office_model');
        $this->load->model('insurance_model');
        $this->load->model('appointment_model');
     

        $insurancename = "-";
        $insurance = $this->insurance_model->as_dropdown('InsuranceName')->get_all();
        $user = $this->user_model->as_dropdown('FirstName')->get_all();
        $office= $this->office_model->as_dropdown('OfficeName')->get_all();
        $ladder = array(''=>'',1=>'yes',2=>'no');
        $rooftype = array(''=>'',1=>'Asphalt',2=>'Shake',3=>'Tile',4=>'Metal',5=>'Flat');
       // $this->db->order_by('when');
        if($datefrom&&$dateto){
            $appointments= $this->appointment_model->fromto($datefrom,$dateto);
        }else {
            $appointments = $this->appointment_model->get_all();
        }

        $arry = ' { "data" : [ ';
  
        if(!empty($appointments)) {
            foreach ($appointments as $appointment) {
                $id = $appointment['AppointmentID'];
                $url1 = base_url() . "index.php/appointment/add_appointment/" . $id;
                $url2 = base_url() . "index.php/appointment/delete_appointment/" . $id;
                if ($appointment['Stat'] == 1) {
                    $btn1 = "<a href='$url1' class='btn  btn-success' > <i class='fa fa-pencil'></i>   </a>";
                }
                $btn2 = "<a href='$url1' class='btn  btn-danger' > <i class='fa fa-eye'></i>   </a>";
                if($appointment['InsuranceCompany'])
                    $insurancename = $insurance[$appointment['InsuranceCompany']];
                if($appointment['OfficeID']) 
                    $officename = $office[$appointment['OfficeID']]; 
                if($appointment['AssignedTo']) 
                    $assignedto = $user[$appointment['AssignedTo']];
                if ($appointment['RoofType']) 
                    $therooftype = $rooftype[$appointment['RoofType']];
                
                

                $arry .= ' [ "' . $appointment['AppointmentID'] . '","' .date('M-d-Y g:i A', strtotime($appointment['When'])) . '", "' .  $appointment['FirstName'] . '" ,"' . $appointment['LastName'] . '" ,"' . 
                $appointment['Address'] .'<br />'. $appointment['City'] .' ' .$appointment['State'] .' ' .$appointment['Zip'] . '", "'. $appointment['Phone'] . '", "' . 
                $appointment['RoofAge'] . ' Yrs <br />' .  $therooftype . '", "' . $appointment['Status'] . '<br />'.$assignedto  . '", "' . $officename .'", "' . $btn1 . ' " ], ';
            } 
        }
        $arry .= ' [ "" ,"","" ,"" ,"","","" ,"","" ,"" ] ';
        $arry .= " ] } ";
      // print_r($arry);
       echo($arry);
    }
}