<?php defined('BASEPATH') OR exit('No direct script access allowed');
    class Segment_flow extends MY_Controller {
        function __construct(){
            parent::__construct();
            $this->load->model('admin/segment_flow_model', 'segflowmd');
            $this->load->library('datatable'); // loaded my custom serverside datatable library
            
            $this->rbac->check_module_access();
        }

        public function uritest($id=0){
            echo "the id is: ".$id."<br />";
            echo "the segment 1 is: ".$this->uri->segment(1)."<br />";
            echo "the segment 2 is: ".$this->uri->segment(2)."<br />";
            echo "the segment 3 is: ".$this->uri->segment(3)."<br />";
            echo "the segment 4 is: ".$this->uri->segment(4)."<br />";
            echo "slash segment<br /><br />";
            echo "the segment 1 is: ".$this->uri->slash_segment(1)."<br />";
            echo "the segment 1 is: ".$this->uri->slash_segment(1, 'leading')."<br />";
            echo "the segment 1 is: ".$this->uri->slash_segment(1, 'both')."<br />";

            $data_arr = $this->uri->uri_to_assoc(4);
            print_r($data_arr); echo "<br />";

            $data = ['product'=>'shoes', 'size'=>'large', 'color'=>'red'];
            $str = $this->uri->assoc_to_uri($data);
            echo "str: ".$str."<br />";

            $t = $this->uri->total_segments();
            echo "total segment: ".$t."<br />";
        }

        public function index(){
            $data['cod01'] = $this->uri->segment(3); //echo "cod01: ".$data['cod01']."<br />";
            $data['view'] = 'admin/segment_flow/segment_flow_list';
            $this->load->view('layout', $data);
        }

        public function get_datatable_json($id){
            $this->load->library('utils');
            //$op = $this->utils->action_validate_role( $this->session->userdata('admin_role') ); //echo "op: ".$op."<br />";

            $cod01 = $id;
            $rec = $this->segflowmd->segment_flow_get_all($id);
            $data = array();
            $i=0;
            foreach ($rec['data']  as $row){
                //$status = ($row['active'] == 1)? 'checked': '';

                //$action = '<a title="View" class="view btn btn-sm btn-info" href="'.base_url('admin/segment_flow/edit/'.$cod01.'/'.$row['segflow_id']).'"> <i class="fa fa-eye"></i></a>
                $action = '<a title="Edit" class="update btn btn-sm btn-warning" href="'.base_url('admin/segment_flow/edit/'.$cod01.'/'.$row['segflow_id']).'"> <i class="fa fa-pencil-square-o"></i></a>
                <a title="Delete" class="delete btn btn-sm btn-danger" data-href="'.base_url('admin/segment_flow/delete/'.$cod01.'/'.$row['segflow_id']).'" data-toggle="modal" data-target="#confirm-delete"> <i class="fa fa-trash-o"></i></a>';
                //<a title="Assign Support File" class="supfile btn btn-sm btn-blue1" href="'.base_url('admin/file_req/'.$cod01.'/'.$row['segflow_id']).'"> <i class="fa fa-file-o"></i></a>
                //<a title="Manage Nist Control" class="view btn btn-sm btn-success" href="'.base_url('admin/nist/'.$cod01.'/'.$row['segflow_id']).'">NIST</a>';

                $data[]= array(
                    ++$i,
                    $row['segment_answer'],
                    $row['goto_segment'],
                    $action
                    //$row['segment_code'],
                    //$row['segment_pid'],
                    //'<input class="tgl_checkbox tgl-ios" data-id="'.$row['segflow_id'].'" id="cb_'.$row['segflow_id'].'" type="checkbox" '.$status.'><label for="cb_'.$row['segflow_id'].'"></label>',
                    //$row['total'].' %',  
                );
            }
            $rec['data']=$data;
            echo json_encode($rec); 
        }

        public function change_status(){
            $status = $this->input->post('status');
            $id = $this->input->post('id');
            $res = $this->segflowmd->requirement_change_status($id, $status);
            //echo "affected rows: ".$res;
        }

        public function delete($id = 0){
            $this->rbac->check_operation_access();
            
            $cod01 = $this->uri->segment(4);
            $_id = $this->uri->segment(5);

            $this->segflowmd->segment_flow_delete($_id);
            $this->session->set_flashdata('msg', 'Segment Flow has been deleted successfully!');
            $bUrl = 'admin/segment_flow/'.$cod01;
            redirect( base_url($bUrl) );
        }

        public function add($id = 0){
            $this->rbac->check_operation_access();
            
            $cod01 = $id;
            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_segment_answer', 'Segment Answer', 'trim|required');
                $this->form_validation->set_rules('fv_goto_segment', 'Go To Segment', 'trim|required');

                if ($this->form_validation->run() == FALSE) {
                    $data['cod01'] = $cod01;
                    $data['view'] = 'admin/segment_flow/segment_flow_add';
                    $this->load->view('layout', $data);
                }
                else{
                    $rec_seg = $this->segflowmd->get_segment_by_id($cod01);
                    $segcode = $rec_seg['segment_code'];
                    $data = array(
                        'segment_answer' => $this->input->post('fv_segment_answer'),
                        'goto_segment' => $this->input->post('fv_goto_segment'),
                        'segment_code' => $segcode,
                        'segment_pid' => $cod01
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->segflowmd->segment_flow_add($data);
                    if($result){
                        $this->session->set_flashdata('msg', 'Segment Flow has been added successfully!');
                        redirect(base_url('admin/segment_flow/'.$cod01));
                    }
                }
            }
            else{
                $data['cod01'] = $cod01;
                $data['view'] = 'admin/segment_flow/segment_flow_add';
                $this->load->view('layout', $data);
            }
        }

        public function edit($id = 0){
            $this->rbac->check_operation_access();
            
            $cod01 = $this->uri->segment(4); //$id;
            $segflow_id = $this->uri->segment(5);

            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_segment_answer', 'Segment Answer', 'trim|required');
                $this->form_validation->set_rules('fv_goto_segment', 'Go To Segment', 'trim|required');

                if( $this->form_validation->run() == FALSE ){
                    $rec['segflow_id'] = $segflow_id; 
                    $rec['segment_answer'] = $this->input->post('fv_segment_answer');
                    $rec['goto_segment'] = $this->input->post('fv_goto_segment');

                    $data['cod01'] = $cod01;
                    $data['rec'] = $rec;
                    $data['view'] = 'admin/segment_flow/segment_flow_edit';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                        'segment_answer' => $this->input->post('fv_segment_answer'),
                        'goto_segment' => $this->input->post('fv_goto_segment'),
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->segflowmd->segment_flow_edit($data, $segflow_id);
                    if($result){
                        $this->session->set_flashdata('msg', 'Segment Flow has been updated successfully!');
                        redirect(base_url('admin/segment_flow/'.$cod01));
                    }
                }
            }
            else{
                $data['cod01'] = $cod01;
                $data['rec'] = $this->segflowmd->get_segment_flow_by_id($segflow_id);
                $data['view'] = 'admin/segment_flow/segment_flow_edit';
                $this->load->view('layout', $data);
            }
        }
    }
?>