<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load->model('admin/admin_model', 'admin_model');
	}
	//-------------------------------------------------------------------------
	public function index(){
		$this->load->library('utils');
		$files_path = $this->utils->get_files_path();
        $profile_pic_path = $files_path['profile_pics'];

		if($this->input->post('submit')){
			
			$all_ok = true;
			$filename = "";

			if( $_FILES['userpic']['error'] !== 4 ){ 
				//echo "Hay que subir pic<br />";

				$newfiname = $this->utils->gen_password(30);
                $files_path = $this->utils->get_files_path();
                $profile_pic_path = $files_path['profile_pics'];

                $config = [
                        'upload_path' => $profile_pic_path,
                        'allowed_types' => "png|jpg",
                        'file_name' => $newfiname,
                        'overwrite' => FALSE,
                        'max_size' => "5120000", // Can be set to particular file size , here it is 5 MB(5120 Kb)
                        'max_height' => "1200",
                        'max_width' => "1900",
                        'file_ext_tolower' => TRUE,
                        'remove_spaces' => TRUE
                    ];
                $this->load->library('upload', $config);
                if( !$this->upload->do_upload('userpic') ){
                	$filename = "";
                }
                else{
					$upData = $this->upload->data();
					$filename = $upData['file_name'];
            	}

            	$data = array(
					'username' => $this->input->post('username'),
					'firstname' => $this->input->post('firstname'),
					'lastname' => $this->input->post('lastname'),
					'email' => $this->input->post('email'),
					'mobile_no' => $this->input->post('mobile_no'),
					'image' => $filename,
					'updated_at' => date('Y-m-d : h:m:s'),
				);
			}
			else{
				$filename = $this->session->userdata('image');
				$data = array(
					'username' => $this->input->post('username'),
					'firstname' => $this->input->post('firstname'),
					'lastname' => $this->input->post('lastname'),
					'email' => $this->input->post('email'),
					'mobile_no' => $this->input->post('mobile_no'),
					'updated_at' => date('Y-m-d : h:m:s'),
				);
			}
			
			//echo "<pre>"; print_r($this->session->userdata()); echo "</pre>";

			
			$data = $this->security->xss_clean($data);
			$result = $this->admin_model->update_user($data);
			if($result){
				//--- update pic in session --------------
				$this->session->set_userdata('image', $filename);
				if( 1 == 2 ){
					$this->session->set_flashdata('msg', 'Profile has been Updated Successfully!');
					//redirect(base_url('admin/profile'), 'refresh');
				}
				else{
					$u_detail = $this->admin_model->get_user_detail(); //echo "<pre>"; print_r($u_detail); echo "</pre>";
					$data['pic_path'] = $profile_pic_path;
					$data['admin'] = $u_detail;
					$data['title'] = 'Admin Profile';
					$data['view'] = 'admin/profile/index';
					$this->load->view('layout', $data);
				}

			}
		}
		else{
			$u_detail = $this->admin_model->get_user_detail(); //echo "<pre>"; print_r($u_detail); echo "</pre>";
			$data['pic_path'] = $profile_pic_path;
			$data['admin'] = $u_detail;
			$data['title'] = 'Admin Profile';
			$data['view'] = 'admin/profile/index';
			$this->load->view('layout', $data);
		}
	}

	//-------------------------------------------------------------------------
	public function change_pwd(){
		$id = $this->session->userdata('admin_id');
		if($this->input->post('submit')){
			$this->form_validation->set_rules('password', 'Password', 'trim|required');
			$this->form_validation->set_rules('confirm_pwd', 'Confirm Password', 'trim|required|matches[password]');
			if ($this->form_validation->run() == FALSE) {
				$data['user'] = $this->admin_model->get_user_detail();
				$data['view'] = 'admin/profile/change_pwd';
				$this->load->view('layout', $data);
			}
			else{
				$data = array(
					'password' => password_hash($this->input->post('password'), PASSWORD_BCRYPT)
				);
				$data = $this->security->xss_clean($data);
				$result = $this->admin_model->change_pwd($data, $id);
				if($result){
					$this->session->set_flashdata('msg', 'Password has been changed successfully!');
					redirect(base_url('admin/profile/change_pwd'));
				}
			}
		}
		else{
			$data['user'] = $this->admin_model->get_user_detail();
			$data['title'] = 'Change Password';
			$data['view'] = 'admin/profile/change_pwd';
			$this->load->view('layout', $data);
		}
	}
}

?>	