<?php defined('BASEPATH') OR exit('No direct script access allowed');
    class Payment_gateway extends MY_Controller {
        function __construct(){
            parent::__construct();
            $this->load->model('admin/Payment_gateway_model', 'paymentgatemod');
            $this->load->library('datatable'); // loaded my custom serverside datatable library
        }

        public function index(){
            $data['view'] = 'admin/payment_gateway/payment_gateway_list';
            $this->load->view('layout', $data);
        }

        public function get_datatable_json(){
            $this->load->library('utils');
            //$op = $this->utils->action_validate_role( $this->session->userdata('admin_role') ); //echo "op: ".$op."<br />";

            $rec = $this->paymentgatemod->payment_gateway_get_all();
            $data = array();
            $i=0;
            foreach ($rec['data']  as $row){
                $status = ($row['is_active'] == 1)? 'checked': '';
				$sandbox = ($row['sandbox_on'] == 1)? 'checked': '';

                $link_mod = base_url('admin/payment_gateway/edit/'.$row['pg_id']);
                $link_del = base_url('admin/payment_gateway/delete/'.$row['pg_id']);

                $action = '';
                $action .= '<a title="Edit" class="update btn btn-sm btn-warning" href="'.$link_mod.'"> <i class="fa fa-pencil-square-o"></i></a> ';
                $action .= '<a title="Delete" class="delete btn btn-sm btn-danger" data-href="'.$link_del.'" data-toggle="modal" data-target="#confirm-delete"> <i class="fa fa-trash-o"></i></a> ';

                $data[]= array(
                    ++$i,
                    $row['name'],
                    $row['pg_name'],
                    $row['loginid'],
                    $row['api_key'],
                    //$row['api_url'],
                    $row['loginid_test'],
                    $row['api_key_test'],
                    //$row['api_url_test'],
                    '<input class="tgl_sandbox tgl-ios" data-id="'.$row['pg_id'].'" id="cb1_'.$row['pg_id'].'" type="checkbox" '.$sandbox.'><label for="cb1_'.$row['pg_id'].'"></label>',
                    '<input class="tgl_checkbox tgl-ios" data-id="'.$row['pg_id'].'" id="cb2_'.$row['pg_id'].'" type="checkbox" '.$status.'><label for="cb2_'.$row['pg_id'].'"></label>',
                    $action
                );
            }
            $rec['data']=$data;
            echo json_encode($rec); 
        }

        public function delete($id = 0){
            //$this->rbac->check_operation_access();
            $pg_id = $this->uri->segment(4);
            
            $this->paymentgatemod->payment_gateway_delete($pg_id);
            $this->session->set_flashdata('msg', 'The Product has been deleted successfully!');
            redirect(base_url('admin/payment_gateway'));
        }

        public function change_status(){
            $status = $this->input->post('status');
            $id = $this->input->post('id');
            $res = $this->paymentgatemod->payment_gateway_status($id, $status);
            //echo "affected rows: ".$res;
        }
		
		public function change_sandbox(){
            $sandbox = $this->input->post('sandbox');
            $id = $this->input->post('id');
            $res = $this->paymentgatemod->payment_gateway_sandbox($id, $sandbox);
            //echo "affected rows: ".$res;
        }

        public function add(){
            //$this->rbac->check_operation_access();
            
            $this->load->library('utils');
			
			$data['client'] = $this->paymentgatemod->payment_gateway_get_clients();

            if($this->input->post('submit')){
            	$this->form_validation->set_rules('fv_client', 'Client', 'trim|required');
				$this->form_validation->set_rules('fv_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_loginid', 'Login', 'trim|required');
                $this->form_validation->set_rules('fv_transkey', 'Key', 'trim|required');
                $this->form_validation->set_rules('fv_apiurl', 'Url', 'trim|required');
                $this->form_validation->set_rules('fv_test_loginid', 'Test Login', 'trim|required');
                $this->form_validation->set_rules('fv_test_transkey', 'Test Key', 'trim|required');
                $this->form_validation->set_rules('fv_test_apiurl', 'Test Url', 'trim|required');
				$this->form_validation->set_rules('fv_sandbox', 'Sandbox', 'trim|required');
                $this->form_validation->set_rules('fv_is_active', 'Status', 'trim|required');

                if ($this->form_validation->run() == FALSE) {
                    $data['view'] = 'admin/payment_gateway/payment_gateway_add';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                    	'client_pid' => $this->input->post('fv_client'),
                    	'pg_name' => $this->input->post('fv_name'),
                        'loginid' => $this->input->post('fv_loginid'),
                        'api_key' => $this->input->post('fv_transkey'),
                        'api_url' => $this->input->post('fv_apiurl'),
                        'loginid_test' => $this->input->post('fv_test_loginid'),
                        'api_key_test' => $this->input->post('fv_test_transkey'),
                        'api_url_test' => $this->input->post('fv_test_apiurl'),
                        'sandbox_on' => $this->input->post('fv_sandbox'),
                        'is_active' => $this->input->post('fv_is_active')
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->paymentgatemod->payment_gateway_add($data);
                    if($result){
                        $this->session->set_flashdata('msg', 'Global Setting has been added successfully!');
                        redirect(base_url('admin/payment_gateway'));
                    }
                }
            }
            else{
                $data['view'] = 'admin/payment_gateway/payment_gateway_add';
                $this->load->view('layout', $data);
            }
        }

        public function get_payment_gateway_decoded($id){
            $data_arr = array();
            $rec = $this->paymentgatemod->get_payment_gateway_by_id($id); //echo "<pre>"; print_r($rec); echo "</pre>";

            return $rec;
        }

        public function edit($id = 0){
            //$this->rbac->check_operation_access();

            $this->load->library('utils');
			
			$data['client'] = $this->paymentgatemod->payment_gateway_get_clients();

            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_client', 'Client', 'trim|required');
				$this->form_validation->set_rules('fv_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_loginid', 'Login', 'trim|required');
                $this->form_validation->set_rules('fv_transkey', 'Key', 'trim|required');
                $this->form_validation->set_rules('fv_apiurl', 'Url', 'trim|required');
                $this->form_validation->set_rules('fv_test_loginid', 'Test Login', 'trim|required');
                $this->form_validation->set_rules('fv_test_transkey', 'Test Key', 'trim|required');
                $this->form_validation->set_rules('fv_test_apiurl', 'Test Url', 'trim|required');
				$this->form_validation->set_rules('fv_sandbox', 'Sandbox', 'trim|required');
                $this->form_validation->set_rules('fv_is_active', 'Status', 'trim|required');

                if( $this->form_validation->run() == FALSE ){
                    
                    $rec['pg_id'] = $id;
					$rec['client_pid'] = $this->input->post('fv_client');
					$rec['pg_name'] = $this->input->post('fv_name');
                    $rec['loginid'] = $this->input->post('fv_loginid');
                    $rec['api_key'] = $this->input->post('fv_transkey');
                    $rec['api_url'] = $this->input->post('fv_apiurl');
					$rec['loginid_test'] = $this->input->post('fv_test_loginid');
                    $rec['api_key_test'] = $this->input->post('fv_test_transkey');
                    $rec['api_url_test'] = $this->input->post('fv_test_apiurl');
					$rec['sandbox_on'] = $this->input->post('fv_sandbox');
                    $rec['is_active'] = $this->input->post('fv_is_active');
                    
                    $data['rec'] = $rec;
                    $data['view'] = 'admin/payment_gateway/payment_gateway_edit';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                    	'client_pid' => $this->input->post('fv_client'),
                    	'pg_name' => $this->input->post('fv_name'),
                        'loginid' => $this->input->post('fv_loginid'),
                        'api_key' => $this->input->post('fv_transkey'),
                        'api_url' => $this->input->post('fv_apiurl'),
                        'loginid_test' => $this->input->post('fv_test_loginid'),
                        'api_key_test' => $this->input->post('fv_test_transkey'),
                        'api_url_test' => $this->input->post('fv_test_apiurl'),
                        'sandbox_on' => $this->input->post('fv_sandbox'),
                        'is_active' => $this->input->post('fv_is_active')
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->paymentgatemod->payment_gateway_edit($data, $id);
                    if($result){
                        $this->session->set_flashdata('msg', 'Global Setting has been updated successfully!');
                        redirect(base_url('admin/payment_gateway'));
                    }
                }
            }
            else{
                $rec = $this->get_payment_gateway_decoded($id); //echo "<pre>"; print_r($rec_client); echo "</pre>";
                $data['rec'] = $rec;
                $data['view'] = 'admin/payment_gateway/payment_gateway_edit';
                $this->load->view('layout', $data);
            }
        }

        public function prodadd($cod01, $prod_id){
            $data = array(
                'q_pid' => $q_id,
                'admin_pid' => $user_id,
                'user_type' => 'u',
                'is_done' => '0',
                'data' => '',
                'date_n' => '0',
                'date_d' => '00-00-00 00:00:00'

            );
            $data = $this->security->xss_clean($data);
            $result = $this->user_question_model->assign($data);
            if($result){
                $this->session->set_flashdata('msg', 'Support file has been assigned successfully!');
                redirect(base_url('admin/user_question/'.$params));
            }
        }
    }
?>