<?php
$mainmenu = $this->mainmenu->buildMenu($session_data['utype'], 2);
$prof_inf = $this->messages->getUserInf($session_data['id']);
$data['title'] = "USER";
$data['mainmenu'] = $mainmenu;
$data['profinf'] = $prof_inf;
$data['userinf'] = $session_data;
if (isset($msg)) {
    $data['msg'] = $this->messages->getMessage($msg);
}
$this->load->view('layout/header2', $data);
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Add User
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i>Add User</a></li>
        </ol>
    </section>
    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">please add your user</h3>
            </div>
            <div class="box-body">
                <?php echo form_open('settings/save_user', 'id="form1" data-parsley-validate class=""'); ?>
                <div class="row">
                    <div class="col-md-6">
                        <label for="first-name"> First Name <span class="required">*</span>
                        </label>
                        <?php
                        echo form_hidden('UserID', $user['UserID']);
                        echo form_input('FirstName', $user['FirstName'], 'class="form-control"'); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="last-name"> Last Name <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('LastName', $user['LastName'], 'class="form-control"'); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="email"> Email <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('Email', $user['Email'], 'class="form-control"'); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="password"> Password <span class="required">*</span>
                        </label>
                        <?php
                        echo form_password('Password', $user['Password'], 'class="form-control"'); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="phone"> Phone <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('Phone', $user['Phone'], 'class="form-control Phone_c"'); ?>
                    </div>
                    <?php if($user['RoleID']!=3){?>
                    <div class="col-md-6">
                        <label for="last-name"> Role <span class="required">*</span>
                        </label>
                        <?php
                        echo form_dropdown('RoleID', $role, $user['RoleID'], 'class="form-control col-md-7 col-xs-12"');
                        ?>
                    </div>
                    <?php } ?>
                </div>

                <br>
                <div class="box-footer">
                    <button type="submit" value="Validate!" class="btn btn-success pull-right">Submit</button>
                </div>
                <?php echo form_close(); ?>
            </div>

        </div>

    </section>
</div>

<?php
$this->load->view('layout/footer2');
?>
<script type="text/javascript" src="<?php echo base_url(); ?>layout/js/jquery.validate.js"></script>
<script>
    var cleave = new Cleave('.Phone_c', {
        phone: true,
        phoneRegionCode: 'us'
    });

    $(document).ready(function () {
        jQuery.validator.addMethod("lettersonly", function (value, element) {
            return this.optional(element) || /^[a-z]+$/i.test(value);
        }, "Please enter only letters without space.");
        $("#form1").validate({
            errorElement: "p",
            rules: {
                FirstName: {
                    required: true,
                },
                LastName: {
                    required: true,
                },
                Phone: {
                    required: true,
                },
                Password: {
                    required: true
                },
                Email: {
                    required: true,
                    email: true
                },
                RoleID: {
                    required: true,
                }
            },
            errorPlacement: function (error, element) {
                error.appendTo(element.parent());
            }
        });
    });

</script>