<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_appointment_notes extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'NoteID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'AppointmentID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ),
            'Note' => array(
                'type' => 'VARCHAR',
                'constraint' => 200,
                'null' => TRUE
            ),
            'Active' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
                'default' => 1
            ),
            'Internal' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
                'default' => 1
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('NoteID', TRUE);
        $this->dbforge->create_table('appointment_notes');

    }

    public function down() {
        $this->dbforge->drop_table('appointment_notes');
    }

}