<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_contractor extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'ContractorID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'UserID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ),
            'BasePrice' => array(
                'type' => 'FLOAT',
                'constraint' => 10,
                'null' => TRUE
            ),
            'TotalPrice' => array(
                'type' => 'FLOAT',
                'constraint' => 14,
                'null' => TRUE
            ),
            'Zip' => array(
                'type' => 'VARCHAR',
                'constraint' => 10,
                'null' => TRUE
            ),
            'RAsphalt' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'RFlat' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'RMetal' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'RTile' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'RShake' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'Timing' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'QSpanish' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'QCash' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'QDeniedClaims' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'RoofAge' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'ValueCode' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE,
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('ContractorID', TRUE);
        $this->dbforge->create_table('contractors');

    }

    public function down() {
        $this->dbforge->drop_table('contractors');
    }

}