<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_office extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'OfficeID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'OfficeName' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => TRUE
            ),
            'OfficeDescription' => array(
                'type' => 'VARCHAR',
                'constraint' => 128,
                'null' => TRUE
            ),
            'OwnerID' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE
            ),
            'Active' => array(
                'type' => 'INT',
                'constraint' => 2,
                'default' => 1,
                'null' => TRUE
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('OfficeID', TRUE);
        $this->dbforge->create_table('offices');

        $data = array(
            array('OfficeName' => 'office 1','OfficeDescription' => 'office 1','OwnerID' => 1),
            array('OfficeName' => 'office 2','OfficeDescription' => 'office 1','OwnerID' => 1),

        );
        $this->db->insert_batch('offices', $data);
    }

    public function down() {
        $this->dbforge->drop_table('offices');
    }

}