<?php
    Class Utils{
        public function get_truncate_str( $str, $wordCount = 10 ) {
            return implode( 
                '', 
                array_slice( 
                    preg_split(
                        '/([\s,\.;\?\!]+)/', 
                        $str, 
                        $wordCount*2+1, 
                        PREG_SPLIT_DELIM_CAPTURE
                    ),
                    0,
                    $wordCount*2-1
                )
            );
        }

        public function action_validate_role( $_role ){
            $role = strtolower($_role);
            if( $role == 'super admin'){
                $op = 'sadm';
            }
            elseif( $role == 'admin' ){
                $op = 'adm';
            }
            elseif( $role == 'user' ){
                $op = 'usr';
            }
            return $op;
        }

        public function mysql_encode_val( $val ){
            $str = htmlentities( addslashes( $val ), ENT_QUOTES );
            return $str;
        }
    
        public function mysql_decode_val( $val ){
            $str = stripslashes( html_entity_decode( $val, ENT_QUOTES ) );
            return $str;
        }
    
        public function isNumber($val){
            $res = true;
            if( !preg_match('/^[0-9]{0,15}$/', $val) ){
                $res = false;
            }
    
            return $res;
        }
    
        public function isBinary($val){
            $res = true;
            if( !preg_match('/^[0-1]{0,1}$/', $val) ){
                $res = false;
            }
    
            return $res;
        }
    
        public function isInteger($val){
            $res = true;
            if( !preg_match('/^[1-9][0-9]{0,15}$/', $val) ){
                $res = false;
            }
    
            return $res;
        }
    
        public function isFloat($val){
            $res = true;
            if( !preg_match('/^[0-9.]{0,15}$/', $val) ){
                $res = false;
            }
            
            return $res;
        }
    
        public function isAlpha($val){
            $res = true;
            if( !preg_match('/^[a-zA-Z]*$/', $val) ){
                $res = false;
            }
    
            return $res;
        }
    
        public function isAlphaNum($val){
            $res = true;
            if( !preg_match('/^[a-zA-Z0-9 #()?\'\"@,-\/:`\~._]*$/', $val) ){
                $res = false;
            }
            return $res;
        }
    
        public function isEmail($val){
            $res = true;
            if( !preg_match('/^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/', $val) ){
                $res = false;
            }
            return $res;
        }
    
        public function isPhone($val){
            $res = true;
            //if( !preg_match('/^((\+[1-9]{1,4}[ \-]*)|(\([0-9]{2,3}\)[ \-]*)|([0-9]{2,4})[ \-]*)*?[0-9]{3,4}?[ \-]*[0-9]{3,4}?$/', $val) ):
            if( !preg_match('/^[0-9]{3}-[0-9]{3}-[0-9]{4}$/', $val) ){
                $res = false;
            }
            return $res;
        }
    
        public function isWebsite($val){
            $res = true;
            if ( !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i",$val) ){
                $res = false;
            }
            return $res;
        }
    
        public function isAddress($val){
            $res = true;
            if( !preg_match('/^[a-zA-Z0-9 #,-]*$/', $val) ){
                $res = false;
            }
            return $res;
        }

        public function generate_session_keyOLD( $segment, $agent, $callrec, $customer_phone ){
            $str = $key = '';
            $str = $segment.$agent.$callrec.$customer_phone;
            $key = base64_encode($str);

            return $key;
        }

        public function generate_session_key( $segcode, $cusphone, $comphone ){
            $ddebug = false;
            if( $ddebug ) echo "segcode: ".$segcode."<br />";
            if( $ddebug ) echo "cusphone: ".$cusphone."<br />";
            if( $ddebug ) echo "comphone: ".$comphone."<br />";
            $str = $key = '';
            $str = $segcode.$cusphone.$comphone; if( $ddebug ) echo "str: ".$str."<br />";
            $key = base64_encode($str); if( $ddebug ) echo "key: ".$key."<br />";



            return $key;
        }

        public function generate_params_json($segment, $agent, $callrec, $customer_phone, $company_phone){
            $param_json = '';
            $param_arr = array();
            $param_arr['segment'] = $segment;
            $param_arr['agent'] = $agent;
            $param_arr['callrec'] = $callrec;
            $param_arr['customer_phone'] = $customer_phone;
            $param_arr['company_phone'] = $company_phone;

            $param_json = json_encode( $param_arr );

            return $param_json;
        }

        public function get_json_data_ready( $session_data_json, $step, $prod_qty_arr, $segment_id, $segflow_id ){

            if( 1 == 2 ){
                echo "============ osys_get_json_data_ready ======================<br />";
                echo "step: ".$step."<br />";
                //echo "product_id: ".$product_id."<br />";
                echo "segment_id: ".$segment_id."<br />";
                echo "segflow_id: ".$segflow_id."<br />";
                echo "<pre>"; print_r($prod_qty_arr); echo "</pre>";
            }

            $prod = array();
            $prods = array();
            $sess_data = array();

            if( $session_data_json == "" ){
                $prod['step'] = $step;
                $prod['prod'] = $prod_qty_arr;
                $prod['segment_id'] = $segment_id;
                $prod['segflow_id'] = $segflow_id;

                //$sess_data['status'] = $status;
                $sess_data['sess_data'][] = $prod;
            }
            else{
                $prod['step'] = $step;
                $prod['prod'] = $prod_qty_arr;
                $prod['segment_id'] = $segment_id;
                $prod['segflow_id'] = $segflow_id;
                //echo "<pre>"; print_r($prod); echo "</pre>";

                $data_sess = json_decode($session_data_json, true); //echo "data_sess<br /><pre>"; print_r($data_sess); echo "</pre>";
                
                $prods = $data_sess['sess_data']; //echo "prods<br /><pre>"; print_r($prods); echo "</pre>";
                $prods[] = $prod; //echo "<pre>"; print_r($prods); echo "</pre>";

                //$sess_data['status'] = $status;
                $sess_data['sess_data'] = $prods;
            }
            //echo "[SESS_DATA]<pre>"; print_r($sess_data); echo "</pre>";
            //echo json_encode($sess_data)."<br />";
            return json_encode($sess_data);
        }

        public function get_json_data_readyOLD( $session_data_json, $step, $product_id, $segment_id, $segflow_id ){

            if( 1 == 2 ){
                echo "============ osys_get_json_data_ready ======================<br />";
                echo "step: ".$step."<br />";
                echo "product_id: ".$product_id."<br />";
                echo "segment_id: ".$segment_id."<br />";
                echo "segflow_id: ".$segflow_id."<br />";
            }

            $prod = array();
            $prods = array();
            $sess_data = array();

            if( $session_data_json == "" ){
                $prod['step'] = $step;
                $prod['prod_id'] = $product_id;
                $prod['segment_id'] = $segment_id;
                $prod['segflow_id'] = $segflow_id;

                //$sess_data['status'] = $status;
                $sess_data['sess_data'][] = $prod;
            }
            else{
                $prod['step'] = $step;
                $prod['prod_id'] = $product_id;
                $prod['segment_id'] = $segment_id;
                $prod['segflow_id'] = $segflow_id;
                //echo "<pre>"; print_r($prod); echo "</pre>";

                $data_sess = json_decode($session_data_json, true); //echo "data_sess<br /><pre>"; print_r($data_sess); echo "</pre>";
                
                $prods = $data_sess['sess_data']; //echo "prods<br /><pre>"; print_r($prods); echo "</pre>";
                $prods[] = $prod; //echo "<pre>"; print_r($prods); echo "</pre>";

                //$sess_data['status'] = $status;
                $sess_data['sess_data'] = $prods;
            }
            //echo "sess_data<br /><pre>"; print_r($sess_data); echo "</pre>";
            //echo json_encode($sess_data)."<br />";
            return json_encode($sess_data);
        }

        public function get_cc_months(){
            $month_arr = array();
			$month_arr['01'] = 'January';
            $month_arr['02'] = 'February';
            $month_arr['03'] = 'March';
            $month_arr['04'] = 'April';
            $month_arr['05'] = 'May';
            $month_arr['06'] = 'June';
            $month_arr['07'] = 'July';
            $month_arr['08'] = 'August';
            $month_arr['09'] = 'September';
            $month_arr['10'] = 'October';
            $month_arr['11'] = 'November';
            $month_arr['12'] = 'December';

            return $month_arr;
        }

        public function get_cc_years(){
            $year_arr = array();

            $year = date('Y');
            $num = 6;
            for( $i=0; $i<$num; $i++ ){
                if( $i == 0 ){
                    $year_arr[] = $year;
                }
                else{
                    $year_arr[] = $year + $i;
                }
            }

            return $year_arr;
        }

        public function get_states(){
            $state_arr = array();
            //<option value="">Select an option…</option>
            
            $state_arr[0][0] = "AL";
            $state_arr[0][1] = "Alabama";
            $state_arr[1][0] = "AK";
            $state_arr[1][1] = "Alaska";
            $state_arr[2][0] = "AZ";
            $state_arr[2][1] = "Arizona";
            $state_arr[3][0] = "AR";
            $state_arr[3][1] = "Arkansas";
            $state_arr[4][0] = "CA";
            $state_arr[4][1] = "California";
            $state_arr[5][0] = "CO";
            $state_arr[5][1] = "Colorado";
            $state_arr[6][0] = "CT";
            $state_arr[6][1] = "Connecticut";
            $state_arr[7][0] = "DE";
            $state_arr[7][1] = "Delaware";
            $state_arr[8][0] = "DC";
            $state_arr[8][1] = "District Of Columbia";
            $state_arr[9][0] = "FL";
            $state_arr[9][1] = "Florida";
            
            $state_arr[10][0] = "GA";
            $state_arr[10][1] = "Georgia";
            //$state_arr[11][0] = "GU";
            //$state_arr[11][1] = "Guam";
            $state_arr[11][0] = "HI";
            $state_arr[11][1] = "Hawaii";
            $state_arr[12][0] = "ID";
            $state_arr[12][1] = "Idaho";
            $state_arr[13][0] = "IL";
            $state_arr[13][1] = "Illinois";
            $state_arr[14][0] = "IN";
            $state_arr[14][1] = "Indiana";
            $state_arr[15][0] = "IA";
            $state_arr[15][1] = "Iowa";
            $state_arr[16][0] = "KS";
            $state_arr[16][1] = "Kansas";
            $state_arr[17][0] = "KY";
            $state_arr[17][1] = "Kentucky";
            $state_arr[18][0] = "LA";
            $state_arr[18][1] = "Louisiana";
            $state_arr[19][0] = "ME";
            $state_arr[19][1] = "Maine";

            $state_arr[20][0] = "MD";
            $state_arr[20][1] = "Maryland";
            $state_arr[21][0] = "MA";
            $state_arr[21][1] = "Massachusetts";
            $state_arr[22][0] = "MI";
            $state_arr[22][1] = "Michigan";
            $state_arr[23][0] = "MN";
            $state_arr[23][1] = "Minnesota";
            $state_arr[24][0] = "MS";
            $state_arr[24][1] = "Mississippi";
            $state_arr[25][0] = "MO";
            $state_arr[25][1] = "Missouri";
            $state_arr[26][0] = "MT";
            $state_arr[26][1] = "Montana";
            $state_arr[27][0] = "NE";
            $state_arr[27][1] = "Nebraska";
            $state_arr[28][0] = "NV";
            $state_arr[28][1] = "Nevada";
            $state_arr[29][0] = "NH";
            $state_arr[29][1] = "New Hampshire";
            
            $state_arr[30][0] = "NJ";
            $state_arr[30][1] = "New Jersey";
            $state_arr[31][0] = "NM";
            $state_arr[31][1] = "New Mexico";
            $state_arr[32][0] = "NY";
            $state_arr[32][1] = "New York";
            $state_arr[33][0] = "NC";
            $state_arr[33][1] = "North Carolina";
            $state_arr[34][0] = "ND";
            $state_arr[34][1] = "North Dakota";
            $state_arr[35][0] = "OH";
            $state_arr[35][1] = "Ohio";
            $state_arr[36][0] = "OK";
            $state_arr[36][1] = "Oklahoma";
            $state_arr[37][0] = "OR";
            $state_arr[37][1] = "Oregon";
            $state_arr[38][0] = "PA";
            $state_arr[38][1] = "Pennsylvania";
            //$state_arr[39][0] = "PR";
            //$state_arr[39][1] = "Puerto Rico";
            $state_arr[39][0] = "RI";
            $state_arr[39][1] = "Rhode Island";
            
            $state_arr[40][0] = "SC";
            $state_arr[40][1] = "South Carolina";
            $state_arr[41][0] = "SD";
            $state_arr[41][1] = "South Dakota";
            $state_arr[42][0] = "TN";
            $state_arr[42][1] = "Tennessee";
            $state_arr[43][0] = "TX";
            $state_arr[43][1] = "Texas";
            $state_arr[44][0] = "UT";
            $state_arr[44][1] = "Utah";
            $state_arr[45][0] = "VT";
            $state_arr[45][1] = "Vermont";
            $state_arr[46][0] = "VA";
            $state_arr[46][1] = "Virginia";
            $state_arr[47][0] = "WA";
            $state_arr[47][1] = "Washington";
            $state_arr[48][0] = "WV";
            $state_arr[48][1] = "West Virginia";
            $state_arr[49][0] = "WI";
            $state_arr[49][1] = "Wisconsin";
            $state_arr[50][0] = "WY";
            $state_arr[50][1] = "Wyoming";
            $state_arr[51][0] = "AA";
            $state_arr[51][1] = "Armed Forces (AA)";
            $state_arr[52][0] = "AE";
            $state_arr[52][1] = "Armed Forces (AE)";
            $state_arr[53][0] = "AP";
            $state_arr[53][1] = "Armed Forces (AP)";

            return $state_arr;
        }

        public function get_state($state){
            
            $state_arr["alabama"] = "AL";
            $state_arr["alaska"] = "AK";
            $state_arr["arizona"] = "AZ";
            $state_arr["arkansas"] = "AR";
            $state_arr["california"] = "CA";
            $state_arr["colorado"] = "CO";
            $state_arr["connecticut"] = "CT";
            $state_arr["delaware"] = "DE";
            $state_arr["district of columbia"] = "DC";
            $state_arr["florida"] = "FL";
            
            $state_arr["georgia"] = "GA";
            $state_arr["Hawaii"] = "HI";
            $state_arr["idaho"] = "ID";
            $state_arr["illinois"] = "IL";
            $state_arr["indiana"] = "IN";
            $state_arr["iowa"] = "IA";
            $state_arr["kansas"] = "KS";
            $state_arr["kentucky"] = "KY";
            $state_arr["louisiana"] = "LA";
            $state_arr["maine"] = "ME";

            $state_arr["maryland"] = "MD";
            $state_arr["massachusetts"] = "MA";
            $state_arr["michigan"] = "MI";
            $state_arr["minnesota"] = "MN";
            $state_arr["mississippi"] = "MS";
            $state_arr["missouri"] = "MO";
            $state_arr["montana"] = "MT";
            $state_arr["nebraska"] = "NE";
            $state_arr["nevada"] = "NV";
            $state_arr["new hampshire"] = "NH";
            
            $state_arr["new jersey"] = "NJ";
            $state_arr["new mexico"] = "NM";
            $state_arr["new york"] = "NY";
            $state_arr["north carolina"] = "NC";
            $state_arr["north dakota"] = "ND";
            $state_arr["ohio"] = "OH";
            $state_arr["oklahoma"] = "OK";
            $state_arr["oregon"] = "OR";
            $state_arr["pennsylvania"] = "PA";
            $state_arr["rhode island"] = "RI";
            
            $state_arr["south carolina"] = "SC";
            $state_arr["south dakota"] = "SD";
            $state_arr["tennessee"] = "TN";
            $state_arr["texas"] = "TX";
            $state_arr["utah"] = "UT";
            $state_arr["vermont"] = "VT";
            $state_arr["virginia"] = "VA";
            $state_arr["washington"] = "WA";
            $state_arr["west virginia"] = "WV";
            $state_arr["wisconsin"] = "WI";
            
            $state_arr["wyoming"] = "WY";
            $state_arr["armed forces (aa)"] = "AA";
            $state_arr["armed forces (ae)"] = "AE";
            $state_arr["armed forces (ap)"] = "AP";

            $state = strtolower($state);
            $rs = $state_arr[$state];

            return $rs;
        }

        public function get_cctype(){
            $cctype_arr = array();
            $cctype_arr[0][0] = 'ae';
            $cctype_arr[0][1] = 'American Express';
            $cctype_arr[1][0] = 'vi';
            $cctype_arr[1][1] = 'Visa';
            $cctype_arr[2][0] = 'mc';
            $cctype_arr[2][1] = 'Mastercard';
            $cctype_arr[3][0] = 'di';
            $cctype_arr[3][1] = 'Discover';

            return $cctype_arr;
        }

        public function get_files_path(){
            $data_arr = array();
            $data_arr['profile_pics'] = './uploads/profile_pics/';
            $data_arr['bug'] = './uploads/bugs/';

            return $data_arr;
        }

        public function gen_password( $passwLen = 30 ){
            //$passwLen = 20;
            $strUpper = "abcdefghijklmnopqrstuvwxyz";
            $strLower = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            $strNumber = "12345678910";
            $strChr = ""; //"@-_#&*()!$%+";

            $str = $strUpper.$strLower.$strNumber.$strChr.$strUpper.$strLower.$strNumber.$strChr;
            $pw = array();
            $ln = strlen($str) - 1;
            
            for( $i=0; $i < $passwLen; $i++ ){
                $n = rand(0, $ln);
                $pw[] = $str[$n];
            }
            $passw = implode("", $pw);

            return $passw;
        }

        public function get_file_ext( $file ){
            //$filename = $_FILES['bugpic01']['name']; echo "filename: ".$filename."<br />";
            $pos = strpos($file, "."); //echo "pos: ".$pos."<br />";
            $ext = substr( $file, ($pos+1) ); //echo "str: ".$str."<br />";

            return $ext;
        }
    }
?>