<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller
{
    function __construct(){
        parent::__construct();
        $this->load->library('rbac');
        $this->load->model('admin/admin_model', 'admin');

        $this->rbac->check_module_access();
    }

    //-----------------------------------------------------		
    function index($type=''){
        $this->session->set_userdata('filter_type',$type);
        $this->session->set_userdata('filter_keyword','');
        $this->session->set_userdata('filter_status','');

        $data['admin_roles'] = $this->admin->get_admin_roles();
        $data['view']='admin/admin/index';
        $this->load->view('layout',$data);
    }

    //---------------------------------------------------------
    function filterdata(){
        $this->session->set_userdata('filter_type',$this->input->post('type'));
        $this->session->set_userdata('filter_status',$this->input->post('status'));
        $this->session->set_userdata('filter_keyword',$this->input->post('keyword'));
    }

    //--------------------------------------------------		
    function list_data(){
        $data['info'] = $this->admin->get_all();
        $this->load->view('admin/admin/list',$data);
    }

    //-----------------------------------------------------------
    function change_status(){
        $this->rbac->check_operation_access(); // check opration permission
        $this->admin->change_status();
    }

    //--------------------------------------------------
    function add(){
        $this->rbac->check_operation_access(); // check opration permission
        $this->load->library('utils');
        
        $uploadPic = true;

        //echo "<pre>"; print_r($_POST); echo "</pre>";
        //echo "<pre>"; print_r($_FILES); echo "</pre>";

        if($this->input->post('submit')){
            $this->form_validation->set_rules('username', 'Username', 'trim|required');
            $this->form_validation->set_rules('firstname', 'Firstname', 'trim|required');
            $this->form_validation->set_rules('lastname', 'Lastname', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|valid_email|required');
            $this->form_validation->set_rules('mobile_no', 'Number', 'trim|required');
            $this->form_validation->set_rules('password', 'Password', 'trim|required');
            $this->form_validation->set_rules('role', 'Role', 'trim|required');

            //--- INI :: validate upload --------------------------------------------
            if( $_FILES['userpic']['error'] !== 4 ){ $uploadEmpty = false; }else{ $uploadEmpty = true; }
            

            if ($this->form_validation->run() == FALSE || $uploadEmpty ) {
                $data['error'] = "";
                $data['uploadEmpty'] = $uploadEmpty;
                $data['admin_roles']=$this->admin->get_admin_roles();
                $data['view'] = 'admin/admin/add';
                $this->load->view('layout', $data);
            }
            else{
                //--- Upload Profile Pic -----------------------------------------
                    $newfiname = $this->utils->gen_password(30);
                    $files_path = $this->utils->get_files_path();
                    $profile_pic_path = $files_path['profile_pics'];

                    $config = [
                            'upload_path' => $profile_pic_path,
                            'allowed_types' => "png|jpg",
                            'file_name' => $newfiname,
                            'overwrite' => FALSE,
                            'max_size' => "5120000", // Can be set to particular file size , here it is 5 MB(5120 Kb)
                            'max_height' => "1200",
                            'max_width' => "1900",
                            'file_ext_tolower' => TRUE,
                            'remove_spaces' => TRUE
                        ];
                    $this->load->library('upload', $config);

                if( !$this->upload->do_upload('userpic') ){
                    $data['error'] = array('error' => $this->upload->display_errors());
                    $data['uploadEmpty'] = $uploadEmpty;
                    $data['admin_roles']=$this->admin->get_admin_roles();
                    $data['view']='admin/admin/add';
                    $this->load->view('layout', $data);
                }
                else{
                    $upData = $this->upload->data();
                    $filename = $upData['file_name']; //echo "filename: ".$filename."<br />";

                    $data_arr = array(
                        'admin_role_id' => $this->input->post('role'),
                        'username' => $this->input->post('username'),
                        'firstname' => $this->input->post('firstname'),
                        'lastname' => $this->input->post('lastname'),
                        'email' => $this->input->post('email'),
                        'mobile_no' => $this->input->post('mobile_no'),
                        'image' => $filename,
                        'password' =>  password_hash($this->input->post('password'), PASSWORD_BCRYPT),
                        'is_active' => 1,
                        'created_at' => date('Y-m-d : h:m:s'),
                        'updated_at' => date('Y-m-d : h:m:s'),
                    );
                    
                    $data_arr = $this->security->xss_clean($data_arr);
                    $result = $this->admin->add_admin($data_arr);
                    if($result){
                        $this->session->set_flashdata('msg', 'Admin has been added successfully!');
                        redirect(base_url('index.php/admin/admin'));
                    }
                }
            }
        }
        else
        {
            $data['error'] = "";
            $data['uploadEmpty'] = false;
            $data['admin_roles']=$this->admin->get_admin_roles();
            $data['view']='admin/admin/add';
            $this->load->view('layout',$data);
        }
    }

    //--------------------------------------------------
    function edit($id=""){
        $this->rbac->check_operation_access(); // check opration permission
        $this->load->library('utils');

        //$data['admin_roles'] = $this->admin->get_admin_roles();
        $files_path = $this->utils->get_files_path();
        $profile_pic_path = $files_path['profile_pics'];
        $cur_id = $this->session->userdata('admin_id');

        if($this->input->post('submit')){
            $this->form_validation->set_rules('username', 'Username', 'trim|required');
            $this->form_validation->set_rules('firstname', 'Firstname', 'trim|required');
            $this->form_validation->set_rules('lastname', 'Lastname', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|valid_email|required');
            $this->form_validation->set_rules('mobile_no', 'Number', 'trim|required');
            $this->form_validation->set_rules('role', 'Role', 'trim|required');

            //--- INI :: validate upload --------------------------------------------
            //echo "<pre>"; print_r($_FILES); echo "</pre>";
            if( $_FILES['userpic']['error'] !== 4 ){ $uploadEmpty = false; }else{ $uploadEmpty = true; }
            
            if ($this->form_validation->run() == FALSE ) {
                $data['error'] = "";
                $data['admin_roles']=$this->admin->get_admin_roles();
                $data['pic_path'] = $profile_pic_path;
                $data['admin'] = $this->admin->get_admin_by_id($id);
                $data['view'] = 'admin/admin/edit';
                $this->load->view('layout', $data);
            }
            else{
                if( !$uploadEmpty ){
                    //--- Upload Profile Pic -----------------------------------------
                        
                        $newfiname = $this->utils->gen_password(30);
                        $files_path = $this->utils->get_files_path();
                        $profile_pic_path = $files_path['profile_pics'];

                        $config = [
                                'upload_path' => $profile_pic_path,
                                'allowed_types' => "png|jpg",
                                'file_name' => $newfiname,
                                'overwrite' => FALSE,
                                'max_size' => "5120000", // Can be set to particular file size , here it is 5 MB(5120 Kb)
                                'max_height' => "1200",
                                'max_width' => "1900",
                                'file_ext_tolower' => TRUE,
                                'remove_spaces' => TRUE
                            ];
                        $this->load->library('upload', $config);
                    
                    if( !$this->upload->do_upload('userpic') ){
                        $data['error'] = array('error' => $this->upload->display_errors());
                        $data['admin_roles']=$this->admin->get_admin_roles();
                        $data['pic_path'] = $profile_pic_path;
                        $data['admin'] = $this->admin->get_admin_by_id($id);
                        $data['view']='admin/admin/add';
                        $this->load->view('layout', $data);
                    }
                    else{
                        $upData = $this->upload->data();
                        $filename = $upData['file_name']; //echo "filename: ".$filename."<br />";

                        $data_arr = array(
                            'admin_role_id' => $this->input->post('role'),
                            'username' => $this->input->post('username'),
                            'firstname' => $this->input->post('firstname'),
                            'lastname' => $this->input->post('lastname'),
                            'email' => $this->input->post('email'),
                            'mobile_no' => $this->input->post('mobile_no'),
                            'image' => $filename,
                            'is_active' => 1,
                            'updated_at' => date('Y-m-d : h:m:s'),
                        );
                        
                        $data_arr = $this->security->xss_clean($data_arr);
                        $result = $this->admin->edit_admin($data_arr, $id);
                        if( $result ){
                            if( $cur_id == $id ){ $this->session->set_userdata('image', $filename); }
                            $this->session->set_flashdata('msg', 'Admin has been updated successfully!');
                            redirect(base_url('index.php/admin/admin'));
                        }
                        else{
                            //echo "[cur_id: ".$cur_id."][id: ".$id."]";
                            if( $cur_id == $id ){ $this->session->set_userdata('image', $filename); }
                            $data['error'] = "";
                            $data['admin_roles'] = $this->admin->get_admin_roles();
                            $data['pic_path'] = $profile_pic_path;
                            $data['admin'] = $this->admin->get_admin_by_id($id);
                            $data['view'] = 'admin/admin/edit';
                            $this->load->view('layout',$data);
                        }
                    }
                }
                else{
                    $data_arr = array(
                        'admin_role_id' => $this->input->post('role'),
                        'username' => $this->input->post('username'),
                        'firstname' => $this->input->post('firstname'),
                        'lastname' => $this->input->post('lastname'),
                        'email' => $this->input->post('email'),
                        'mobile_no' => $this->input->post('mobile_no'),
                        'is_active' => 1,
                        'updated_at' => date('Y-m-d : h:m:s'),
                    );
                    
                    $data_arr = $this->security->xss_clean($data_arr);
                    $result = $this->admin->edit_admin($data_arr, $id);
                    if( $result ){
                        $this->session->set_flashdata('msg', 'Admin has been updated successfully!');
                        redirect( base_url('index.php/admin/admin') );
                    }
                    else{
                        $data['error'] = "";
                        $data['admin_roles'] = $this->admin->get_admin_roles();
                        $data['pic_path'] = $profile_pic_path;
                        $data['admin'] = $this->admin->get_admin_by_id($id);
                        $data['view'] = 'admin/admin/edit';
                        $this->load->view('layout',$data);
                    }
                }
            }
        }
        elseif($id==""){
            redirect('admin/admin');
        }
        else{
            //echo "<pre>"; print_r($this->session->userdata()); echo "</pre>";
            $data['error'] = "";
            $data['admin_roles'] = $this->admin->get_admin_roles();
            $data['pic_path'] = $profile_pic_path;
            $data['admin'] = $this->admin->get_admin_by_id($id);
            $data['view'] = 'admin/admin/edit';
            $this->load->view('layout',$data);
        }
    }

    //--------------------------------------------------
    function check_username($id=0){
        $this->db->from('admin');
        $this->db->where('username', $this->input->post('username'));
        $this->db->where('admin_id !='.$id);
        $query=$this->db->get();
        if($query->num_rows() >0)
            echo 'false';
        else 
            echo 'true';
    }

    //------------------------------------------------------------
    function delete($id=''){
        $this->rbac->check_operation_access(); // check opration permission

        $this->admin->delete($id);
        $this->session->set_flashdata('success','User has been Deleted Successfully.');	
        redirect('admin/admin');
    }
}

?>