<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Appointment extends MY_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library(array('session'));
        if($this->session->userdata('login_data'))
        {
            $session_data = $this->session->userdata('login_data');
        }
        else
        {
            redirect('user/sighIn');
        }

    }

    public function add_appointment($id = null)
    {
       
        $this->load->model('user_model');
        $this->load->model('appointment_model');
        $this->load->model('office_model');
        $this->load->model('insurance_model');
        $this->load->model('appointment_note_model');
        $this->load->model('contractor_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        //print_r($data);
        $data['agent'] = $this->user_model->dropdown_agent();
        $data['contractor'] = $this->user_model->dropdown_contractor();
        $data['allusers'] = $this->user_model->dropdown_allusers();
        $data['office'] = $this->office_model->dropdown_active();
        $data['insurance'] = $this->insurance_model->dropdown_active();
        $data['ladder'] = array(''=>'--Select--',1=>'yes',2=>'no');
        $data['insured'] = array(''=>'--Select--',1=>'yes',2=>'no');
        $data['rooftype'] = array(''=>'--Select--',1=>'Asphalt',2=>'Shake',3=>'Tile',4=>'Metal',5=>'Flat');
        $data['reason'] = array(''=>'--Select--',1=>'No Home Owner Present',2=>'No Show',3=>'Outside Target Area',4=>'Roof Age',5=>'See Notes',6=>'Trailer/Rental/Town home');
        $data['appointment'] = null;
        $data['note'] = null;
        
        $this->load->model('ApptStatus_model');
        $data['statusall'] = $this->ApptStatus_model->dropdown_status();
        
       // $data['statusall'] = array(''=>'--Select--','New'=>'New','Rejected'=>'Rejected','Assignment Pending'=>'Assignment Pending','Assigned'=> 'Assigned','Completed'=>'Completed', 'Call Back Needed'=> 'Call Back Needed', 'Pending Date'=> 'Pending Date', 'Credit Request'=>'Credit Request', 'Credit Denied'=>'Credit Denied', 'Credit Issued'=>'Credit Issued','Charged'=>'Charged','Orphan'=>'Orphan', 'Duplicate'=>'Duplicate','Contingency'=>'Contingency');
        $data['statusagentnew'] = array(''=>'--Select--','New'=>'New','Assignment Pending'=>'Assignment Pending');
        $data['statusagentqcok'] = array(''=>'--Select--','Assignment Pending'=>'Assignment Pending','Call Back Needed'=> 'Call Back Needed'); 
        $data['statusRejected'] = array(''=>'--Select--','Rejected'=>'Rejected','Assignment Pending'=>'Assignment Pending'); 
        $data['BillingStatus'] = array(''=>'--Select--','Charged'=>'Charged','Declined'=>'Declined'); 
       

        //print_r($data);
        if ($id) {
            $data['appointment'] = $this->appointment_model->where(array('AppointmentID' => $id))->get();
           // $data['appointment_notes'] = $this->appointment_note_model->where(array('Stat' => 1,'AppointmentID' => $id))->get_all();
           $data['appointment_notes'] = $this->appointment_note_model->appt_notes($id);
            //print_r($data);
        }
        $this->load->view('appointment/add_appointment', $data);
    }

    public function save_appointment()
    {
        $message = 2;
        $id = $this->input->post('AppointmentID');
        $nid = $this->input->post('NoteID');
        $this->load->library('form_validation');
        //print_r($this->input->post());
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_appointment'));
        $newdate = strtotime($data['When']);
        $data['When'] = date('Y-m-d H:i:s', $newdate);
        $this->form_validation->set_data($data);
        //print_r($data);
        if ($this->form_validation->run('save_appointment') != false) 
        $message = 1; 
        {
            $this->load->model('appointment_model');
            $this->load->model('appointment_note_model');
            if ($id) 
            {
                $this->appointment_model->update($data, $id);
                $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_appointment_note'));
                $this->form_validation->set_data($data);
                if ($this->form_validation->run('save_appointment_note') != false) 
                {
                    $this->load->model('appointment_note_model');
                    if(strlen($data['Note']) > 0)
                        $this->appointment_note_model->insert($data);  
                }  
                $message = 1;       
            } 
            else 
            {
                $aid = $this->appointment_model->insert($data);
                $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_appointment_note'));
                //print_r($data);
                if(strlen($data['Note']) > 0)
                {
                   $ndata = array(
                       'Note' =>$data['Note'], 'AppointmentID'=>$aid
                   );
                 $this->appointment_note_model->insert($ndata);                     
                $message = 1;
                }
            }    
        }
        //print_r($data);
        $this->load->model('user_model');
        $data['session_data'] = $this->user_model->getLoginSession();
        $thetype = $data['session_data'];
        if( $thetype['utype'] == 1) redirect('appointment/appointment_report/' . $message);
        else if( $thetype['utype'] == 4) redirect('agent/index/'. $message);
    }

    public function appointment_report($msg = null)
    {
        if ($msg)
            $data['msg'] = $msg;
        $this->load->model('user_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $this->load->view('appointment/appointment_report', $data);
    }

    public function appointment_adlist($msg = null)
    {
        if ($msg)
            $data['msg'] = $msg;
        $this->load->model('user_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $this->load->view('appointment/appointment_adlist', $data);
    }

    public function appt_details($id = null)
    {
        $this->load->model('user_model');
        $this->load->model('appointment_model');
        $this->load->model('office_model');
        $this->load->model('insurance_model');
        $this->load->model('appointment_note_model');
        $this->load->model('contractor_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        //print_r($data);
        //$data['agent'] = $this->user_model->dropdown_agent();
        
        $appointment= $this->appointment_model->single_appointment($id);
        $data['appointment'] = $appointment;
        $data['appointment_notes'] = $this->appointment_note_model->where(array('Stat' => 1,'AppointmentID' => $id, 'Internal' => 0))->get_all();
        $data['Status'] = array(''=>'--Select--','Assigned'=>'Assigned','Completed'=>'Completed','Credit Request'=>'Credit Request'); 
        $data['Reason'] = array(''=>'--Select--',1=>'No Home Owner Present',2=>'No Show',3=>'Outside Target Area',4=>'Roof Age',5=>'See Notes',6=>'Trailer/Rental/Town home');
        $this->load->view('appointment/appt_details', $data);
        
    }

    public function save_contractor_appointment()
    {
        $message = 2;
        //print_r($this->input->post());
        $id = $this->input->post('AppointmentID');
        $this->load->library('form_validation');
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_contractor_appointment'));
        $this->form_validation->set_data($data);
        if ($this->form_validation->run('save_contractor_appointment') != false) {
            $this->load->model('appointment_model');
            $this->load->model('appointment_note_model');
            if ($id) {
                $this->appointment_model->update($data, $id);
                $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_appointment_note'));
                //print_r($data);
                $this->form_validation->set_data($data);
                if ($this->form_validation->run('save_appointment_note') != false) {
                    $this->load->model('appointment_note_model');
                    if(strlen($data['Note']) > 0)
                        $this->appointment_note_model->insert($data);       
                }
                    $message = 1;
            }
        }
       redirect('contractor/index/' . $message);
    }
    public function testappt($id=null)
    {
        $this->load->model('user_model');
        $this->load->model('appointment_model');
        $this->load->model('office_model');
        $this->load->model('insurance_model');
        $this->load->model('appointment_note_model');
        $this->load->model('contractor_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        //print_r($data);
        $data['agent'] = $this->user_model->dropdown_agent();
        $data['contractor'] = $this->user_model->dropdown_contractor();
        $data['allusers'] = $this->user_model->dropdown_allusers();
        $data['office'] = $this->office_model->dropdown_active();
        $data['insurance'] = $this->insurance_model->dropdown_active();
        $data['ladder'] = array(''=>'--Select--',1=>'yes',2=>'no');
        $data['insured'] = array(''=>'--Select--',1=>'yes',2=>'no');
        $data['rooftype'] = array(''=>'--Select--',1=>'Asphalt',2=>'Shake',3=>'Tile',4=>'Metal',5=>'Flat');
        $data['reason'] = array(''=>'--Select--',1=>'No Home Owner Present',2=>'No Show',3=>'Outside Target Area',4=>'Roof Age',5=>'See Notes',6=>'Trailer/Rental/Town home');
        $data['appointment'] = null;
        $data['note'] = null;
        $data['statusall'] = array(''=>'--Select--','New'=>'New','Rejected'=>'Rejected','Assignment Pending'=>'Assignment Pending','Assigned'=> 'Assigned','Completed'=>'Completed', 'Call Back Needed'=> 'Call Back Needed', 'Credit Request'=>'Credit Request', 'Credit Denied'=>'Credit Denied', 'Credit Issued'=>'Credit Issued','Charged'=>'Charged','Orphan'=>'Orphan', 'Duplicate'=>'Duplicate','Contingency'=>'Contingency');
        $data['statusagentnew'] = array(''=>'--Select--','New'=>'New','Assignment Pending'=>'Assignment Pending');
        $data['statusagentqcok'] = array(''=>'--Select--','Assignment Pending'=>'Assignment Pending'); 
        $data['statusRejected'] = array(''=>'--Select--','Rejected'=>'Rejected','Assignment Pending'=>'Assignment Pending');   

        //print_r($data);
        if ($id) {
            $data['appointment'] = $this->appointment_model->where(array('AppointmentID' => $id))->get();
            $data['appointment_notes'] = $this->appointment_note_model->where(array('Stat' => 1,'AppointmentID' => $id))->get_all();
        }
        $this->load->view('appointment/testappt', $data);
    }
    
    public function billable_appointments()
    {
       
        $this->load->model('user_model');
        $this->load->model('contractor_model');
        $data['session_data'] = $this->user_model->getLoginSession();
        $data['contractorArray'] = $this->user_model->dropdown_contractor();

        $this->load->view('appointment/billable_appointments', $data);
    }
}
?>