<?php
$mainmenu = $this->mainmenu->buildMenu($session_data['utype'], 6);
$prof_inf = $this->messages->getUserInf($session_data['id']);
$data['title'] = "Billable Appointments";
$data['mainmenu'] = $mainmenu;
$data['profinf'] = $prof_inf;
$data['userinf'] = $session_data;
if (isset($msg)) {
    $data['msg'] = $this->messages->getMessage($msg);
}
$this->load->view('layout/header2', $data);
?>

<!-- page content -->
<div class="content-wrapper" role="main">
    <div class="">
        <section class="content-header">
            <h1>
                Billable Appointments
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Billable Appointments</a></li>
            </ol>
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-body">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>  Contractors   </label>
                                    <div class="input-group ">
                                        <?php
                                        echo form_dropdown('contractor', $contractorArray,'','class="form-control col-md-7 col-xs-12" id="contractor"');
                                        ?>
                                    </div>
                                </div>
                            </div>
                         <?php echo form_open(); ?>
                            <div class="col-md-12 table-responsive">
                                
                                <table id="example4" class="table table-bordered table-striped dataTable" width="100%">
                                    <thead>
                                    <tr>    
                                        <th>Select</th>
                                         <th>AppointmentID</th>
                                         <th>Activity</th>
                                         <th>LastName</th>
                                         <th>Address</th>
                                         <th>City</th>
                                         <th>State</th>
                                         <th>Zip</th>
                                         <th>When</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                                
                                
                                
                            </div>
                              <div class="col-md-12 text-right" id="paynowdiv" style="display: none;">
                                  <button type="submit" class="btn btn-success" value="Pay">Pay</button>
                              </div>
                              <?php echo form_close(); ?>
                            <!-- /.box-body -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<!-- /page content -->
<!--Inner Container End -->
<?php
$this->load->view('layout/footer2');
?>
<!-- footer content -->
<script>


    $("#contractor").change(function () {
        var contractorId = $(this).val();
             $('#paynowdiv').hide();
             $('#example4').DataTable().destroy();
          
             var tableApp =  $('#example4').DataTable({
                "ajax": "<?php echo base_url(); ?>index.php/api/appointment_api/billable_appointments/" + contractorId,  
              
                "columnDefs": [
                    {"width": "1%", "targets": 0}
                ],
                columns: [
                    {
                        data:   "AppointmentID",
                        render: function ( data, type, row ) {
                            if ( type === 'display' ) {
                                return '<input type="checkbox" name="appointments[]" value="'+data+'" class="appointments-ids">';
                            }
                            return data;
                        },
                        className: "dt-body-center"
                    },
                    { data: 'AppointmentID' },
                    { data: 'activity' },
                    { data: 'LastName' },
                    { data: 'Address' },
                    { data: 'City' },
                    { data: 'State' },
                    { data: 'Zip' },
                    { data: 'When' },
                ],
                dom: 'Bfrtip',
                "paging": false,
                "order": [[0, "asc"]],
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });    
           
    });
    $('body').on('change', '.appointments-ids', function() {
          if($('.appointments-ids:checked').length){
              $('#paynowdiv').show();
          }else{
              $('#paynowdiv').hide();
          }
         
      });


</script>
