<style type="text/css">
    #file-upload {
        position: absolute;
        left: -9999px;
    }
    label[for="file-upload"]{
      padding:1em;  
      display:inline-block;
      background:#1992d2;
      color: #fff;
      cursor:pointer;
      &:hover{color:#fff}
    }
    .btn-upload{
        padding:1em;  
        display:inline-block;
        background:#074c71;
        color: #fff;
        cursor:pointer;
        margin-left: -5px;
        border: 0;
    }
    #filename{
      padding:1em;
      float:left;
      width:380px;
      white-space: nowrap;
      overflow:hidden;
      color: #353535;
      background:#efefef;
    }
</style>
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-body with-border">
                <div class="col-md-6">
                    <h4><i class="fa fa-plus"></i> &nbsp; Add New Admin</h4>
                </div>
                <div class="col-md-6 text-right">
                    <a href="<?= base_url('index.php/admin/admin'); ?>" class="btn btn-success"><i class="fa fa-list"></i> Admin List</a>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                </div>
                <!-- /.box-header -->
                <!-- form start -->
                <div class="box-body my-form-body">
                    
                    <?php if(isset($msg) || validation_errors() !== '' || $uploadEmpty === true ): ?>
                        <div class="alert alert-warning alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h4><i class="icon fa fa-warning"></i> Alert!</h4>
                            <?= validation_errors();?>
                            <?= isset($msg)? $msg: ''; ?>
                            <?php echo ($uploadEmpty === true) ? "Profile Picture is empty" : "" ; ?>
                        </div>
                    <?php endif; ?>

                    <?php 
                        if(!empty($error)):
                            echo '<span class="alert alert-danger" style="display: block;">';
                                foreach ($error as $item => $value):
                                    echo $item." : ".$value;
                                endforeach;
                            echo '</span>';
                        endif;
                    ?>
           
                    <?php echo form_open_multipart(base_url('index.php/admin/admin/add'), 'class="form-horizontal"');  ?> 
                        <div class="form-group">
                            <label for="userpic" class="col-sm-2 control-label">Upload file</label>
                            <div class="col-sm-9">
                                <span id="filename">Select your Picture</span>
                                <label for="file-upload">Browse<input type="file" name="userpic" id="file-upload"></label>
                                <p><small class="text-success">Allowed Types: jpg, png</small></p>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="username" class="col-sm-2 control-label">User Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="username" class="form-control" id="username" value="<?php echo set_value('username'); ?>" />
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="firstname" class="col-sm-2 control-label">First Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="firstname" class="form-control" id="firstname" value="<?php echo set_value('firstname'); ?>" />
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="lastname" class="col-sm-2 control-label">Last Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="lastname" class="form-control" id="lastname" value="<?php echo set_value('lastname'); ?>" />
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="email" class="col-sm-2 control-label">Email</label>
                            <div class="col-sm-9">
                                <input type="email" name="email" class="form-control" id="email" value="<?php echo set_value('email'); ?>" />
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="mobile_no" class="col-sm-2 control-label">Mobile No</label>
                            <div class="col-sm-9">
                                <input type="number" name="mobile_no" class="form-control" id="mobile_no" value="<?php echo set_value('mobile_no'); ?>" />
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="password" class="col-sm-2 control-label">Password</label>
                            <div class="col-sm-9">
                                <input type="password" name="password" class="form-control" id="password" value="<?php echo set_value('password'); ?>" />
                            </div>
                        </div>
        
                        <div class="form-group">
                            <?php
                                $fv_role = set_value('role');
                            ?>
                            <label for="role" class="col-sm-2 control-label">Select Admin Role*</label>
                            <div class="col-sm-9">
                                <select name="role" class="form-control">
                                    <option value="">Select Role</option>
                                    <?php
                                        foreach($admin_roles as $role){
                                            if( $fv_role == $role['admin_role_id'] ){
                                                echo '<option value="'.$role['admin_role_id'].'" selected="selected">'.$role['admin_role_title'].'</option>';
                                            }
                                            else{
                                                echo '<option value="'.$role['admin_role_id'].'">'.$role['admin_role_title'].'</option>';    
                                            }
                                        }
                                    ?>
                                        
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-md-11">
                                <input type="submit" name="submit" value="Add New Admin" class="btn btn-info pull-right">
                            </div>
                        </div>
                    <?php echo form_close(); ?>
                </div>
                <!-- /.box-body -->
            </div>
        </div>
    </div>  
</section>
<script>
    $(document).ready(function(){
        $('#file-upload').change(function() {
            var filepath = this.value;
            var m = filepath.match(/([^\/\\]+)$/);
            var filename = m[1];
            $('#filename').html(filename);
        });
    });
</script>