<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Rent_model extends CI_Model{

	public function get_user_detail(){
		$id = $this->session->userdata('admin_id');
		$query = $this->db->get_where('ci_admin', array('admin_id' => $id));
		return $result = $query->row_array();
	}
	//--------------------------------------------------------------------
	public function update_user($data){
		$id = $this->session->userdata('admin_id');
		$this->db->where('admin_id', $id);
		$this->db->update('ci_admin', $data);
		return true;
	}
	//--------------------------------------------------------------------
	public function change_pwd($data, $id){
		$this->db->where('admin_id', $id);
		$this->db->update('ci_admin', $data);
		return true;
	}
	//-----------------------------------------------------
	function get_admin_roles()
	{
		$this->db->from('ci_admin_roles');
		$this->db->where('admin_role_status',1);
		$query=$this->db->get();
		return $query->result_array();
	}

	//-----------------------------------------------------
	function get_rent_by_id($id,$fny)
	{
		$tbl = "rent_demand_register_details_".$fny;
		$this->db->from($tbl);
		//$this->db->join('ci_admin_roles','ci_admin_roles.admin_role_id=ci_admin.admin_role_id');
		$this->db->where('rent_demand_registerid',$id);
		$query=$this->db->get();
		return $query->row_array();
	}
	function get_rent_last_id()
	{
	 $this->db->select('*');
     $this->db->from('rent_demand_register_details');
     $this->db->order_by('rent_demand_registerid', 'DESC'); // 'created_at' is the column name of the date on which the record has stored in the database.
	 $lastid = $this->db->get()->result_array();
	 //echo '<pre>';
	 //print_r($lastid[0]['rent_demand_registerid']);
	 $prlastid = isset($lastid[0]['rent_demand_registerid']) ? $lastid[0]['rent_demand_registerid']+1 : 1;
	 $proautoid = str_pad($prlastid,4,"0",STR_PAD_LEFT);
     return $proautoid;
	}
	//-----------------------------------------------------
	function get_all()
	{
		$this->db->select('a.*');
		$this->db->select('ward.ward_no');
		$this->db->select('ward.ward_name');
		$this->db->select('mohalla.name as m_name');
		$this->db->select('property_type.type as property');
		$this->db->from('rent_demand_register_details as a');
		$this->db->join('ward','ward.id = a.ward','left');
		$this->db->join('mohalla','mohalla.id = a.village_address','left');
		$this->db->join('property_type','property_type.id = a.property_type','left');

		$where = "";
		$limit =10;
		$offset =0;
		//$this->db->join('ci_admin_roles','ci_admin_roles.admin_role_id=ci_admin.admin_role_id');
		
		/*if($this->session->userdata('filter_type')!='')
			$this->db->where('ci_admin.admin_role_id',$this->session->userdata('filter_type'));

		if($this->session->userdata('filter_status')!='')
			$this->db->where('ci_admin.is_active',$this->session->userdata('filter_status'));

		$filterData = $this->session->userdata('filter_keyword');
		$where = "(
		ci_admin_roles.admin_role_title like '%$filterData%' OR
		ci_admin.firstname like '%$filterData%' OR
		ci_admin.lastname like '%$filterData%' OR
		ci_admin.email like '%$filterData%' OR
		ci_admin.mobile_no like '%$filterData%' OR
		ci_admin.username like '%$filterData%'
		)";*/
		//$this->db->where($where);

		$this->db->order_by('a.property_id_number','desc');
		//$this->db->limit($limit, $offset);
		$query = $this->db->get();
		$module = array();
		if ($query->num_rows() > 0) 
		{
			$module = $query->result_array();
		}
		return $module;
	}
	public function get_all_by_json_search($id){
			
			$table="rent_demand_register_details_".$id;
			$wh =array();
			$SQL ='SELECT ward.ward_no,ward.ward_name,property_type.type as property,mohalla.name as m_name, a.* FROM '.$table.' a LEFT JOIN ward ON a.ward=ward.id LEFT JOIN mohalla ON a.village_address=mohalla.id LEFT JOIN property_type ON a.property_type=property_type.id';
			if($this->session->userdata('property_id_number')!='')
			$wh[]="property_id_number = '".$this->session->userdata('property_id_number')."'";
			if($this->session->userdata('property_number')!='')
			$wh[]=" `property_number` = '".$this->session->userdata('property_number')."'";
			if($this->session->userdata('property_address')!='')
			$wh[]=" `village_address` = '".$this->session->userdata('property_address')."'";
			
			//$wh[] = "a.financial_year = $id";
			//echo $SQL;
			if(count($wh)>0)
			{
				$WHERE = implode(' and ',$wh);
				return $this->datatable->LoadJson($SQL,$WHERE);
			}
			else
			{
				return $this->datatable->LoadJson($SQL);
			}
			
		}

	//-----------------------------------------------------
	public function add_admin($data){
		$this->db->insert('ci_admin', $data);
		return true;
	}

	//---------------------------------------------------
	// Edit Admin Record
	public function edit_admin($data, $id){
		
		$table = 'rent_demand_register_details_'.trim($data['financial_year']);
		
		$this->db->where('rent_demand_registerid', $id);
		$this->db->update($table, $data);
		print_r($this->db->last_query());
		return true;
	}

	//-----------------------------------------------------
	function change_status()
	{		
		$this->db->set('is_active',$this->input->post('status'));
		$this->db->where('admin_id',$this->input->post('id'));
		$this->db->update('ci_admin');
	} 

		//-----------------------------------------------------
	function delete($id)
	{	
		
		$this->db->where('admin_id',$id);
		$this->db->delete('ci_admin');
	}
	function getdata_rentpayment($id,$fny)
	{		
					
			$this->db->select('
						rent_payment_id,
						rent_demand_registerid,
						property_id_number,
						deposit_current_month,
						deposit_outstanding_deposit,
						deposit_gst,
						deposit_late_fee,
						SUM(deposit_total_pay) as total,
							deposit_receipt_number,
							deposit_receipt_date,
							deposit_depositor,
							deposit_comment,
							paid_at,
								SUM(paid_amount) as paidtotal, 
						'
				);			
				$this->db->from('rent_demand_register_payments');
				$this->db->where('rent_demand_registerid',$id);
				$this->db->where('financial_year',$fny);
				$query = $this->db->get();
				//print_r($query->row_array());
				//echo'<pre>';
				//print_r($ab);
				//	die;
				return $query->row_array();
				
	}

	public function get_all_wards()
        {
            $this->db->where("is_active",'1');
            $this->db->order_by("ward_no","ASC");
            $q=$this->db->get("ward");
            if($q->num_rows()>0)
            {
                return $q->result();
            }
        }
	public function get_all_market_lists()
        {
            $this->db->where("is_active",'1');
            $this->db->order_by("id","ASC");
            $q=$this->db->get("market");
            if($q->num_rows()>0)
            {
                return $q->result();
            }
        }
	public function get_ward_no($ward)
        {
			$this->db->where("id",$ward);
            $this->db->where("is_active",'1');
            //$this->db->order_by("ward_no","ASC");
            $q=$this->db->get("ward");
            if($q->num_rows()>0)
            {
                return $q->result();
            }
        }	
	
	public function get_mohalla_no($village)
        {
            $this->db->where('id',$village);
            $this->db->where('is_active','1');
            $this->db->order_by('name',"ASC");
            $q=$this->db->get('mohalla');
            if($q->num_rows()>0)
            {
                return $q->result();
            }
        }
    public function get_all_mohalla($ward)
        {
            $this->db->where('ward_id',$ward);
            $this->db->where('is_active','1');
            $this->db->order_by('name',"ASC");
            $q=$this->db->get('mohalla');
            if($q->num_rows()>0)
            {
                return $q->result();
            }
        }
	public function get_all_market($ward,$village)
        {
            $this->db->where('ward_id',$ward);
			$this->db->where('mohalla_id',$village);
            $this->db->where('is_active','1');
            $this->db->order_by('market_name',"ASC");
            $q=$this->db->get('market');
            if($q->num_rows()>0)
            {
                return $q->result();
            }
        }
	public function get_MarketALL($id)
    {
		$this->db->where('id',$id);
        $this->db->where('is_active','1');
        $this->db->order_by('market_name',"ASC");
        $q=$this->db->get('market');
        if($q->num_rows()>0)
        {
           return $q->result();
        }
    }
    public function get_finnacial_year()
        {
        	 $this->db->where("is_active",'1');
            $this->db->order_by("id","ASC");
            $q=$this->db->get("finnancial_year");
            if($q->num_rows()>0)
            {
                return $q->result();
            }
        } 
	public function get_single_finnacial_year()
        {
        	 $this->db->where("is_active",'1');
            $this->db->order_by("id","ASC");
			$this->db->limit(1, 1);
            $q=$this->db->get("finnancial_year");
            if($q->num_rows()>0)
            {
                return $q->result();
            }
        } 
	public function get_finnacial_year_latest()
        {
        	 $this->db->where("is_active",'1');
            $this->db->order_by("id","DSC");
			$this->db->limit(1, 1);
            $q=$this->db->get("finnancial_year");			
            if($q->num_rows()>0)
            {
                return $q->row_array();
            }
        } 

    public function get_property_type()
        {
        	$this->db->where("is_active",'1');
            $this->db->order_by("id","ASC");
            $q=$this->db->get("property_type");
            if($q->num_rows()>0)
            {
                return $q->result();
            }
        }

    public function count_search($select_box,$type_by,$list_by)
        {

  		if($list_by=='active')
		{


        	$this->db->select('a.*,SUM(b.paid_amount) as total_paid,SUM(b.deposit_total_pay) as total_demand');
			$this->db->select('ward.ward_no');
			$this->db->select('ward.ward_name');
			$this->db->select('mohalla.name as m_name');
			$this->db->select('property_type.type as property');
		 	$this->db->from('rent_demand_register_details as a');
		    $this->db->join('rent_demand_register_payments as b','b.rent_demand_registerid = a.rent_demand_registerid','left');
			$this->db->having('(sum(b.deposit_total_pay)-sum(b.paid_amount)) <= ','0');

			if($type_by=='year')
			{
				$this->db->where('a.financial_year',$select_box);
			}

			elseif($type_by=='amount')
			{
				if($select_box=='50000')
				{
					$this->db->having('sum(b.paid_amount)>',$select_box);
				}
				else
				{
					$slct_box=explode('-',$select_box);

					$slct_box0=$slct_box[0];
					$slct_box1=$slct_box[1];
					// print_r($slct_box1);
					$this->db->having('sum(b.paid_amount)>',$slct_box0);
					$this->db->having('sum(b.paid_amount)<',$slct_box1);
				}
			}
			
			$this->db->join('ward','ward.id = a.ward','left');
			$this->db->join('mohalla','mohalla.id = a.village_address','left');
			$this->db->join('property_type','property_type.id = a.property_type','left');
			$this->db->order_by('a.rent_demand_registerid','desc');
			$this->db->group_by('a.rent_demand_registerid');
			//$this->db->limit($length,$start);
			$q=$this->db->get();            
			return $q->num_rows();
           
        }
    }

        

    public function show_table_search($select_box,$length,$start,$type_by,$list_by)
        {
		//echo $select_box.','.$length.','.$start.','.$type_by.','.$list_by;
        if($list_by == 'active')
		{
        	$this->db->select('a.*,SUM(b.paid_amount) as total_paid,SUM(b.deposit_total_pay) as total_demand');
			$this->db->select('ward.ward_no');
			$this->db->select('ward.ward_name');
			$this->db->select('mohalla.name as m_name');
			$this->db->select('property_type.type as property');
			$this->db->from('rent_demand_register_details as a');
			$this->db->join('rent_demand_register_payments as b','b.rent_demand_registerid = a.rent_demand_registerid','left');
			$this->db->having('(sum(b.deposit_total_pay)-sum(b.paid_amount)) <= ','0');
			if($type_by=='year')
			{
				$this->db->where('a.financial_year',$select_box);
			}
			elseif($type_by=='amount')
			{
				if($select_box=='50000')
				{
					$this->db->having('sum(b.paid_amount)>',$select_box);
				}
				else
				{
					$slct_box=explode('-',$select_box);

					$slct_box0=$slct_box[0];
					$slct_box1=$slct_box[1];
					// print_r($slct_box1);
					$this->db->having('sum(b.paid_amount)>',$slct_box0);
					$this->db->having('sum(b.paid_amount)<',$slct_box1);
				}
			}	
			$this->db->join('ward','ward.id = a.ward','left');
			$this->db->join('mohalla','mohalla.id = a.village_address','left');
			$this->db->join('property_type','property_type.id = a.property_type','left');		
			$this->db->order_by('a.rent_demand_registerid','desc');
			$this->db->group_by('a.rent_demand_registerid');
			$this->db->limit($length,$start);
			$q=$this->db->get();
			$str = $this->db->last_query();
			echo $str;
			die;
            if($q->num_rows()>0)
            {
                return $q->result_array();
            }else{
				return $q->result_array();
			}			
        }
        elseif($list_by=='defaulter')
		{
        	$this->db->select('*');
			// $this->db->select('ward.ward_no');
			// $this->db->select('ward.ward_name');
			// $this->db->select('mohalla.name as m_name');
			// $this->db->select('property_type.type as property');
			$this->db->from('rent_demand_register_details as a');
			//$this->db->join('rent_demand_register_payments as b','b.rent_demand_registerid = a.rent_demand_registerid','left');
			//$this->db->having('(sum(b.deposit_total_pay)-sum(b.paid_amount)) > ','0');
			$this->db->where('a.rent_demand_registerid NOT IN (SELECT `rent_demand_registerid` FROM `rent_demand_register_payments`)');	
			
			// $this->db->join('ward','ward.id = a.ward','left');
			// $this->db->join('mohalla','mohalla.id = a.village_address','left');
			// $this->db->join('property_type','property_type.id = a.property_type','left');
			if($type_by=='year')
			{
				$this->db->where('a.financial_year',$select_box);
			}
			elseif($type_by=='amount')
			{
				$current_month=date('m');

				//print_r($current_month);die;

				//$multiply_month='';

				$delete_date = "2000-01-1";
				$current_date = date('Y-m-d');

				

				if($select_box=='50000')
				{
					
				 /*$date1 = '2020-01-25';
				 $date2 = '2021-01-20';
				 $d1=new DateTime($date2); 
				 $d2=new DateTime($date1);                                  
				 $Months = $d2->diff($d1); 
				 echo $howeverManyMonths = (($Months->y) * 12) + ($Months->m);
				 die;*/
				 // $howeverManyMonths = (($Months->y) * 12) + ($Months->m);
				 // print_r($howeverManyMonths);
				 // die;

					// $this->db->where('(a.demand_total_deposit_money * '.(($current_date->diff(strtotime('a.allotment_date'))->y) * 12) + ($current_date->diff(strtotime('a.allotment_date'))->m).' >',$select_box);
					//$this->db->where('(a.demand_total_deposit_money * ('.date_diff($current_date,strtotime('a.allotment_date'))->format("%m").' ) ) >',$select_box);
					// $this->db->where('(a.demand_total_deposit_money * ('.($current_date - strtotime('a.allotment_date')) .'/ (60 * 60 * 24 * 365 / 12)) ) >',$select_box);
					 // $this->db->where('(a.demand_total_deposit_money * ('.floor(floatval(strtotime($current_date) - strtotime('a.allotment_date')) / (60 * 60 * 24 * 365 / 12)).') ) >',$select_box);
					//$this->db->where('(a.demand_total_deposit_money * ('.(abs(('2018-01-10')-('2019-05-18'))).'/60/60/24/30)) >',$select_box);
					// $this->db->where("(a.demand_total_deposit_money * (DATEDIFF('2021-04-22' , '".date("Y-m-d")."') )/ (60 * 60 * 24 * 365 / 12) ) >",$select_box, NULL, FALSE);

					//$this->db->where('(a.demand_total_deposit_money * ('.((('a.allotment_date'->diff($current_date))->y) * 12) + (('a.allotment_date'->diff($current_date))->m).') ) >',$select_box);
					$this->db->where('(a.demand_total_deposit_money * ( 12 * (YEAR(NOW()) - YEAR(`created_at`)) + ( MONTH(NOW())- MONTH(`created_at`))) ) >',$select_box);					

				// 	$months = floor(floatval($current_date - strtotime($delete_date)) / (60 * 60 * 24 * 365 / 12));

				// print_r($months);
				// die;
				}
				else
				{
					$slct_box=explode('-',$select_box);

					$slct_box0=$slct_box[0];
					$slct_box1=$slct_box[1];
					// print_r($slct_box1);
					$this->db->where('(a.demand_total_deposit_money * ('.$current_month.' - a.month_name) ) >',$slct_box0);
					$this->db->where('(a.demand_total_deposit_money * ('.$current_month.' - a.month_name) ) <',$slct_box1);
				}
			}	
	
			$this->db->order_by('a.rent_demand_registerid','desc');
			$this->db->group_by('a.rent_demand_registerid');
			$this->db->limit($length,$start);
			$q=$this->db->get();
			//print_r($this->db->last_query());
			//die;
            if($q->num_rows()>0)
            {
                return $q->result_array();
            }
			else
			{
				return $q->result_array();
			}
        }
    }

}

?>