<?php
    defined('BASEPATH') OR exit('No direct script access allowed');

    class Payment_model extends CI_Model{
        
        public function __construct(){
            parent::__construct();
			$this->load->model('admin/rent_model', 'rent');
        }

        public function payment_gateway_get_all(){
            $wh = array();
            $SQL ='SELECT g.*,c.name FROM `tbl_pgateway` g 
            LEFT JOIN tbl_client c ON c.client_id = g.client_pid';
            //$wh[] = "";
            if(count($wh)>0){
                $WHERE = implode(' and ',$wh);
                return $this->datatable->LoadJson($SQL,$WHERE);
            }
            else{
                return $this->datatable->LoadJson($SQL);
            }
        }
		public function search_property($prop_id){
            $data_arr = array();
            //$rs = $this->db->get_where('tbl_product_segment', array('segment_pid' => $seg_id, 'product_pid' => $prod_id ));
            $this->db->select('*');
            $this->db->from('rent_demand_register_details');
			 $this->db->where( array('rent_demand_registerid' => $prop_id ) );
            
            //$this->db->where( array('rent_demand_registerid' => $pro_id, 'product_pid' => $prod_id ) );
            $rs = $this->db->get();
            foreach( $rs->result_array() as $row ){
                $data_arr[] = $row;
            }

            return $data_arr;
        }
		// get all rent_demand_register_details for server-side datatable with advanced search
		public function get_all_users_by_advance_search($id){
			$wh = array();
			$table='rent_demand_register_details_'.$id;
			$SQL ='SELECT a.market,a.father_name,ward.ward_no,ward.ward_name,mohalla.name as m_name, a.* FROM '.$table.' a LEFT JOIN ward ON a.ward=ward.id LEFT JOIN mohalla ON a.village_address=mohalla.id';
			//$SQL ='SELECT * FROM '.$table;			
			if($this->session->userdata('property_id_number')!='')
			$wh[]="property_id_number like '%".$this->session->userdata('property_id_number')."%'";
			if($this->session->userdata('property_number')!='')
			$wh[]=" `property_number` = '".$this->session->userdata('property_number')."'";
			if($this->session->userdata('market')!='')
			$wh[]=" `market` = '".$this->session->userdata('market')."'";
			if($this->session->userdata('father_name')!='')
			$wh[]=" `father_name` like '%".$this->session->userdata('father_name')."%'";
			
			//$wh[] = " is_admin = 0";
			//print_r($this->session->userdata);
			if(count($wh)>0)
			{
				$WHERE = implode(' and ',$wh);
				
				return $this->datatable->LoadJson($SQL,$WHERE);
			}
			else
			{
				return $this->datatable->LoadJson($SQL);
			}
		}
		public function get_all_bill_by_search($id){
			$wh = array();
			$table ='rent_demand_register_details_'.$id; 
			$SQL ='SELECT a.market,a.father_name,ward.ward_no,ward.ward_name,mohalla.name as m_name, a.* FROM '.$table.' a LEFT JOIN ward ON a.ward=ward.id LEFT JOIN mohalla ON a.village_address=mohalla.id';
			//$SQL ='SELECT * FROM '.$table;			
			if($this->session->userdata('propbill_id_number')!='')
			$wh[]=" `property_id_number` like '%".$this->session->userdata('propbill_id_number')."%'";
			if($this->session->userdata('property_number')!='')
			$wh[]=" `property_number` = '".$this->session->userdata('property_number')."'";
			if($this->session->userdata('market')!='')
			$wh[]=" `market` = '".$this->session->userdata('market')."'";
			if($this->session->userdata('father_name')!='')
			$wh[]=" `father_name` like '%".$this->session->userdata('father_name')."%'";
			//print_r($wh);
			//$wh[] = " is_admin = 0";
			//echo count($wh);
			if(count($wh)>0)
			{
				$WHERE = implode(' and ',$wh);
				return $this->datatable->LoadJson($SQL,$WHERE);
			}
			else
			{
				//$SQL ='SELECT * FROM rent_demand_register_details where property_id_number="0"';
				return $this->datatable->LoadJson($SQL);
			}
		}
		
		public function get_bill_data_model($id,$fy)
		{
			$this->db->select('
	    			rent_payment_id,
					rent_demand_registerid,
					financial_year,
					property_id_number,
					deposit_current_month,
	    			deposit_outstanding_deposit,
					deposit_gst,
					deposit_late_fee,
					deposit_total_pay,
					 	deposit_receipt_number,
						deposit_receipt_date,
						deposit_depositor,
						deposit_comment,
						paid_at,
						paid_amount');			
	    	$this->db->from('rent_demand_register_payments');			
	    	$this->db->where('property_id_number',$id);
			$this->db->where('financial_year',$fy);
			$this->db->order_by('rent_payment_id','DESC');
			
	    	$query = $this->db->get();
			//print_r($this->db->last_query());
			return $query->result_array();
			
		}
		public function get_bill_data_model_last($id,$fy)
		{
			$this->db->select('*');			
	    	$this->db->from('rent_demand_register_payments');			
	    	$this->db->where('property_id_number',$id);
			$this->db->where('financial_year',$fy);
			$this->db->order_by('rent_payment_id','DESC');
			
	    	$query = $this->db->get();
			//print_r($this->db->last_query());
			return $query->row_array();
			
		}	
		
		public function get_bill_data_model_by_register($id)
		{
			return $this->db->select('*')
							->from('rent_demand_register_details')
							->where(['property_id_number'=>$id])
							->get()
							->row_array();
		}
		public function get_bill_data_model_by_register_year($id,$fy)
		{
			$table = 'rent_demand_register_details_'.$fy;
			return $this->db->select('*')
							->from($table)
							->where(['property_id_number'=>$id])
							->get()
							->row_array();
		}
		
		public function get_receipt_by_id($id)
		{
			return $this->db->select('*')
							->from('rent_demand_register_payments')
							->where(['rent_payment_id'=>$id])
							->get()
							->row_array();
		}
		public function get_all_pay_by_id($id)
		{
			return $this->db->select('*')
							->from('rent_demand_register_payments')
							->where(['property_id_number'=>$id])
							->get()
							->result_array();
		}
		public function get_pay_address_by_id($id,$fy=3)
		{
			$table ="rent_demand_register_details_".$fy;
			return $this->db->select($table.'.*,market.market_name,ward.ward_name,finnancial_year.year,mohalla.name as m_name,property_type.type as property')
							->from($table)
							->join('market','market.ward_id = '.$table.'.ward','left')
							->join('ward','ward.id = '.$table.'.ward','left')
							->join('mohalla','mohalla.id = '.$table.'.village_address','left')
							->join('property_type','property_type.id = '.$table.'.property_type','left')
           					->join('finnancial_year','finnancial_year.id = '.$table.'.financial_year','left')
							->where(['rent_demand_registerid'=>$id])
							->get()
							->result_array();

							// $this->db->select('rent_demand_register_details.*,ward.ward_name,finnancial_year.year');
       //      $this->db->from('rent_demand_register_details');
       //      $this->db->join('ward','ward.id = rent_demand_register_details.ward','left');
       //      $this->db->join('finnancial_year','finnancial_year.id = rent_demand_register_details.financial_year','left');
		}
		
		public function payment_gateway_get_clients(){
			$query = $this->db->order_by('name', 'ASC')->get_where('tbl_client', array('is_active' => '1'));
            return $query->result();
        }
        
        public function get_payment_gateway_by_id( $id ){
            $query = $this->db->get_where('tbl_pgateway', array('pg_id' => $id));
            return $result = $query->row_array();
        }

        public function payment_gateway_delete($id = 0){
            $this->db->delete('tbl_pgateway', array('pg_id' => $id));
            return true;
        }

        public function payment_gateway_status($id, $status){
            $this->db->set('is_active', $status);
            $this->db->where('pg_id', $id);
            $this->db->update('tbl_pgateway');
            return $this->db->affected_rows();
        }
		
		public function payment_gateway_sandbox($id, $sandbox){
            $this->db->set('sandbox_on', $sandbox);
            $this->db->where('pg_id', $id);
            $this->db->update('tbl_pgateway');
            return $this->db->affected_rows();
        }

        public function payment_gateway_add($data){
            $this->db->insert('tbl_pgateway', $data);
            return true;
        }
        
        public function payment_gateway_edit($data, $id){
            $this->db->where('pg_id', $id);
            $this->db->update('tbl_pgateway', $data);
            return true;
        }
		public function get_recieptbill_data_model($id)
		{
			return $this->db->select('*')
							->from('rent_demand_register_details')
							->where(['rent_demand_registerid'=>$id])
							->get()
							->row_array();
		}
		public function get_viewbill_data_model($id)
		{
			 $data_arr = array();
            //$rs = $this->db->get_where('tbl_product_segment', array('segment_pid' => $seg_id, 'product_pid' => $prod_id ));
             $this->db->select('*');
             $this->db->from('rent_demand_register_payments');
			 $this->db->where( array('property_id_number' => $id ) );
            
            //$this->db->where( array('rent_demand_registerid' => $pro_id, 'product_pid' => $prod_id ) );
            $rs = $this->db->get();
			$i=1;
			$data_arr['showtb']='';
            foreach( $rs->result_array() as $row ){
                $data_arr[] = $row;				
				$data_arr['showtb'] .='<tr><td>'.$i.'</td><td>'.$row["property_id_number"].'</td><td>'.$row["paid_amount"].'</td><td>'.$row["deposit_current_month"].'</td><td><button type="submit" class="btn btn-info view_detail"><a href="view_bill_invoice?invoice_id='.$row['rent_payment_id'].'" style="color: #fff;">View Invoice</a></button></td></tr>';
            $i++;
			}
			//print_r($data_arr['showtb']);
			//die;
            return $data_arr;
			
		}
		public function get_view_invoice_by_id($id)
		{
			return $this->db->select('*')
							->from('rent_demand_register_payments')
							->where(['rent_payment_id'=>$id])
							->get()
							->row_array();
		}

		public function get_receipt_posting_details($id,$fy)
		{
			$table ="rent_demand_register_details_".$fy;
			$this->db->select($table.'.*,market.market_name,ward.ward_name,finnancial_year.year,mohalla.name as m_name,property_type.type as property');
			$this->db->from($table);
			$this->db->join('market','market.ward_id = '.$table.'.ward','left');
			$this->db->join('ward','ward.id = '.$table.'.ward','left');
			$this->db->join('mohalla','mohalla.id = '.$table.'.village_address','left');
			$this->db->join('property_type','property_type.id = '.$table.'.property_type','left');
           	$this->db->join('finnancial_year','finnancial_year.id = '.$table.'.financial_year','left');
			$this->db->where(['rent_demand_registerid'=>$id]);
			$q = $this->db->get();
			//print_r($this->db->last_query());				
			/*$this->db->select('rent_demand_register_details_'.$fy.'.*,ward.ward_no,ward.ward_name,ward.id as ward_id,property_type.type as property,finnancial_year.year');
			$this->db->from('rent_demand_register_details_'.$fy);
			->join('market','market.ward_id = '.$table.'.ward','left')
			$this->db->join('ward','ward.id = rent_demand_register_details_'.$fy.'.ward','left');
			$this->db->join('property_type','property_type.id = rent_demand_register_details_'.$fy.'.property_type','left');
			$this->db->join('finnancial_year','finnancial_year.id = rent_demand_register_details_'.$fy.'.financial_year','left');
			$this->db->where('rent_demand_registerid',$id);
			$q=$this->db->get();*/

			if($q->num_rows()>0)
			{
				return $q->row_array();
			}
		}

		public function get_finnacial_year()
		{
			$this->db->order_by('id','desc');
			$this->db->where('is_active',1);
			$q=$this->db->get('finnancial_year');

			return $q->result();

		}
		public function get_finnacial_year_by_id($id)
		{
			
			$this->db->where('is_active',1);
			$this->db->where('id',$id);
			$q=$this->db->get('finnancial_year');
			return $q->row_array();

		}
		public function get_wardname_by_id($id)
		{
			$this->db->where('is_active',1);
			$this->db->where('id',$id);
			$q=$this->db->get('ward');

			return $q->row_array();

		}
		public function get_marketname_by_id($id)
		{
			$this->db->where('is_active',1);
			$this->db->where('id',$id);
			$q=$this->db->get('market');

			return $q->row_array();

		}
		public function get_mohalla_village_name($village)
        {
            $this->db->where('id',$village);
            $this->db->where('is_active','1');
            $this->db->order_by('name',"ASC");
            $q=$this->db->get('mohalla');
            if($q->num_rows()>0)
            {
                return $q->row_array();
            }
        }
		public function get_total_records()
		{
			$q=$this->db->get('rent_demand_register_payments');

			return $q->num_rows();
		}

		public function check_receiptno1($receiptno1)
		{
			$this->db->where('deposit_receipt_number',$receiptno1);
			$q=$this->db->get('rent_demand_register_payments');

			if($q->num_rows()>0)
			{
				return true;
			}
		}
		

    }
?>