<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Rent_model extends MY_Model {

    public function __construct() {
        $this->table = 'rents';
        $this->primary_key = 'rent_id';
        $this->return_as = "array";
        parent::__construct();
    }

    protected $before_create = array('created');

    public function created($data) {
        $this->load->model('user_model');
        $user = $this->user_model->getLoginSession();
        //$time = time();
        //$data['TIME'] = date("Y-m-d",$time);
        $data['UserID'] = $user['id'];
        return $data;
    }

    public function fromto($datefrom=null,$dateto=null) {
        if ($dateto != null) $dateto = date('Y-m-d H:i:s', strtotime($dateto . ' +1 day'));      
        $this->db->select('*');
        $this->db->where('Created_at BETWEEN CAST( "'.$datefrom.'" AS DATE) AND CAST( "'.$dateto.'" AS DATE)');
        $q = $this->db->get('appointments');
        $q = $q->result_array();
        return $q;
    }

    public function total_wtd($user){
        $date_start = strtotime('last Sunday');
        $week_start = date('Y-m-d', $date_start);
        $date_end = strtotime('next Sunday');
        $week_end = date('Y-m-d', $date_end);
        $this->db->select('AppointmentID');
        $this->db->where('o.OfficeID =', $user);
        $this->db->where('a.When >=', $week_start);
        $this->db->where('a.When <=', $week_end);
        $this->db->where('a.OfficeID = o.OfficeID');
        $q = $this->db->get('appointments a , contractors o');
        $q = $q->num_rows();
        return $q;
    }

    public function total_wtd_credit($user){
        $date_start = strtotime('last Sunday');
        $week_start = date('Y-m-d', $date_start);
        $date_end = strtotime('next Sunday');
        $week_end = date('Y-m-d', $date_end);
        $this->db->select('AppointmentID');
        $this->db->where('o.OfficeID =', $user);
        $this->db->where('a.When >=', $week_start);
        $this->db->where('a.When <=', $week_end);
        $this->db->where('a.OfficeID = o.OfficeID');
        $this->db->where('a.Status = "Credit Issued"');
        $q = $this->db->get('appointments a , contractors o');
        $q = $q->num_rows();
        return $q;
    }

    public function total_wtd_review($user){
        $date_start = strtotime('last Sunday');
        $week_start = date('Y-m-d', $date_start);
        $date_end = strtotime('next Sunday');
        $week_end = date('Y-m-d', $date_end);
        $this->db->select('AppointmentID');
        $this->db->where('o.OfficeID =', $user);
        $this->db->where('a.When >=', $week_start);
        $this->db->where('a.When <=', $week_end);
        $this->db->where('a.OfficeID = o.OfficeID');
        $this->db->where('a.Status = "Credit Requested"');
        $q = $this->db->get('appointments a , contractors o');
        $q = $q->num_rows();
        return $q;
    }

    public function assigned_appointments($user){
       $this->db->select('*');
        $this->db->where('AssignedTo',$user);
        $this->db->where('Status <>','Assigned');
        $this->order_by('when');
        $q = $this->db->get('appointments');
        $q = $q->result_array();
        //print_r($q);
        return $q; 
    }

    public function office_appointments($user){
        $this->db->select('contractors.OfficeID');
        $this->db->where('UserID',$user);
        $ofc = $this->db->get('contractors');
        $req = $ofc->row();
        $user_office = $req->OfficeID;
        $this->db->select('*');
        $this->db->where('OfficeID',$user_office);  
        $this->db->where('Status','Assigned');
        $this->order_by('when');
        $q = $this->db->get('appointments');
        $q = $q->result_array();
         //print_r($q);
         return $q; 
     }

    public function single_appointment($id) {
        $this->db->select('appointments.*, offices.*, insurances.InsuranceName');
        $this->db->from('appointments');
        $this->db->join('offices', 'appointments.OfficeID = offices.OfficeID');
        $this->db->join('insurances', 'appointments.InsuranceCompany = insurances.InsuranceID', 'left outer');
        $this->db->where('AppointmentID',$id);
        $query=$this->db->get();
        return $query->result();
    }
	public function savedata($data)
	{
		//print_r($data);
		$query="insert into users values('','$name','$email','$mobile')";
		$this->db->query($query);
	}
	public function get_bill_data_model($id)
		{
			$this->db->select('
	    			rent_payment_id,
					rent_demand_registerid,
					property_id_number,
					deposit_current_month,
	    			deposit_outstanding_deposit,
					deposit_gst,
					deposit_late_fee,
					SUM(deposit_total_pay) as total,
					 	deposit_receipt_number,
						deposit_receipt_date,
						deposit_depositor,
						deposit_comment,
						paid_at,
						 	SUM(paid_amount) as paidtotal, 
					'
	    	);			
	    	$this->db->from('rent_demand_register_payments');
	    	$this->db->where('property_id_number',$id);
	    	$query = $this->db->get();
			//print_r($query->row_array());
			//echo'<pre>';
			//print_r($ab);
			//	die;
			return $query->row_array();
			
		}
		// get all rent_demand_register_details for server-side datatable with advanced search
		public function get_all_users_by_advance_search(){
			$wh =array();
			$SQL ='SELECT * FROM rent_demand_register_details';
			if($this->session->userdata('property_id_number')!='')
			$wh[]="property_id_number = '".$this->session->userdata('property_id_number')."'";
			if($this->session->userdata('property_number')!='')
			$wh[]=" `property_number` = '".$this->session->userdata('property_number')."'";
			if($this->session->userdata('property_address')!='')
			$wh[]=" `village_address` = '".$this->session->userdata('property_address')."'";

			//$wh[] = " is_admin = 0";
			if(count($wh)>0)
			{
				$WHERE = implode(' and ',$wh);
				return $this->datatable->LoadJson($SQL,$WHERE);
			}
			else
			{
				return $this->datatable->LoadJson($SQL);
			}
		}    
}