<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_office_note extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'NoteID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'OfficeID' => array(
                'type' => 'INT',
                'constraint' => 5,
                'null' => TRUE
            ),
            'UserID' => array(
                'type' => 'INT',
                'constraint' => 5,
                'null' => TRUE
            ),
            'NoteDescription' => array(
                'type' => 'VARCHAR',
                'constraint' => 228,
                'null' => TRUE
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('NoteID', TRUE);
        $this->dbforge->create_table('office_notes');

    }

    public function down() {
        $this->dbforge->drop_table('office_notes');
    }

}