<?php defined('BASEPATH') OR exit('No direct script access allowed');

	class Rent extends MY_Controller {
		function __construct(){
        parent::__construct();
        $this->load->library('rbac');
        $this->load->model('admin/rent_model', 'rent');

        $this->rbac->check_module_access();
		}	
	
		public function rent_demand_register(){
			
			$data['autoid'] = $this->rent->get_rent_last_id();
			$data['wards'] = $this->rent->get_all_wards();
			$data['year'] = $this->rent->get_finnacial_year();
			$data['property'] = $this->rent->get_property_type();
			$data['title']="Rent";
			$data['view'] = 'admin/rents/add';
			$this->load->view('layout', $data);
		}

		public function get_mohalla()
		{
			$ward_no=$this->input->post("ward");

			$ward=$this->security->xss_clean($ward_no);

			$mohalla = $this->rent->get_all_mohalla($ward);

			$output="<option value='' >-- मोहल्ले का नाम --</option>";

			if(!$mohalla=='')
			{
				foreach($mohalla as $moh)
				{
					$output.="<option value='".$moh->id."' >".$moh->name."</option>";
				}
				
			}
			else
			{
				$output.="<option>No mohalla founds</option>";
			}
			$wardnewid = str_pad($ward_no,3,"0",STR_PAD_LEFT);
			$proidNum = '484'.$wardnewid.''.$this->rent->get_rent_last_id();
			echo json_encode(array('output'=>$output,'pronum'=>$proidNum));


		}
		public function get_market()
		{
			$ward_no=$this->input->post("ward");
			$village_no=$this->input->post("village");

			$ward=$this->security->xss_clean($ward_no);
			$village=$this->security->xss_clean($village_no);

			$mohalla = $this->rent->get_all_market($ward,$village);

			$output="<option value='' >-- बाजार का नाम --</option>";

			if(!$mohalla=='')
			{
				foreach($mohalla as $moh)
				{
					$output.="<option value='".$moh->id."' >".$moh->market_name."</option>";
				}
				
			}
			else
			{
				$output.="<option>No Market founds</option>";
			}
			$wardnewid = str_pad($ward_no,3,"0",STR_PAD_LEFT);
			$villnewid = str_pad($village_no,3,"0",STR_PAD_LEFT);
			$proidNum = '484'.$wardnewid.''.$villnewid.''.$this->rent->get_rent_last_id();
			echo json_encode(array('output'=>$output,'pronum'=>$proidNum));

		}
		public function get_auto_pronum()
		{
			$ward_no=$this->input->post("ward");
			$village_no=$this->input->post("village");
			$market_no=$this->input->post("market");
			$ward=$this->security->xss_clean($ward_no);
			$village=$this->security->xss_clean($village_no);
			$market=$this->security->xss_clean($market_no);			
			$wardnewid = str_pad($ward_no,3,"0",STR_PAD_LEFT);
			$villnewid = str_pad($village_no,3,"0",STR_PAD_LEFT);
			if($market_no>0)$marketnewid = str_pad($market_no,3,"0",STR_PAD_LEFT);
			$proidNum = '484'.$wardnewid.''.$villnewid.''.$marketnewid.''.$this->rent->get_rent_last_id();
			echo json_encode(array('pronum'=>$proidNum));

		}

		public function pay(){
			$data['title']="Rent Payment";
			$data['view'] = 'admin/rents/pay';
			$this->load->view('layout', $data);
		}
		public function view_bill(){
			$data['title']="View bill";
			$data['view'] = 'admin/rents/view_bill';
			$this->load->view('layout', $data);
		}
		public function defaulter(){
			$data['title']="Defaulter List";
			$data['info'] = $this->rent->get_all();
			$data['year'] = $this->rent->get_finnacial_year();
			//$data['view'] = 'admin/rents/lists';
			//$this->load->view('layout', $data);
			$data['view'] = 'admin/rents/defaulter';
			$this->load->view('layout', $data);
		}

		public function defaulter_active_data_by_search()
		{
			
			$typeby=$this->input->post("type_by");
			$selectbox=$this->input->post('select_box');
			$listby=$this->input->post('list_by');

			
			$type_by=$this->security->xss_clean($typeby);
			$select_box=$this->security->xss_clean($selectbox);
			$list_by=$this->security->xss_clean($listby);

			$draw=intval($this->input->post("draw"));
			$start=$this->input->post("start");
			$length=$this->input->post("length");

			//$total_rows=$this->rent->count_search($select_box,$type_by,$list_by);
			$data['draw'] = $draw;
    		//$data['recordsTotal'] = $total_rows;
    		//$data['recordsFiltered'] = $total_rows;
			$result=$this->rent->show_table_search($select_box,$length,$start,$type_by,$list_by);
			// echo"<pre>";
			 //print_r($result);
			// die;		
			$res=array();
    		
    		foreach($result as $r)
			{
				

				$res[]=array(
						"rent_demand_registerid"=>$r['rent_demand_registerid'],
						"property_id_number"=>$r['property_id_number'],
						"property_number"=>$r['property_number'],
						"ward_no"=>$r['ward'],
						"m_name"=>$r['village_address'],
						"market"=>$r['market'],
						"father_name"=>$r['father_name'],
						"mobile_number"=>$r['mobile_number'],
						"property"=>$r['property_type'],
						"allotment_date"=>$r['allotment_date'],
						"month_name"=>$r['month_name'],
						"demand_current_month_rent"=>$r['demand_current_month_rent'],
						"demand_due_rent"=>$r['demand_due_rent'],
						"demand_gst"=>$r['demand_gst'],
						"demand_late_fee"=>$r['demand_late_fee'],
						"demand_total_deposit_money"=>$r['demand_total_deposit_money'],
						"deposit_current_month"=>$r['deposit_current_month'],
						"deposit_outstanding_deposit"=>$r['deposit_outstanding_deposit'],
						"deposit_gst"=>$r['deposit_gst'],
						"deposit_late_fee"=>$r['deposit_late_fee'],
						"deposit_total_pay"=>$r['deposit_total_pay'],
						"deposit_receipt_number"=>$r['deposit_receipt_number'],
						"deposit_receipt_date"=>$r['deposit_receipt_date'],
						"deposit_depositor"=>$r['deposit_depositor'],
						"deposit_comment"=>$r['deposit_comment'],
				);
			}	
			$data['data']=$res;
			echo json_encode($data);
		}
		
		public function advance_datatable_json(){				   					   
			$records = $this->rent->get_all_by_json_search();
			$data = array();
			$i=0;
			foreach ($records['data']  as $row) 
			{  
				$status = ($row['is_active'] == 1)? 'checked': '';
				$data[]= array(
					++$i,
					'<a href="edit/'.$row['rent_demand_registerid'].'" class="btn btn-warning btn-xs mr5" title="Edit" ><i class="fa fa-edit"></i></a>
                    <a href="delete/'.$row['rent_demand_registerid'].'" onclick="return confirm("are you sure to delete?")" title="Delete" class="btn btn-danger btn-xs"><i class="fa fa-remove"></i></a>',
					$row['property_id_number'],
					$row['property_number'],
					$row['ward_no'].','.$row['ward_name'],
					$row['m_name'],
					$row['market'],
					$row['father_name'],
					$row['mobile_number'],					
					date_time($row['allotment_date']),
					$row['month_name'],
					$row['demand_current_month_rent'],
					$row['demand_due_rent'],
					$row['demand_gst'],
					$row['demand_late_fee'],
					$row['demand_total_deposit_money'],
					$row['deposit_current_month'],
					$row['deposit_outstanding_deposit'],
					$row['deposit_gst'],
					$row['deposit_late_fee'],
					$row['deposit_total_pay'],
					$row['deposit_receipt_number'],
					$row['deposit_receipt_date'],
					$row['deposit_depositor'],
					$row['deposit_comment']
					
					//'<input type="checkbox" class="tgl-ios" '.$status.'><label for=""></label>'
				);
			}
			$records['data']=$data;
			echo json_encode($records);						   
		}
		function insert_rent_demand()
		{
			
			$message = 1;    
			$this->load->library('form_validation');
			$this->load->model('rent_model');       
			$data = $this->input->post();
			// print_r($this->input->post());
			// die;
			$this->form_validation->set_data($data);
			$data['created_at']= date('Y-m-d');
			$data['is_active'] = 0; 			
			$this->db->insert('rent_demand_register_details',$data);        
			//$this->rent_model->insert($data);
			redirect('admin/rent/rent_demand_register/'. $message);
		}
		function update_rent_demand()
		{
			
			$message = 0;    
			$this->load->library('form_validation');
			$this->load->model('rent_model');       
			$data = $this->input->post();
			$this->form_validation->set_data($data);
			$id = $this->input->post('rent_demand_registerid');
			$data['created_at']= date('Y-m-d');
			$data['is_active'] = 1;
			$result = $this->rent->edit_admin($data, $id);
			//print_r($result);
            if( $result ){
                            //$this->session->set_flashdata('msg', 'Admin has been updated successfully!');
						   $message = 3;  
                           redirect('admin/rent/rent_demand_register/'. $message);
                         }
			//$this->db->insert('rent_demand_register_details',$data);        
			//$this->rent_model->insert($data);
			//redirect('admin/rent/rent_demand_register/'. $message);
		}
		function list_data(){
			$data['info'] = $this->rent->get_all();
			$data['view'] = 'admin/rents/lists';
			$this->load->view('layout', $data);
		}
		
		public function edit($id=""){
			$data['title']="Rent";
			$this->load->library('utils');
			$jma_rent = $this->rent->getdata_rentpayment($id);
			$total = $jma_rent['total'];
			$paidtotal = $jma_rent['paidtotal'];
			$pendingamt = ($total - $paidtotal);// totalamt - totalpaidamt
			$pendingtotal = $pendingamt; //total pending amt
			$currentm = $jma_rent['deposit_outstanding_deposit'];
			$currentgst = $jma_rent['deposit_gst'];
			$currentlatefee = $jma_rent['deposit_late_fee'];			
			$deposit_month = $jma_rent['paid_at'];
			$month = explode("-",$deposit_month);			
			$depo_month = empty($month[1]); //deposit date month 
			$current_month= date('Y-m-d');		
			$cmonth = explode("-",$current_month);
			$curent_month = $cmonth[1]; // current running month
			$month_latefee = $curent_month-$depo_month;
			$total_latefee = $month_latefee * $currentlatefee; // total late fee (depost mont - curent month = latefee x month)			
			$currentpending = $pendingtotal;			
			$totallate ='';
			if($total !== $paidtotal) $totallate = $currentlatefee; // if tatol mag != total jma (then charge late_fee)
			$total_currentamt = (($currentm * $month_latefee)+ ($currentgst * $month_latefee)+ $total_latefee + $currentpending);			
			//$data['demand'] = $this->rent->getdata_rentpayment($id);
			$data['pending']= $pendingtotal;
			$data['currentmonth']= $currentm * $month_latefee;
			$data['gst']= $currentgst * $month_latefee;
			$data['late_fee']= $total_latefee;
			$data['receipt_number']= $jma_rent['deposit_receipt_number'];
			$data['receipt_date']= $jma_rent['deposit_receipt_date'];
			$data['deposit_depositor']= $jma_rent['deposit_depositor'];
			$data['deposit_comment']= $jma_rent['deposit_comment'];
			$data['totalgrantamt']= $total_currentamt;
			$rent = $this->rent->get_rent_by_id($id);
			$data['rent']=$rent;

			$data['mohalla'] = $this->rent->get_all_mohalla($rent['ward']);

			$data['view'] = 'admin/rents/edit';

			$data['wards'] = $this->rent->get_all_wards();

			$data['year'] = $this->rent->get_finnacial_year();
			$data['property'] = $this->rent->get_property_type();

			$this->load->view('layout', $data);
			//print_r($jma_rent);
			//die;
			
			
		}
		
		}
