<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends MY_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library(array('session'));
        if($this->session->userdata('login_data'))
        {
            $session_data = $this->session->userdata('login_data');
        }
        else
        {
            redirect('user/sighIn');
        }

    }

    public function user($msg = null)
    {
        if ($msg)
            $data['msg'] = $msg;
        $this->load->model('user_model');
        $this->load->model('role_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['roles'] = $this->role_model->as_dropdown('RoleName')->get_all();
        $data['users'] = $this->user_model->where(array('Stat' => 1))->get_all();

        $this->load->view('settings/user', $data);
    }

    public function add_user($id = null)
    {
        $this->load->library('encryption');
        $this->load->model('user_model');
        $this->load->model('role_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['role'] = $this->role_model->dropdown_active();
        $data['user'] = null;
        if ($id) {
            $data['user'] = $this->user_model->where(array('UserID' => $id))->get();
            $data['user']['Password'] = $this->encryption->decrypt($data['user']['Password']);
        }
        $this->load->view('settings/add_user', $data);
    }

    public function save_user()
    {
        $message = 2;
        $id = $this->input->post('UserID');
        $this->load->library('form_validation');
        $this->load->library('encryption');
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_user'));
        $this->form_validation->set_data($data);
        if ($this->form_validation->run('save_user') != false) {
            $this->load->model('user_model');
            $data['Password'] = $this->encryption->encrypt($data['Password']);
            if ($id) {
                if ($this->user_model->update($data, $id)) {
                    $message = 1;
                }
            } else {
                if($data['RoleID']==3){

                }else{
                    $this->user_model->insert($data);
                }
                $message = 1;
            }
        }
        redirect('settings/user/' . $message);
    }

    public function delete_user()
    {
        $this->load->model('user_model');
        $id = $this->input->post('UserID');
        $message = 2;
        if ($id) {
            $this->user_model->update(array('Stat' => 2), $id);
            $message = 1;
        }
        redirect('settings/user/' . $message);
    }

    public function role($msg = null)
    {
        if ($msg)
            $data['msg'] = $msg;
        $this->load->model('user_model');
        $this->load->model('role_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['roles'] = $this->role_model->where(array('Stat' => 1))->get_all();

        $this->load->view('settings/role', $data);
    }

    public function add_role($id = null)
    {
        $this->load->model('user_model');
        $this->load->model('role_model');
        $data['session_data'] = $this->user_model->getLoginSession();
        $data['role'] = null;
        if ($id) {
            $data['role'] = $this->role_model->where(array('RoleID' => $id))->get();
        }
        $this->load->view('settings/add_role', $data);
    }

    public function save_role()
    {
        $message = 2;
        $id = $this->input->post('RoleID');
        $this->load->library('form_validation');
        
        
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_role'));
      
        $this->form_validation->set_data($data);
        if ($this->form_validation->run('save_role') != false) {
            $this->load->model('role_model');
            if ($id) {
                if ($this->role_model->update($data, $id)) {
                    $message = 1;
                }
            } else {
                $this->role_model->insert($data);
                $message = 1;
            }
        }
        redirect('settings/role/' . $message);
    }

    public function delete_role()
    {
        $this->load->model('role_model');
        $id = $this->input->post('RoleID');
        $message = 2;
        if ($id) {
            $this->role_model->update(array('Stat' => 2), $id);
            $message = 1;
        }
        redirect('settings/role/' . $message);
    }

    public function office($msg = null)
    {
        if ($msg)
            $data['msg'] = $msg;
        $this->load->model('user_model');
        $this->load->model('office_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['owners'] = $this->user_model->as_dropdown('FirstName')->get_all();
        $data['offices'] = $this->office_model->where(array('Stat' => 1))->get_all();

        $this->load->view('settings/office', $data);
    }

    public function add_office($id = null)
    {
        $this->load->model('user_model');
        $this->load->model('office_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['owners'] = $this->user_model->dropdown_active();
        $data['active'] = array(1=>'Yes',2=>'No');
        $data['office'] = null;
        if ($id) {
            $data['office'] = $this->office_model->where(array('OfficeID' => $id))->get();
        }
        $this->load->view('settings/add_office', $data);
    }

    public function lock_office($id=null) {
        $message = 2;
        if ($id) {
            $this->load->model('office_model');
            $this->office_model->update( array('Active' => 2),$id);
            $message = 1;
        }
        redirect('settings/office/' . $message);
    }

    public function unlock_office($id=null) {
        $message = 2;
        if ($id) {
            $this->load->model('office_model');
            $this->office_model->update( array('Active' => 1),$id);
            $message = 1;
        }
        redirect('settings/office/' . $message);
    }

    public function save_office()
    {
        $message = 2;
        $id = $this->input->post('OfficeID');
        $this->load->library('form_validation');
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_office'));
        $this->form_validation->set_data($data);
        if ($this->form_validation->run('save_office') != false) {
            $this->load->model('office_model');
            if ($id) {
                if ($this->office_model->update($data, $id)) {
                    $message = 1;
                    $contractordata = array(
                        'tablename' => 'contractors',
                        'id' => $this->input->post('OfficeID') ,
                        'newowner' => $this->input->post('OwnerID') );                   
                        $this->load->model('Contractor_model');
                }  
                $this->Contractor_model->contractor_ownerupdate($contractordata); // call the method from the model
               
            } else {
                $this->office_model->insert($data);
                $message = 1;
            }
        }
        //print_r($this->input->post());
        redirect('settings/office/' . $message);
    }

    public function delete_office()
    {
        $this->load->model('office_model');
        $id = $this->input->post('OfficeID');
        $message = 2;
        if ($id) {
            $this->office_model->update(array('Stat' => 2), $id);
            $message = 1;
        }
        redirect('settings/office/' . $message);
    }

    public function insurance($msg = null)
    {
        if ($msg)
            $data['msg'] = $msg;
        $this->load->model('user_model');
        $this->load->model('insurance_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['insurances'] = $this->insurance_model->where(array('Stat' => 1))->get_all();

        $this->load->view('settings/insurance', $data);
    }

    public function add_insurance($id = null)
    {
        $this->load->model('user_model');
        $this->load->model('insurance_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['insurance'] = null;
        if ($id) {
            $data['insurance'] = $this->insurance_model->where(array('InsuranceID' => $id))->get();
        }
        $this->load->view('settings/add_insurance', $data);
    }

    public function save_insurance()
    {
        $message = 2;
        $id = $this->input->post('InsuranceID');
        $this->load->library('form_validation');
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_insurance'));
        $this->form_validation->set_data($data);
        if ($this->form_validation->run('save_insurance') != false) {
            $this->load->model('insurance_model');
            if ($id) {
                if ($this->insurance_model->update($data, $id)) {
                    $message = 1;
                }
            } else {
                $this->insurance_model->insert($data);
                $message = 1;
            }
        }
        redirect('settings/insurance/' . $message);
    }

    public function delete_insurance()
    {
        $this->load->model('insurance_model');
        $id = $this->input->post('InsuranceID');
        $message = 2;
        if ($id) {
            $this->insurance_model->update(array('Stat' => 2), $id);
            $message = 1;
        }
        redirect('settings/insurance/' . $message);
    }

    public function appointment_limit($msg = null)
    {
        if ($msg)
            $data['msg'] = $msg;
        $this->load->model('user_model');
        $this->load->model('appointment_limit_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['limits'] = $this->appointment_limit_model->where(array('Stat' => 1))->get_all();

        $this->load->view('settings/appointment_limit', $data);
    }

    public function edit_appointment_limit($id = null)
    {
        $this->load->model('user_model');
        $this->load->model('appointment_limit_model');

        $data['session_data'] = $this->user_model->getLoginSession();
        $data['limit'] = null;
        if ($id) {
            $data['limit'] = $this->appointment_limit_model->where(array('LimitID' => $id))->get();
        }
        $this->load->view('settings/edit_appointment_limit', $data);
    }

    public function save_appointment_limit()
    {
        $message = 2;
        $id = $this->input->post('LimitID');
        $this->load->library('form_validation');
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_appointment_limit'));
        $this->form_validation->set_data($data);
        if ($this->form_validation->run('save_appointment_limit') != false) {
            $this->load->model('appointment_limit_model');
            if ($this->appointment_limit_model->update($data, $id)) {
                $message = 1;
            }
        }
        redirect('settings/appointment_limit/' . $message);
    }
    
    // [ @kanchan 04-nov-2019
     public function appt_status_list($msg = null)
    {
        if ($msg)
            $data['msg'] = $msg;
            
        $this->load->model('user_model');    
        $this->load->model('ApptStatus_model');
        $data['statusList'] = $this->ApptStatus_model->where(array('Stat' => 1))->get_all();
        $data['statusArray'] = array(1=>'Yes',0=>'No');
        $data['session_data'] = $this->user_model->getLoginSession();

        $this->load->view('settings/appt_status_list', $data);
    }

    public function add_appt_status($id = null)
    {
        $this->load->model('user_model');
        $this->load->model('ApptStatus_model');
        $data['session_data'] = $this->user_model->getLoginSession();
        $data['ApptStatus'] = null;
        if ($id) {
            $data['ApptStatus'] = $this->ApptStatus_model->where(array('StatusID' => $id))->get();
        }
        $data['statusArray'] = array(1=>'Yes',0=>'No');
        $this->load->view('settings/add_appt_status', $data);
    }

    public function save_appt_status()
    {  
        $message = 2;
        $id = $this->input->post('StatusID');
        $this->load->library('form_validation');
        
        $data = $this->form_validation->remove_unknown_fields($this->input->post(), $this->form_validation->get_field_names('save_appt_status'));
       
        $this->form_validation->set_data($data);
        
         
        if ($this->form_validation->run('save_appt_status') != false) {
        
            $this->load->model('ApptStatus_model');
           
            if ($id) {
              
                if ($this->ApptStatus_model->update($data, $id)) {
                    $message = 1;
                }
            } else {
                
                $this->ApptStatus_model->insert($data);
                $message = 1;
            }
        }else{
            
            //print_r(validation_errors());
            
        }
        redirect('settings/appt_status_list/' . $message);
    }
    
       public function delete_appt_status()
    {
        $this->load->model('ApptStatus_model');
        
        $id = $this->input->post('StatusID');
      
        
        $message = 2;
        if ($id) {
            $this->ApptStatus_model->update(array('Stat' => 2), $id);
            $message = 1;
        }
         redirect('settings/appt_status_list/' . $message);
    }

    //  @kanchan 04-nov-2019 ]
    
}
?>