<?php
$mainmenu = $this->mainmenu->buildMenu($session_data['utype'], 6);
$prof_inf = $this->messages->getUserInf($session_data['id']);
$data['title'] = "APPOINTMENT";
$data['mainmenu'] = $mainmenu;
$data['profinf'] = $prof_inf;
$data['userinf'] = $session_data;
if (isset($msg)) {
    $data['msg'] = $this->messages->getMessage($msg);
}
$this->load->view('layout/header2', $data);
?>
<?php echo validation_errors(); ?>
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Add Appointment
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i>Add Appointment</a></li>
        </ol>
    </section>
    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">please add your appointment</h3>
            </div>
            <div class="box-body">
                <?php echo form_open('appointment/save_appointment', 'id="form1" data-parsley-validate class=""'); ?>

                <h3 class="box-title">Appointment Info</h3>
                <div class="row">
                    <div class="col-md-6">
                        <label for="last-name"> Office <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('appointmentid', $appointment['AppointmentID'], 'class="form-control" id ="appointmentid" style="display:none"');
                        echo form_dropdown('OfficeID', $office, $appointment['OfficeID'], 'class="form-control col-md-7 col-xs-12"');
                        ?>
                    </div>
                    <div class="col-md-6">
                        <label for="phone"> Roof age   <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('RoofAge', $appointment['RoofAge'], 'class="form-control"'); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="ladder"> Tall ladder on premise <span class="required">*</span>
                        </label>
                        <?php
                        echo form_dropdown('Ladder', $ladder, $appointment['Ladder'], 'class="form-control col-md-7 col-xs-12"');
                        ?>
                    </div>

                    <div class='col-md-6'>
                    <label for="when"> Appointment Date/Time <span class="required">*</span>
                        </label>
                    <?php  echo form_input('When', $appointment['When'], 'class="form-control col-md-3 " id="datetimepicker4" autocomplete="off"  '); ?>
                   </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                       
                    </div>

                    <div class='col-md-6'>
                    <?php  if (strlen($appointment['TheTime']) > 0) echo 'Date: '.date('M-d-Y', strtotime($appointment['When'])). ' Time: '.$appointment['TheTime']?>
                   </div>
                </div>

                       


                <h3 class="box-title">Homeowner's Info</h3>
                <div class="row">
                    <div class="col-md-6">
                        <label for="first-name"> First Name <span class="required">*</span>
                        </label>
                        <?php
                        echo form_hidden('AppointmentID', $appointment['AppointmentID']);
                        echo form_input('FirstName', $appointment['FirstName'], 'class="form-control"'); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="last-name"> Last Name <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('LastName', $appointment['LastName'], 'class="form-control"'); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="email"> Phone number <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('Phone', $appointment['Phone'], 'class="form-control Phone_c"'); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="password"> Email
                        </label>
                        <?php
                        echo form_input('Email', $appointment['Email'], 'class="form-control"'); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="email"> Address <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('Address', $appointment['Address'], 'class="form-control"'); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="password"> Address Line 2
                        </label>
                        <?php
                        echo form_input('AddressLine2', $appointment['AddressLine2'], 'class="form-control"'); ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <label for="phone"> City <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('City', $appointment['City'], 'class="form-control"'); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="phone"> State <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('State', $appointment['State'], 'class="form-control"'); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="phone"> Zip code <span class="required">*</span>
                        </label>
                        <?php
                        echo form_input('Zip', $appointment['Zip'], 'class="form-control"'); ?>
                    </div>
                </div>

                <h3 class="box-title">House info</h3>
                <div class="row">
                    <div class="col-md-6">
                        <label for="last-name"> Roof type <span class="required">*</span>
                        </label>
                        <?php
                        echo form_dropdown('RoofType', $rooftype, $appointment['RoofType'], 'class="form-control col-md-7 col-xs-12"');
                        ?>
                    </div>
                    <div class="col-md-6">
                        <label for="phone"> Insured <span class="required">*</span>
                        </label>
                        <?php
                        echo form_dropdown('Insured', $insured, $appointment['Insured'], 'class="form-control col-md-7 col-xs-12"');
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="phone"> Insurance company name
                        </label>
                        <?php
                        echo form_dropdown('InsuranceCompany', $insurance, $appointment['InsuranceCompany'], 'class="form-control col-md-7 col-xs-12"');
                        ?>
                    </div>
                </div>

                <div class="row">                 
                    <div class="col-md-6">
                    <h3 class="box-title">Notes</h3>
                       <div class="box-body">
                         
                               <?php
                               if(!empty($appointment_notes)){
                                   echo ' <ul>' ;
                               foreach ($appointment_notes as $appointment_note) { ?>
                               
                                    <?php 
                                    if ($appointment_note['Internal'] == 0)
                                      $theclass = 'text-danger';
                                    else if  ($appointment_note['Internal'] == 1)
                                      $theclass= 'text-success';
                                    echo '<li class='.$theclass.'>'.$appointment_note['Note'].' ('.$appointment_note['FirstName'].' ' .$appointment_note['LastName'].' - '.date('M-d-Y g:i A', strtotime($appointment_note['Created_at'])).')</li>' ?>
                                <?php
                                }
                                echo ' </ul>' ;
                               
                            } 
                            else echo 'No Notes'; ?>       
                         </div>
                    </div>
                    <div class="col-md-6">
                    <h3 class="box-title">Add Note</h3>                    
                    <select name="Internal">
                            <option value="1">Internal Only</option>
                            <option value="0">Public Note</option>
                        </select>
                                <?php
                                echo form_textarea('Note', '', 'class="form-control"');
                               // echo form_hidden('Internal', '1'); 
                                ?>  
                     </div>
                 </div>

                 <div class="row">

                <?php 
                                       
                 if ($session_data['utype'] == 1) {
                    $assignmentlabel = 'Assigned User';
                    $statuslabel = 'Appointment Status';
                     $statusselector = $statusall;
                     $assignmentselector = $allusers;
                     if ($appointment['Status'] == 'QC Approved') 
                        {
                           $assignmentlabel = 'Select Contractor';
                           $assignmentselector = $contractor;
                        }
                     else if ($appointment['Status'] == 'Assignment Pending') 
                     {
                        $assignmentlabel = 'Assigned To';
                        $assignmentselector = $agent; 
                        $statusselector = $statusall;                       
                     } 
                 }
                else if ($session_data['utype'] == 4) {
                    $statuslabel = 'Appointment Status';
                    $assignmentlabel = 'Assigned Agent';
                    $assignmentselector = $agent;
                    $statusselector = $statusagentnew;
                    if ($appointment['Status'] == 'New') 
                      {
                       $statusselector = $statusagentnew;
                       $assignmentselector = $agent;
                       $assignmentlabel = 'Assigned To';
                      } 
                      /*
                      else if ($appointment['Status'] == 'QC Approved') 
                      {
                        $statusselector = $statusagentqcok; 
                        $assignmentselector = $contractor; 
                        $assignmentlabel = 'Select Contractor';
                       } */
                       else if ($appointment['Status'] == 'Rejected') 
                       {
                        $statusselector = $statusRejected;
                       } 
                       else if ($appointment['Status'] == 'Assignment Pending') 
                       {
                        $statusselector = $statusagentqcok; 
                        $assignmentselector = $agent; 
                        $assignmentlabel = 'Assigned Agent';
                       }
                    } 
                else {
                    $statuslabel = 'Appointment Status';
                    $assignmentlabel = 'Assigned Agent';
                    $assignmentselector = $agent;
                    $statusselector = $statusagentnew; 
                }

                $assignment_section= '
                <div class="col-md-6">
                        <label for="AssignedTo">'.$assignmentlabel.'
                        </label>'.form_dropdown('AssignedTo', $assignmentselector, $appointment['AssignedTo'], 'class="form-control col-md-7 col-xs-12"').
                    '</div>'; 
                $status_section= '
                <div class="col-md-6">
                        <label for="Stat">'.$statuslabel.'
                        </label>'.form_dropdown('Status', $statusselector, $appointment['Status'], 'class="form-control col-md-7 col-xs-12"').
                    '</div>'; 
                if ($session_data['utype'] != 3) {
                    echo $assignment_section;
                    echo $status_section;
                }
                if ($appointment['Reason']) echo '<div class="col-md-6"></div><div class="col-md-6">'.form_dropdown('Reason', $reason, $appointment['Reason'], 'class="form-control col-md-7 col-xs-12"').'</div>';
                ?>

                
                </div>
                <br>
                <div class="box-footer">
                    <button type="submit" value="Validate!" class="btn btn-success pull-right">Submit</button>
                </div>
                <?php echo form_close(); ?>
            </div>

        </div>
    </section>
</div>

<?php
$this->load->view('layout/footer2');
?>
<script type="text/javascript" src="<?php echo base_url(); ?>layout/js/jquery.validate.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js"></script>
<script>$(document).ready(function(){
    $('input.timepicker').timepicker({});
});</script>
<script type="text/javascript">
$('.timepicker').timepicker({
    timeFormat: 'h:mm p',
    interval: 60,
    minTime: '8',
    maxTime: '8:00pm',
    startTime: '8:00',
    dynamic: false,
    dropdown: true,
    scrollbar: true
});
        </script>
<script>
    $(document).ready(function () {

        var cleave = new Cleave('.Phone_c', {
            phone: true,
            phoneRegionCode: 'us'
        });

        var id = $('#appointmentid').val();

        if(!id){
            var today = new Date();
            var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
            var yyyy = today.getFullYear();

            var time = today.getHours()
            if(time < 16){
                var dd = String(today.getDate()).padStart(2, '0');
                today = yyyy + '-' + mm + '-' + dd;
            }else{
                var dd = String(today.getDate()+1).padStart(2, '0');
                today = yyyy + '-' + mm + '-' + dd;
            }

            $('#datepicker').val(today);
        }


        jQuery.validator.addMethod("lettersonly", function (value, element) {
            return this.optional(element) || /^[a-z]+$/i.test(value);
        }, "Please enter only letters without space.");
        $("#form1").validate({
            errorElement: "p",
            rules: {
                FirstName: {
                    required: true,
                },
                LastName: {
                    required: true,
                },
                Phone: {
                    required: true
                },
                OfficeID: {
                    required: true
                },
                Email: {
                    email: true
                },
                RoofAge: {
                    required: true,
                    number:true
                },
                Ladder: {
                    required: true
                },
                Address: {
                    required: true
                },
                City: {
                    required: true
                },
                State: {
                    required: true
                },
                Zip: {
                    required: true
                },
                RoofType: {
                    required: true
                },
                Insured: {
                    required: true
                },
                AssignedTo: {
                    required: true
                },
                When:{
                    required: true
                },
                TheTime:{
                    required: false
                },
                Status:{
                    required: true
                },
                Note: {
                    required: false
                }  
            },
            errorPlacement: function (error, element) {
                error.appendTo(element.parent());
            }
        });
    });
</script>