<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_appointment_limit extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'LimitID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'Day' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => TRUE
            ),
            'Limit' => array(
                'type' => 'INT',
                'constraint' => 5,
                'null' => TRUE
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('LimitID', TRUE);
        $this->dbforge->create_table('appointment_limit');

        $data = array(
            array('Day' => 'Monday','Limit' => 5),
            array('Day' => 'Tuesday','Limit' => 5),
            array('Day' => 'Wednesday','Limit' => 5),
            array('Day' => 'Thursday','Limit' => 5),
            array('Day' => 'Friday','Limit' => 5),
            array('Day' => 'Saturday','Limit' => 3),
            array('Day' => 'Sunday','Limit' => 3)
        );
        $this->db->insert_batch('appointment_limit', $data);
    }

    public function down() {
        $this->dbforge->drop_table('appointment_limit');
    }

}