<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_contractor_billing extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'BillID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'ContractorID' => array(
                'type' => 'INT',
                'constraint' => 5,
                'null' => TRUE
            ),
            'CardType' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE
            ),
            'CardName' => array(
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => TRUE
            ),
            'CardNumber' => array(
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => TRUE
            ),
            'Expiration' => array(
                'type' => 'VARCHAR',
                'constraint' => 10,
                'null' => TRUE
            ),
            'Code' => array(
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => TRUE
            ),
            'Address' => array(
                'type' => 'VARCHAR',
                'constraint' => 200,
                'null' => TRUE
            ),
            'City' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => TRUE
            ),
            'State' => array(
                'type' => 'VARCHAR',
                'constraint' => 10,
                'null' => TRUE
            ),
            'Zip' => array(
                'type' => 'VARCHAR',
                'constraint' => 10,
                'null' => TRUE
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('BillID', TRUE);
        $this->dbforge->create_table('contractor_billing');

    }

    public function down() {
        $this->dbforge->drop_table('contractor_billing');
    }

}