<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_insurance extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'InsuranceID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'InsuranceName' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => TRUE
            ),
            'InsuranceDescription' => array(
                'type' => 'VARCHAR',
                'constraint' => 128,
                'null' => TRUE
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('InsuranceID', TRUE);
        $this->dbforge->create_table('insurances');

        $data = array(
            array('InsuranceName' => 'insurance 1','InsuranceDescription' => 'insurance 1'),
            array('InsuranceName' => 'insurance 2','InsuranceDescription' => 'insurance 1'),

        );
        $this->db->insert_batch('insurances', $data);
    }

    public function down() {
        $this->dbforge->drop_table('insurances');
    }

}