<?php defined('BASEPATH') OR exit('No direct script access allowed');
    class Product extends MY_Controller {
        function __construct(){
            parent::__construct();
            $this->load->model('admin/product_model', 'productmd');
            $this->load->library('datatable'); // loaded my custom serverside datatable library
            
            $this->rbac->check_module_access();
        }

        public function index(){
            //echo $this->session->userdata('admin_role_id')."<br />";
            //echo $this->session->userdata('admin_role')."<br />";
            //$data['modaccess'] = $this->rbac->get_module_access();
            //$sess_arr = $this->session->userdata();
            //$sess_arr = $this->session->userdata('module_access');
            //echo "<pre>"; print_r($sess_arr); echo "</pre>";
            $data['view'] = 'admin/product/product_list';
            $this->load->view('layout', $data);
        }

        public function get_datatable_json(){
            $this->load->library('utils');
            $op = $this->utils->action_validate_role( $this->session->userdata('admin_role') ); //echo "op: ".$op."<br />";

            $rec = $this->productmd->product_get_all();
            $data = array();
            $i=0;
            foreach ($rec['data']  as $row){
                $status = ($row['is_active'] == 1)? 'checked': '';

                $link_mod = base_url('admin/product/edit/'.$row['product_id']);
                $link_del = base_url('admin/product/delete/'.$row['product_id']);
                $link_assign = base_url('admin/product/assigned_segs/'.$row['product_id']);
                $link_copy = base_url('admin/product/copy/'.$row['product_id']);

                $action = '';
                $action .= '<a title="Edit" class="update btn btn-sm btn-warning" href="'.$link_mod.'"> <i class="fa fa-pencil-square-o"></i></a> ';
                $action .= '<a title="Delete" class="delete btn btn-sm btn-danger" data-href="'.$link_del.'" data-toggle="modal" data-target="#confirm-delete"> <i class="fa fa-trash-o"></i></a> ';
                $action .= '<a title="Copy this product" class="view btn btn-sm btn-success" href="'.$link_copy.'"><i class="fa fa-copy"></i></a> ';
                $action .= '<a title="Assign Products to Segment" class="view btn btn-sm btn-blue1" href="'.$link_assign.'">Assign Seg</a>';

                $description = $this->utils->mysql_decode_val($row['description']);
                $description = $this->utils->get_truncate_str($description, 15);

                $data[]= array(
                    ++$i,
                    $row['product_name'],
                    $row['product_sku'],
                    $description.'...',
                    $row['price'],
                    $row['shipping'],
                    '<input class="tgl_checkbox tgl-ios" data-id="'.$row['product_id'].'" id="cb_'.$row['product_id'].'" type="checkbox" '.$status.'><label for="cb_'.$row['product_id'].'"></label>',
                    $action
                );
            }
            $rec['data']=$data;
            echo json_encode($rec); 
        }

        public function delete($id = 0){
            $this->rbac->check_operation_access();
            
            $product_id = $this->uri->segment(4);
            $this->productmd->product_delete($product_id);
            $this->session->set_flashdata('msg', 'The Product has been deleted successfully!');
            redirect(base_url('admin/product'));
        }

        public function change_status(){
            $status = $this->input->post('status');
            $id = $this->input->post('id');
            $res = $this->productmd->product_change_status($id, $status);
            //echo "affected rows: ".$res;
        }

        public function add(){
            $this->rbac->check_operation_access();
            
            $this->load->library('utils');

            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_product_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_product_sku', 'SKU', 'trim|required');
                $this->form_validation->set_rules('fv_description', 'Description', 'trim|required');
                $this->form_validation->set_rules('fv_price', 'Price', 'trim|required');
                $this->form_validation->set_rules('fv_shipping', 'Shipping', 'trim|required');
                $this->form_validation->set_rules('fv_is_active', 'Status', 'trim|required');

                if ($this->form_validation->run() == FALSE) {
                    $data['view'] = 'admin/product/product_add';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                        'product_name' => $this->utils->mysql_encode_val($this->input->post('fv_product_name')),
                        'product_sku' => $this->input->post('fv_product_sku'),
                        'description' => $this->utils->mysql_encode_val($this->input->post('fv_description')),
                        'price' => $this->input->post('fv_price'),
                        'shipping' => $this->input->post('fv_shipping'),
                        'is_active' => $this->input->post('fv_is_active')
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->productmd->product_add($data);
                    if($result){
                        $this->session->set_flashdata('msg', 'Product has been added successfully!');
                        redirect(base_url('admin/product'));
                    }
                }
            }
            else{
                $data['view'] = 'admin/product/product_add';
                $this->load->view('layout', $data);
            }
        }

        public function get_product_decoded($id){
            $data_arr = array();
            $rec = $this->productmd->get_product_by_id($id); //echo "<pre>"; print_r($rec); echo "</pre>";
            
            $data_arr['product_id'] = $rec['product_id'];
            $data_arr['product_name'] = $this->utils->mysql_decode_val($rec['product_name']);
            $data_arr['product_sku'] = $rec['product_sku'];
            $data_arr['description'] = $this->utils->mysql_decode_val($rec['description']);
            $data_arr['price'] = $rec['price'];
            $data_arr['shipping'] = $rec['shipping'];
            $data_arr['is_active'] = $rec['is_active'];

            return $data_arr;
        }

        public function edit($id = 0){
            $this->rbac->check_operation_access();

            $this->load->library('utils');

            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_product_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_product_sku', 'SKU', 'trim|required');
                $this->form_validation->set_rules('fv_description', 'Description', 'trim|required');
                $this->form_validation->set_rules('fv_price', 'Price', 'trim|required');
                $this->form_validation->set_rules('fv_shipping', 'Shipping', 'trim|required');
                $this->form_validation->set_rules('fv_is_active', 'Status', 'trim|required');

                if( $this->form_validation->run() == FALSE ){
                    
                    $rec['product_id'] = $id;
                    $rec['product_name'] = $this->input->post('fv_product_name');
                    $rec['product_sku'] = $this->input->post('fv_product_sku');
                    $rec['description'] = $this->input->post('fv_description');
                    $rec['price'] = $this->input->post('fv_price');
                    $rec['shipping'] = $this->input->post('fv_shipping');
                    $rec['is_active'] = $this->input->post('fv_is_active');
                    
                    $data['rec'] = $rec;
                    $data['view'] = 'admin/product/product_edit';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                        'product_name' => $this->utils->mysql_encode_val($this->input->post('fv_product_name')),
                        'product_sku' => $this->input->post('fv_product_sku'),
                        'description' => $this->utils->mysql_encode_val($this->input->post('fv_description')),
                        'price' => $this->input->post('fv_price'),
                        'shipping' => $this->input->post('fv_shipping'),
                        'is_active' => $this->input->post('fv_is_active')
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->productmd->product_edit($data, $id);
                    if($result){
                        $this->session->set_flashdata('msg', 'Product has been updated successfully!');
                        redirect(base_url('admin/product'));
                    }
                }
            }
            else{
                $rec = $this->get_product_decoded($id); //echo "<pre>"; print_r($rec_client); echo "</pre>";
                $data['rec'] = $rec;
                $data['view'] = 'admin/product/product_edit';
                $this->load->view('layout', $data);
            }
        }

        public function copy($id = 0){
            $this->rbac->check_operation_access();

            $this->load->library('utils');
            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_product_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_product_sku', 'SKU', 'trim|required');
                $this->form_validation->set_rules('fv_description', 'Description', 'trim|required');
                $this->form_validation->set_rules('fv_price', 'Price', 'trim|required');
                $this->form_validation->set_rules('fv_shipping', 'Shipping', 'trim|required');
                $this->form_validation->set_rules('fv_is_active', 'Status', 'trim|required');

                if( $this->form_validation->run() == FALSE ){
                    
                    $rec['product_id'] = $id;
                    $rec['product_name'] = $this->input->post('fv_product_name');
                    $rec['product_sku'] = $this->input->post('fv_product_sku');
                    $rec['description'] = $this->input->post('fv_description');
                    $rec['price'] = $this->input->post('fv_price');
                    $rec['shipping'] = $this->input->post('fv_shipping');
                    $rec['is_active'] = $this->input->post('fv_is_active');
                    
                    $data['rec'] = $rec;
                    $data['view'] = 'admin/product/product_copy';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                        'product_name' => $this->utils->mysql_encode_val($this->input->post('fv_product_name')),
                        'product_sku' => $this->input->post('fv_product_sku'),
                        'description' => $this->utils->mysql_encode_val($this->input->post('fv_description')),
                        'price' => $this->input->post('fv_price'),
                        'shipping' => $this->input->post('fv_shipping'),
                        'is_active' => $this->input->post('fv_is_active')
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->productmd->product_add($data);
                    if($result){
                        $this->session->set_flashdata('msg', 'Product has been copied and added successfully!');
                        redirect(base_url('admin/product'));
                    }
                }
            }
            else{
                $rec = $this->get_product_decoded($id); //echo "<pre>"; print_r($rec_client); echo "</pre>";
                $data['rec'] = $rec;
                $data['view'] = 'admin/product/product_copy';
                $this->load->view('layout', $data);
            }
        }

        public function assigned_segs($cod01){
            $this->rbac->check_operation_access();

            $data['rec'] = $this->productmd->get_product_by_id($cod01);
            $data['cod01'] = $cod01;
            $data['view'] = 'admin/product/product_assignedsegs';
            $this->load->view('layout', $data);

        }

        public function get_seg_datatable_json( $product_id ){
            $this->load->library('utils');
            //$op = $this->utils->action_validate_role( $this->session->userdata('admin_role') ); //echo "op: ".$op."<br />";

            $rec = $this->productmd->product_segment_get_all( $product_id );
            $data = array();
            $i=0;
            foreach ($rec['data']  as $row){
                //$status = ($row['is_active'] == 1)? 'checked': '';
                $_link = base_url('admin/product/delete_seg/'.$row['product_pid'].'/'.$row['segment_pid']);
                //$_link = base_url('admin/product/delete_seg/1/1');
                $action = '<a title="Delete" class="delete btn btn-sm btn-danger" data-href="'.$_link.'" data-toggle="modal" data-target="#confirm-delete"> <i class="fa fa-trash-o"></i></a>';
                $data[]= array(
                    ++$i,
                    $row['segment_name'],
                    $row['segment_code'],
                    $row['segment_question'],
                    //'<input class="tgl_checkbox tgl-ios" data-id="'.$row['segment_id'].'" id="cb_'.$row['segment_id'].'" type="checkbox" '.$status.'><label for="cb_'.$row['segment_id'].'"></label>',
                    $action
                );
            }
            $rec['data']=$data;
            echo json_encode($rec); 
        }

        public function delete_seg($cod01 = 0, $id){
            $this->rbac->check_operation_access();

            $this->productmd->product_delete_seg($cod01, $id); //(prod_id, seg_id)
            $this->session->set_flashdata('msg', 'The Segment has been removed successfully!');
            redirect(base_url('admin/product/assigned_segs/'.$cod01.'/'));
        }


        public function get_seglist_datatable_json( $cod01 ){
            $rec = $this->productmd->segment_get_all();
            $data = array();
            $i=0;
            foreach ($rec['data']  as $row){
                //$status = ($row['is_active'] == 1)? 'checked': '';
                $assignLink = base_url('admin/product/seglist/sub1/'.$cod01.'/'.$row['segment_id']);
                $action = '';
                //$action .= '<a title="Delete" class="delete btn btn-sm btn-danger" data-href="'.base_url('admin/segment/delete_prod/'.$cod01.'/'.$row['product_id']).'" data-toggle="modal" data-target="#confirm-delete"> <i class="fa fa-trash-o"></i></a>';
                $action .= '<a title="Manage Segment Flow" class="view btn btn-sm btn-blue1" href="'.$assignLink.'">Assign this</a>';
                $data[]= array(
                    ++$i,
                    $row['segment_name'],
                    $row['segment_code'],
                    $row['segment_question'],
                    $action
                );
            }
            $rec['data']=$data;
            echo json_encode($rec);
        }

        public function seglist( $flag, $cod01, $segid ){
            $this->rbac->check_operation_access();

            $msg = "";
            if( $flag == 'sub1' ){
                
                //echo "cod01: ".$cod01."<br />";
                //echo "prodid: ".$prodid."<br />";

                $rs = $this->productmd->segment_product($cod01, $segid);
        
                if( count( $rs ) == 0 ){
                    $data = array(
                        'segment_pid' => $segid,
                        'product_pid' => $cod01,
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->productmd->product_segment_add($data);
                    if($result){
                        $this->session->set_flashdata('msg', 'Product has been assigned successfully!');
                        redirect(base_url('admin/product/assigned_segs/'.$cod01));
                    }
                }
                else{
                    $data['msg'] = "The Segment is already assigned"; //$msg;
                    $data['rec'] = $this->productmd->get_product_by_id($cod01);
                    $data['cod01'] = $cod01;
                    $data['view'] = 'admin/product/product_seglist';;
                    $this->load->view('layout', $data);
                }
            }
            else{
                $data['msg'] = $msg;
                $data['rec'] = $this->productmd->get_product_by_id($cod01);
                $data['cod01'] = $cod01;
                $data['view'] = 'admin/product/product_seglist';
                $this->load->view('layout', $data);
            }
        }

        public function prodadd($cod01, $prod_id){
            $data = array(
                'q_pid' => $q_id,
                'admin_pid' => $user_id,
                'user_type' => 'u',
                'is_done' => '0',
                'data' => '',
                'date_n' => '0',
                'date_d' => '00-00-00 00:00:00'

            );
            $data = $this->security->xss_clean($data);
            $result = $this->user_question_model->assign($data);
            if($result){
                $this->session->set_flashdata('msg', 'Support file has been assigned successfully!');
                redirect(base_url('admin/user_question/'.$params));
            }
        }
    }
?>