<?php defined('BASEPATH') OR exit('No direct script access allowed');
    class Bug_report extends MY_Controller {
        function __construct(){
            parent::__construct();
            $this->load->model('admin/bug_report_model', 'bugreportmd');
            $this->load->library('datatable'); // loaded my custom serverside datatable library
            
            //$this->rbac->check_module_access();
        }

        public function check_timezone(){
            echo "vultr server date time: ".date('Y-m-d H:i:s')."<br />";
        }

        public function index(){
            //echo $this->session->userdata('admin_role_id')."<br />";
            //echo $this->session->userdata('admin_role')."<br />";
            //$data['modaccess'] = $this->rbac->get_module_access();
            //$sess_arr = $this->session->userdata();
            //$sess_arr = $this->session->userdata('module_access');
            //echo "<pre>"; print_r($sess_arr); echo "</pre>";
            $data['view'] = 'admin/bug_report/bug_report_list';
            $this->load->view('layout', $data);
        }

        public function get_datatable_json(){
            $this->load->library('utils');
            
            $rec = $this->bugreportmd->bug_report_get_all();
            $data = array();
            $i=0;
            foreach ($rec['data']  as $row){
                $status1 = ( $row['on_clickup'] == 1 ) ? 'checked' : '';
                $status2 = ( $row['is_done'] == 1 ) ? 'checked' : '';

                $action = "";
                $action .= '<a title="View" class="view btn btn-sm btn-info" href="'.base_url('admin/bug_report/view/'.$row['bug_id']).'"> <i class="fa fa-eye"></i></a> ';
                //$action .= '<a title="Edit" class="update btn btn-sm btn-warning" href="'.base_url('admin/bug_report/edit/'.$row['bug_id']).'"> <i class="fa fa-pencil-square-o"></i></a>';
                //$action .= '<a title="Delete" class="delete btn btn-sm btn-danger" data-href="'.base_url('admin/bug_report/delete/'.$row['bug_id']).'" data-toggle="modal" data-target="#confirm-delete"> <i class="fa fa-trash-o"></i></a>';
                //<a title="Assign Support File" class="supfile btn btn-sm btn-blue1" href="'.base_url('admin/file_access/'.$row['bug_id']).'"> <i class="fa fa-file-o"></i></a>
                //<a title="Manage Requirement" class="view btn btn-sm btn-success" href="'.base_url('admin/requirement/'.$row['bug_id']).'">Req</a>';

                $data[]= array(
                    ++$i,
                    $row['bug_code'],
                    $row['agent_name'],
                    $row['bug_title'],
                    $row['cdate'],
                    //$row['on_clickup'],
                    '<input class="tgl_checkbox1 tgl-ios" data-id="'.$row['bug_id'].'" id="cb1_'.$row['bug_id'].'" type="checkbox" '.$status1.'><label for="cb1_'.$row['bug_id'].'"></label>',
                    '<input class="tgl_checkbox2 tgl-ios" data-id="'.$row['bug_id'].'" id="cb2_'.$row['bug_id'].'" type="checkbox" '.$status2.'><label for="cb2_'.$row['bug_id'].'"></label>',
                    $action
                );
            }
            $rec['data']=$data;
            echo json_encode($rec); 
        }

        public function change_on_clickup_estate(){
            $status = $this->input->post('status');
            $id = $this->input->post('id');
            //echo "(on_clickup) status = ".$status." :: id = ".$id;
            
            $res = $this->bugreportmd->bug_report_change_on_clickup_estate($id, $status);
            //echo "affected rows: ".$res;
        }

        public function change_is_done_estate(){
            $status = $this->input->post('status');
            $id = $this->input->post('id');
            //echo "(is_done) status = ".$status." :: id = ".$id;
            
            $res = $this->bugreportmd->bug_report_change_is_done_estate($id, $status);
            //echo "affected rows: ".$res;
        }
        
        public function view($id = 0){
            //$this->rbac->check_operation_access();

            $this->load->library('utils');
            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_info', 'Info', 'trim|required');
                $this->form_validation->set_rules('fv_is_active', 'Status', 'trim|required');

                if( $this->form_validation->run() == FALSE ){
                    $rec['client_id'] = $id;
                    $rec['name'] = $this->input->post('fv_name');
                    $rec['info'] = $this->input->post('fv_info');
                    $rec['is_active'] = $this->input->post('is_active');

                    $data['rec'] = $rec;
                    $data['view'] = 'admin/client/client_edit';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                        'name' => $this->utils->mysql_encode_val($this->input->post('fv_name')),
                        'info' => $this->utils->mysql_encode_val($this->input->post('fv_info')),
                        'is_active' => $this->input->post('fv_is_active')
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->bugreportmd->client_edit($data, $id);
                    if($result){
                        $this->session->set_flashdata('msg', 'Access Control has been updated successfully!');
                        redirect(base_url('admin/client'));
                    }
                }
            }
            else{
                $rec = $this->bugreportmd->get_bugrep_by_id($id); //echo "[REC]<pre>"; print_r($rec); echo "</pre>";
                $data['rec'] = $rec;
                $data['view'] = 'admin/bug_report/bug_report_view';
                $this->load->view('layout', $data);
            }
        }

        /*
        public function delete($id = 0){
            //$this->rbac->check_operation_access();
            
            $client_id = $this->uri->segment(4);
            $this->bugreportmd->client_delete($client_id);
            $this->session->set_flashdata('msg', 'The Client has been deleted successfully!');
            redirect(base_url('admin/client'));
        }

        public function add(){
            //$this->rbac->check_operation_access();
            
            $this->load->library('utils');
            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_info', 'Info', 'trim|required');
                //$this->form_validation->set_rules('is_active', 'Status', 'trim|required');

                if ($this->form_validation->run() == FALSE) {
                    $data['view'] = 'admin/client/client_add';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                        'name' => $this->utils->mysql_encode_val($this->input->post('fv_name')),
                        'info' => $this->utils->mysql_encode_val($this->input->post('fv_info')),
                        'is_active' => '1',
                        //'password' =>  password_hash($this->input->post('password'), PASSWORD_BCRYPT),
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->bugreportmd->client_add($data);
                    if($result){
                        $this->session->set_flashdata('msg', 'User has been added successfully!');
                        redirect(base_url('admin/client'));
                    }
                }
            }
            else{
                $data['view'] = 'admin/client/client_add';
                $this->load->view('layout', $data);
            }
        }

        public function get_client_decoded($id){
            $data_arr = array();
            $rec_client = $this->bugreportmd->get_client_by_id($id); //echo "<pre>"; print_r($rec_client); echo "</pre>";
            
            $data_arr['client_id'] = $rec_client['client_id'];
            $data_arr['name'] = $this->utils->mysql_decode_val($rec_client['name']);
            $data_arr['info'] = $this->utils->mysql_decode_val($rec_client['info']);
            $data_arr['is_active'] = $rec_client['is_active'];

            return $data_arr;
        }

        public function edit($id = 0){
            //$this->rbac->check_operation_access();

            $this->load->library('utils');
            if($this->input->post('submit')){
                $this->form_validation->set_rules('fv_name', 'Name', 'trim|required');
                $this->form_validation->set_rules('fv_info', 'Info', 'trim|required');
                $this->form_validation->set_rules('fv_is_active', 'Status', 'trim|required');

                if( $this->form_validation->run() == FALSE ){
                    $rec['client_id'] = $id;
                    $rec['name'] = $this->input->post('fv_name');
                    $rec['info'] = $this->input->post('fv_info');
                    $rec['is_active'] = $this->input->post('is_active');

                    $data['rec'] = $rec;
                    $data['view'] = 'admin/client/client_edit';
                    $this->load->view('layout', $data);
                }
                else{
                    $data = array(
                        'name' => $this->utils->mysql_encode_val($this->input->post('fv_name')),
                        'info' => $this->utils->mysql_encode_val($this->input->post('fv_info')),
                        'is_active' => $this->input->post('fv_is_active')
                    );
                    $data = $this->security->xss_clean($data);
                    $result = $this->bugreportmd->client_edit($data, $id);
                    if($result){
                        $this->session->set_flashdata('msg', 'Access Control has been updated successfully!');
                        redirect(base_url('admin/client'));
                    }
                }
            }
            else{
                $rec = $this->get_client_decoded($id); //echo "<pre>"; print_r($rec); echo "</pre>";
                $data['rec'] = $rec;
                $data['view'] = 'admin/client/client_edit';
                $this->load->view('layout', $data);
            }
        }
        /**/
    }
?>