#
# TABLE STRUCTURE FOR: ci_admin
#

DROP TABLE IF EXISTS `ci_admin`;

CREATE TABLE `ci_admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_role_id` int(11) NOT NULL,
  `username` varchar(100) CHARACTER SET utf8 NOT NULL,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `mobile_no` varchar(255) NOT NULL,
  `image` varchar(300) NOT NULL,
  `password` varchar(255) NOT NULL,
  `last_login` datetime NOT NULL,
  `is_verify` tinyint(4) NOT NULL DEFAULT '1',
  `is_admin` tinyint(4) NOT NULL DEFAULT '1',
  `is_active` tinyint(4) NOT NULL DEFAULT '0',
  `is_supper` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(255) NOT NULL,
  `password_reset_code` varchar(255) NOT NULL,
  `last_ip` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`admin_id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=latin1;

INSERT INTO `ci_admin` (`admin_id`, `admin_role_id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `image`, `password`, `last_login`, `is_verify`, `is_admin`, `is_active`, `is_supper`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (24, 1, 'superadmin', 'Super', 'Admin', 'here@there.com', '324234234', 'ff993fc6bcf2d42a9f4e42446d8e45ea.png', '$2y$10$47skv8JsBfAiNIs4ge9w7eUKsyo03j4NTcBRd8eAFdX/qpEMkP5Se', '2019-01-04 11:18:36', 1, 1, 1, 1, '', '', '', '2018-03-17 00:00:00', '2019-03-28 06:03:25');
INSERT INTO `ci_admin` (`admin_id`, `admin_role_id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `image`, `password`, `last_login`, `is_verify`, `is_admin`, `is_active`, `is_supper`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (36, 7, 'devadmin', 'Fabricio', 'Daza', 'fabricio.daza@gmail.com', '123456001', '', '$2y$10$uLzaAFaoHYddUIBFQ1re0.eDX23fbSY6/jw2FaNPFz7n//Tmjzwt6', '0000-00-00 00:00:00', 1, 1, 1, 0, '', '', '', '2019-04-21 05:04:58', '2019-04-21 05:04:58');
INSERT INTO `ci_admin` (`admin_id`, `admin_role_id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `image`, `password`, `last_login`, `is_verify`, `is_admin`, `is_active`, `is_supper`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (37, 7, 'fabsup', 'Fabricio', 'Sup', 'fabsup@mail.com', '1234560001', '', '$2y$10$KxgDMUfUpEAwmil9fWiYcO/CYVRVciVlLtfvbv1I1CbO6mrQAHwy.', '0000-00-00 00:00:00', 1, 1, 1, 0, '', '', '', '2019-05-13 12:05:53', '2019-05-13 12:05:53');
INSERT INTO `ci_admin` (`admin_id`, `admin_role_id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `image`, `password`, `last_login`, `is_verify`, `is_admin`, `is_active`, `is_supper`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (38, 8, 'fabmanager', 'Fabricio', 'Manager', 'fabmanager@mail.com', '1234560002', '', '$2y$10$MJbZBHZ/e8cYEzQNZ12hDexjV90eBMH6WBhjyM0Z7sRhnAltyC2yW', '0000-00-00 00:00:00', 1, 1, 1, 0, '', '', '', '2019-05-13 12:05:31', '2019-05-13 12:05:31');
INSERT INTO `ci_admin` (`admin_id`, `admin_role_id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `image`, `password`, `last_login`, `is_verify`, `is_admin`, `is_active`, `is_supper`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (39, 9, 'fabuser1', 'Fabricio', 'User1', 'fabuser1@mail.com', '1234560003', '', '$2y$10$kfYtwuNAuRxgFIm8jyVxaOjtjrw3caHBc/pNUavq4SiM8l/IDYnii', '0000-00-00 00:00:00', 1, 1, 1, 0, '', '', '', '2019-05-13 12:05:30', '2019-05-13 12:05:30');
INSERT INTO `ci_admin` (`admin_id`, `admin_role_id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `image`, `password`, `last_login`, `is_verify`, `is_admin`, `is_active`, `is_supper`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (40, 9, 'fabuser2', 'Fabricio', 'User2', 'fabuser2@gmail.com', '1234561002', '', '$2y$10$g3Drb8xXwVJdBzcoW.d3qOLJSWhcRWRLnYRxbCyuVecFIXu/tP/BW', '0000-00-00 00:00:00', 1, 1, 1, 0, '', '', '', '2019-05-14 03:05:31', '2019-05-14 03:05:31');
INSERT INTO `ci_admin` (`admin_id`, `admin_role_id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `image`, `password`, `last_login`, `is_verify`, `is_admin`, `is_active`, `is_supper`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (41, 9, 'fabuser3', 'Fabricio', 'User3', 'fabuser3@gmail.com', '1234561003', '', '$2y$10$5GOH7QZoO2yhPa2ve3Mw8OGLhFJvGQThDotqjeLA7lL.IrZdDRHru', '0000-00-00 00:00:00', 1, 1, 1, 0, '', '', '', '2019-05-14 08:05:37', '2019-05-14 08:05:37');


#
# TABLE STRUCTURE FOR: ci_admin_roles
#

DROP TABLE IF EXISTS `ci_admin_roles`;

CREATE TABLE `ci_admin_roles` (
  `admin_role_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_role_title` varchar(30) CHARACTER SET utf8 NOT NULL,
  `admin_role_status` int(11) NOT NULL,
  `admin_role_created_by` int(1) NOT NULL,
  `admin_role_created_on` datetime NOT NULL,
  `admin_role_modified_by` int(11) NOT NULL,
  `admin_role_modified_on` datetime NOT NULL,
  PRIMARY KEY (`admin_role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `ci_admin_roles` (`admin_role_id`, `admin_role_title`, `admin_role_status`, `admin_role_created_by`, `admin_role_created_on`, `admin_role_modified_by`, `admin_role_modified_on`) VALUES (1, 'Super Admin', 1, 0, '2018-03-15 12:48:04', 0, '2018-03-17 12:53:16');
INSERT INTO `ci_admin_roles` (`admin_role_id`, `admin_role_title`, `admin_role_status`, `admin_role_created_by`, `admin_role_created_on`, `admin_role_modified_by`, `admin_role_modified_on`) VALUES (7, 'Super Administrator', 1, 0, '2019-03-28 06:44:54', 0, '2019-04-18 10:45:59');
INSERT INTO `ci_admin_roles` (`admin_role_id`, `admin_role_title`, `admin_role_status`, `admin_role_created_by`, `admin_role_created_on`, `admin_role_modified_by`, `admin_role_modified_on`) VALUES (8, 'Manager', 1, 0, '2019-03-28 06:45:50', 0, '0000-00-00 00:00:00');
INSERT INTO `ci_admin_roles` (`admin_role_id`, `admin_role_title`, `admin_role_status`, `admin_role_created_by`, `admin_role_created_on`, `admin_role_modified_by`, `admin_role_modified_on`) VALUES (9, 'User', 1, 0, '2019-05-12 04:42:28', 0, '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: ci_companies
#

DROP TABLE IF EXISTS `ci_companies`;

CREATE TABLE `ci_companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `email` varchar(50) NOT NULL,
  `mobile_no` varchar(50) NOT NULL,
  `address1` varchar(255) NOT NULL,
  `address2` varchar(255) NOT NULL,
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `ci_companies` (`id`, `name`, `email`, `mobile_no`, `address1`, `address2`, `created_date`) VALUES (9, 'Codeglamour', 'codeglamour1@gmail.com', '44785566952', '27 new jersey - Level 58 - CA 444 United State ', '', '2018-04-26 09:04:18');
INSERT INTO `ci_companies` (`id`, `name`, `email`, `mobile_no`, `address1`, `address2`, `created_date`) VALUES (8, 'Codeglamour', 'codeglamour1@gmail.com', '44785566952', '27 new jersey - Level 58 - CA 444 United State ', '', '2018-04-26 09:04:30');
INSERT INTO `ci_companies` (`id`, `name`, `email`, `mobile_no`, `address1`, `address2`, `created_date`) VALUES (7, 'Codeglamour', 'codeglamour1@gmail.com', '44785566952', '27 new jersey - Level 58 - CA 444 United State ', '', '2018-04-26 09:04:59');
INSERT INTO `ci_companies` (`id`, `name`, `email`, `mobile_no`, `address1`, `address2`, `created_date`) VALUES (6, 'Codeglamour', 'codeglamour1@gmail.com', '44785566952', '27 new jersey - Level 58 - CA 444  United State LLC', '', '2017-12-11 08:12:15');
INSERT INTO `ci_companies` (`id`, `name`, `email`, `mobile_no`, `address1`, `address2`, `created_date`) VALUES (10, 'Codeglamour', 'codeglamour1@gmail.com', '44785566952', '27 new jersey - Level 58 - CA 444 United State ', '', '2019-01-27 10:01:18');


#
# TABLE STRUCTURE FOR: ci_payments
#

DROP TABLE IF EXISTS `ci_payments`;

CREATE TABLE `ci_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `invoice_no` varchar(30) NOT NULL,
  `txn_id` varchar(255) NOT NULL,
  `items_detail` longtext NOT NULL,
  `sub_total` decimal(10,2) NOT NULL,
  `total_tax` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `currency` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `payment_status` varchar(30) NOT NULL,
  `client_note` longtext NOT NULL,
  `termsncondition` longtext NOT NULL,
  `due_date` date NOT NULL,
  `created_date` date NOT NULL,
  `updated_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `ci_payments` (`id`, `admin_id`, `user_id`, `company_id`, `invoice_no`, `txn_id`, `items_detail`, `sub_total`, `total_tax`, `discount`, `grand_total`, `currency`, `payment_method`, `payment_status`, `client_note`, `termsncondition`, `due_date`, `created_date`, `updated_date`) VALUES (4, 3, 34, 9, 'INV-2001', '', 'a:5:{s:19:\"product_description\";a:1:{i:0;s:17:\"Samsung Galaxy S3\";}s:8:\"quantity\";a:1:{i:0;s:1:\"1\";}s:5:\"price\";a:1:{i:0;s:4:\"1000\";}s:3:\"tax\";a:1:{i:0;s:1:\"2\";}s:5:\"total\";a:1:{i:0;s:7:\"1000.00\";}}', '1000.00', '20.00', '5.00', '1015.00', 'USD', '', 'Paid', 'Will be delivered within next 24 hours', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.', '2017-11-29', '2017-12-06', '2018-04-26');
INSERT INTO `ci_payments` (`id`, `admin_id`, `user_id`, `company_id`, `invoice_no`, `txn_id`, `items_detail`, `sub_total`, `total_tax`, `discount`, `grand_total`, `currency`, `payment_method`, `payment_status`, `client_note`, `termsncondition`, `due_date`, `created_date`, `updated_date`) VALUES (2, 3, 32, 7, 'INV-1001', '', 'a:5:{s:19:\"product_description\";a:2:{i:0;s:9:\"Galaxy S6\";i:1;s:9:\"Galaxy S5\";}s:8:\"quantity\";a:2:{i:0;s:1:\"1\";i:1;s:1:\"1\";}s:5:\"price\";a:2:{i:0;s:4:\"1000\";i:1;s:3:\"800\";}s:3:\"tax\";a:2:{i:0;s:1:\"5\";i:1;s:1:\"5\";}s:5:\"total\";a:2:{i:0;s:7:\"1000.00\";i:1;s:6:\"800.00\";}}', '1800.00', '90.00', '2.00', '1888.00', 'USD', '', 'Paid', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.', '2017-12-20', '2017-12-12', '2018-04-26');
INSERT INTO `ci_payments` (`id`, `admin_id`, `user_id`, `company_id`, `invoice_no`, `txn_id`, `items_detail`, `sub_total`, `total_tax`, `discount`, `grand_total`, `currency`, `payment_method`, `payment_status`, `client_note`, `termsncondition`, `due_date`, `created_date`, `updated_date`) VALUES (3, 3, 33, 8, 'INV-2002', '', 'a:5:{s:19:\"product_description\";a:1:{i:0;s:17:\"Samsung Galaxy S3\";}s:8:\"quantity\";a:1:{i:0;s:1:\"1\";}s:5:\"price\";a:1:{i:0;s:2:\"10\";}s:3:\"tax\";a:1:{i:0;s:1:\"2\";}s:5:\"total\";a:1:{i:0;s:5:\"10.00\";}}', '10.00', '0.20', '1.00', '9.20', 'USD', '', 'Paid', 'test', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.', '2017-12-06', '2017-12-06', '2018-04-26');
INSERT INTO `ci_payments` (`id`, `admin_id`, `user_id`, `company_id`, `invoice_no`, `txn_id`, `items_detail`, `sub_total`, `total_tax`, `discount`, `grand_total`, `currency`, `payment_method`, `payment_status`, `client_note`, `termsncondition`, `due_date`, `created_date`, `updated_date`) VALUES (5, 24, 3, 10, '10021', '', 'a:5:{s:19:\"product_description\";a:2:{i:0;s:9:\"Galaxy S7\";i:1;s:9:\"Galaxy S8\";}s:8:\"quantity\";a:2:{i:0;s:1:\"1\";i:1;s:1:\"3\";}s:5:\"price\";a:2:{i:0;s:3:\"300\";i:1;s:3:\"700\";}s:3:\"tax\";a:2:{i:0;s:1:\"0\";i:1;s:1:\"2\";}s:5:\"total\";a:2:{i:0;s:6:\"300.00\";i:1;s:7:\"2100.00\";}}', '2400.00', '42.00', '1.00', '2441.00', 'USD', '', 'Paid', 'Will be delivered on next Friday', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.', '2018-04-20', '2018-04-11', '2019-01-27');


#
# TABLE STRUCTURE FOR: ci_users
#

DROP TABLE IF EXISTS `ci_users`;

CREATE TABLE `ci_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `lastname` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `mobile_no` varchar(30) NOT NULL,
  `password` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `role` tinyint(4) NOT NULL DEFAULT '1',
  `is_active` tinyint(4) NOT NULL DEFAULT '1',
  `is_verify` tinyint(4) NOT NULL DEFAULT '0',
  `is_admin` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(255) NOT NULL,
  `password_reset_code` varchar(255) NOT NULL,
  `last_ip` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;

INSERT INTO `ci_users` (`id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `password`, `address`, `role`, `is_active`, `is_verify`, `is_admin`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (3, 'admin', 'admin', 'admin', 'admin@admin.com', '12345', '$2y$10$qlAzDhBEqkKwP3OykqA7N.ZQk6T67fxD9RHfdv3zToxa9Mtwu9C/e', '27 new jersey - Level 58 - CA 444 \r\nUnited State ', 1, 1, 1, 1, '', '', '', '2017-09-29 10:09:44', '2017-12-14 10:12:41');
INSERT INTO `ci_users` (`id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `password`, `address`, `role`, `is_active`, `is_verify`, `is_admin`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (40, 'fabtest101', 'fab101', 'daza101', 'fabtest101@gmail.com', '1234560002', '$2y$10$wVuwp4AhNsUDzWsEOF03RuJveTTX8aR4bFuy7I92CZ50C9BWmqLX.', 'fake address', 1, 1, 0, 0, '', '', '', '2019-04-20 06:04:32', '2019-04-20 06:04:32');
INSERT INTO `ci_users` (`id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `password`, `address`, `role`, `is_active`, `is_verify`, `is_admin`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (37, 'fdquser01', 'Fabricio', 'User01', 'fdquser01@tmail.com', '123456', '$2y$10$TdD4XTafvsnZrzNTH2q6xOlOXCFVa0TdfZzYwKAoSfxBwfuoZJRsm', 'fake address', 1, 1, 0, 0, '', '', '', '2019-04-05 09:04:53', '2019-04-20 10:04:14');
INSERT INTO `ci_users` (`id`, `username`, `firstname`, `lastname`, `email`, `mobile_no`, `password`, `address`, `role`, `is_active`, `is_verify`, `is_admin`, `token`, `password_reset_code`, `last_ip`, `created_at`, `updated_at`) VALUES (38, 'fabtest100', 'fab100', 'daza100', 'fabtest100@gmail.com', '1231230001', '$2y$10$1y72ilUeSw/PO9TfdR/STO0kpAy8ofFlzdkRv9KhdDKgAxibQlJ6S', 'fake address', 1, 1, 0, 0, '', '', '', '2019-04-20 06:04:43', '2019-04-20 06:04:43');


#
# TABLE STRUCTURE FOR: module
#

DROP TABLE IF EXISTS `module`;

CREATE TABLE `module` (
  `module_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(255) NOT NULL,
  `controller_name` varchar(255) NOT NULL,
  `fa_icon` varchar(100) NOT NULL,
  `operation` text NOT NULL,
  `sort_order` tinyint(4) NOT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (1, 'Admin List', 'admin', '', 'view|add|edit|delete|change_status|access', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (2, 'Role & Permissions', 'admin_roles', '', 'view|add|edit|delete|change_status|access', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (3, 'User Manage', 'users', '', 'view|add|edit|delete|change_status|access', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (4, 'Invoice List', 'invoices', '', 'view|add|edit|delete|access', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (5, 'CI Examples', 'example', '', 'access', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (6, 'Joins', 'joins', '', 'access', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (7, 'Export', 'export', '', 'access', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (8, 'Access Control', 'access_ctrl', '', 'access|add|edit|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (9, 'Requirement', 'requirement', '', 'access|add|edit|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (10, 'Nist Control', 'nist', '', 'access|add|edit|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (11, 'Iso Control', 'iso', '', 'access|add|edit|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (12, 'Question', 'question', '', 'access|add|edit|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (13, 'Support File', 'file', '', 'access|add|edit|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (14, 'File Access', 'file_access', '', 'access|file_assign|assign|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (15, 'File Requirement', 'file_req', '', 'access|file_assign|assign|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (16, 'File Nist', 'file_nist', '', 'access|file_assign|assign|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (17, 'File Iso', 'file_iso', '', 'access|file_assign|assign|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (18, 'File Question', 'file_question', '', 'access|file_assign|assign|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (19, 'User Question', 'user_question', '', 'access|file_assign|assign|delete', 0);
INSERT INTO `module` (`module_id`, `module_name`, `controller_name`, `fa_icon`, `operation`, `sort_order`) VALUES (20, 'Widget Dashboard', 'widget_dashboard', '', 'access', 0);


#
# TABLE STRUCTURE FOR: module_access
#

DROP TABLE IF EXISTS `module_access`;

CREATE TABLE `module_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_role_id` int(11) NOT NULL,
  `module` varchar(255) NOT NULL,
  `operation` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `RoleId` (`admin_role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=162 DEFAULT CHARSET=latin1;

INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (1, 1, 'admin', 'view');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (2, 1, 'admin', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (3, 1, 'admin', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (4, 1, 'admin', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (5, 1, 'admin', 'change_status');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (6, 1, 'admin', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (7, 1, 'admin_roles', 'view');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (8, 1, 'admin_roles', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (9, 1, 'admin_roles', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (10, 1, 'admin_roles', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (11, 1, 'admin_roles', 'change_status');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (12, 1, 'admin_roles', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (13, 1, 'users', 'view');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (14, 1, 'users', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (15, 1, 'users', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (16, 1, 'users', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (17, 1, 'users', 'change_status');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (18, 1, 'users', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (19, 1, 'invoices', 'view');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (20, 1, 'invoices', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (21, 1, 'invoices', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (22, 1, 'invoices', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (23, 1, 'invoices', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (24, 1, 'example', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (25, 1, 'joins', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (26, 1, 'export', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (27, 1, 'file', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (28, 1, 'file', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (29, 1, 'file', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (30, 1, 'file', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (31, 1, 'access_ctrl', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (32, 1, 'access_ctrl', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (33, 1, 'access_ctrl', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (34, 1, 'access_ctrl', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (35, 1, 'requirement', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (36, 1, 'requirement', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (37, 1, 'requirement', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (38, 1, 'requirement', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (39, 1, 'nist', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (40, 1, 'nist', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (41, 1, 'nist', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (42, 1, 'nist', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (43, 1, 'iso', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (44, 1, 'iso', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (45, 1, 'iso', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (46, 1, 'iso', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (47, 1, 'question', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (48, 1, 'question', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (49, 1, 'question', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (50, 1, 'question', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (51, 1, 'file_access', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (52, 1, 'file_access', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (53, 1, 'file_access', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (54, 1, 'file_access', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (55, 1, 'file_req', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (56, 1, 'file_req', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (57, 1, 'file_req', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (58, 1, 'file_req', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (59, 1, 'file_nist', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (60, 1, 'file_nist', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (61, 1, 'file_nist', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (62, 1, 'file_nist', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (63, 1, 'file_iso', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (64, 1, 'file_iso', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (65, 1, 'file_iso', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (66, 1, 'file_iso', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (67, 1, 'file_question', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (68, 1, 'file_question', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (69, 1, 'file_question', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (70, 1, 'file_question', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (71, 1, 'user_question', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (72, 1, 'user_question', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (73, 1, 'user_question', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (74, 1, 'user_question', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (75, 7, 'admin', 'view');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (76, 7, 'admin', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (77, 7, 'admin', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (78, 7, 'admin', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (79, 7, 'admin', 'change_status');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (80, 7, 'admin', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (81, 7, 'admin_roles', 'view');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (82, 7, 'admin_roles', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (83, 7, 'admin_roles', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (84, 7, 'admin_roles', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (85, 7, 'admin_roles', 'change_status');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (86, 7, 'admin_roles', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (87, 7, 'users', 'view');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (88, 7, 'users', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (89, 7, 'users', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (90, 7, 'users', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (91, 7, 'users', 'change_status');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (92, 7, 'users', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (93, 7, 'invoices', 'view');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (94, 7, 'invoices', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (95, 7, 'invoices', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (96, 7, 'invoices', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (97, 7, 'invoices', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (98, 7, 'example', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (99, 7, 'joins', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (100, 7, 'export', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (101, 7, 'access_ctrl', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (102, 7, 'access_ctrl', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (103, 7, 'access_ctrl', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (104, 7, 'access_ctrl', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (105, 7, 'requirement', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (106, 7, 'requirement', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (107, 7, 'requirement', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (108, 7, 'requirement', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (109, 7, 'nist', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (110, 7, 'nist', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (111, 7, 'nist', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (112, 7, 'nist', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (113, 7, 'iso', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (114, 7, 'iso', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (115, 7, 'iso', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (116, 7, 'iso', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (117, 7, 'question', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (118, 7, 'question', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (119, 7, 'question', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (120, 7, 'question', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (121, 7, 'file', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (122, 7, 'file', 'add');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (123, 7, 'file', 'edit');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (124, 7, 'file', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (125, 7, 'file_access', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (126, 7, 'file_access', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (127, 7, 'file_access', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (128, 7, 'file_access', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (129, 7, 'file_req', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (130, 7, 'file_req', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (131, 7, 'file_req', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (132, 7, 'file_req', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (133, 7, 'file_nist', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (134, 7, 'file_nist', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (135, 7, 'file_nist', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (136, 7, 'file_nist', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (137, 7, 'file_iso', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (138, 7, 'file_iso', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (139, 7, 'file_iso', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (140, 7, 'file_iso', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (141, 7, 'file_question', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (142, 7, 'file_question', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (143, 7, 'file_question', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (144, 7, 'file_question', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (145, 7, 'user_question', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (146, 7, 'user_question', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (147, 7, 'user_question', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (148, 7, 'user_question', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (149, 8, 'access_ctrl', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (150, 8, 'requirement', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (151, 8, 'nist', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (152, 8, 'iso', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (153, 8, 'question', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (154, 8, 'user_question', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (155, 8, 'user_question', 'file_assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (156, 8, 'user_question', 'assign');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (157, 8, 'user_question', 'delete');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (158, 1, 'widget_dashboard', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (159, 7, 'widget_dashboard', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (160, 8, 'widget_dashboard', 'access');
INSERT INTO `module_access` (`id`, `admin_role_id`, `module`, `operation`) VALUES (161, 9, 'widget_dashboard', 'access');


#
# TABLE STRUCTURE FOR: tbl_access_ctrl
#

DROP TABLE IF EXISTS `tbl_access_ctrl`;

CREATE TABLE `tbl_access_ctrl` (
  `access_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idx` varchar(15) NOT NULL COMMENT 'alphanumeric index',
  `title` varchar(250) NOT NULL,
  `description` text,
  `active` char(1) NOT NULL COMMENT '[0 = disabled][1 = enabled]',
  `total` decimal(5,2) NOT NULL COMMENT 'calculated percentage',
  PRIMARY KEY (`access_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_access_ctrl` (`access_id`, `idx`, `title`, `description`, `active`, `total`) VALUES (1, '1', 'Access control_1', 'description goes here', '1', '1.11');
INSERT INTO `tbl_access_ctrl` (`access_id`, `idx`, `title`, `description`, `active`, `total`) VALUES (2, '2', 'Access control_2', 'asd', '1', '0.00');
INSERT INTO `tbl_access_ctrl` (`access_id`, `idx`, `title`, `description`, `active`, `total`) VALUES (3, '3', 'Access control_3', 'dasda', '1', '0.00');
INSERT INTO `tbl_access_ctrl` (`access_id`, `idx`, `title`, `description`, `active`, `total`) VALUES (4, '4', 'Access control_4', 'asde', '1', '0.00');
INSERT INTO `tbl_access_ctrl` (`access_id`, `idx`, `title`, `description`, `active`, `total`) VALUES (5, '5', 'Access control_5', 'asdf', '1', '0.00');
INSERT INTO `tbl_access_ctrl` (`access_id`, `idx`, `title`, `description`, `active`, `total`) VALUES (6, '6', 'Access control_6', 'jjasgd sdsdf', '1', '0.00');
INSERT INTO `tbl_access_ctrl` (`access_id`, `idx`, `title`, `description`, `active`, `total`) VALUES (7, '7', 'Access control_7', 'fasdf', '1', '0.00');
INSERT INTO `tbl_access_ctrl` (`access_id`, `idx`, `title`, `description`, `active`, `total`) VALUES (8, '8', 'Access control_8', 'sadlfk lsdakfj', '1', '0.00');


#
# TABLE STRUCTURE FOR: tbl_file
#

DROP TABLE IF EXISTS `tbl_file`;

CREATE TABLE `tbl_file` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(5) NOT NULL COMMENT 'accepted type: [v=video], csv, pdf',
  `title` varchar(150) NOT NULL,
  `file_name` varchar(100) DEFAULT NULL,
  `file_folder` varchar(100) DEFAULT NULL,
  `file_url` varchar(250) NOT NULL,
  `is_used` char(1) NOT NULL COMMENT '[0 = not assigned][1 = assigned]',
  `active` char(1) NOT NULL COMMENT '[0-disabled][1=enabled]',
  `cdate` datetime NOT NULL,
  PRIMARY KEY (`file_id`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (1, 'csv', 'CSV Support file 01', 'csv_sup_file01.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file01.csv', '1', '1', '2019-05-02 16:51:38');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (2, 'pdf', 'PDF Support file 01', 'pdf_sup_file01.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file01.pdf', '1', '1', '2019-05-02 17:22:05');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (3, 'video', 'Support video file 01', '', '', 'https://vimeo.com/100902001', '1', '1', '2019-05-02 17:22:53');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (4, 'csv', 'CSV Support file 02', 'csv_sup_file02.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file02.csv', '0', '1', '2019-05-02 17:23:19');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (5, 'pdf', 'PDF Support file 02', 'pdf_sup_file02.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file02.pdf', '1', '1', '2019-05-02 17:23:45');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (6, 'video', 'Support video file 02', '', '', 'https://vimeo.com/113716040', '1', '1', '2019-05-02 17:24:07');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (7, 'csv', 'CSV Support file 03', 'csv_sup_file03.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file03.csv', '1', '1', '2019-05-02 17:24:28');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (8, 'pdf', 'PDF Support file 03', 'pdf_sup_file03.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file03.pdf', '0', '1', '2019-05-02 17:24:45');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (9, 'video', 'Support video file 03', '', '', 'https://vimeo.com/87110435', '0', '1', '2019-05-02 17:25:12');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (10, 'csv', 'CSV Support file 04', 'csv_sup_file04.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file04.csv', '1', '1', '2019-05-02 17:25:37');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (11, 'pdf', 'PDF Support file 04', 'pdf_sup_file04.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file04.pdf', '1', '1', '2019-05-02 17:25:57');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (12, 'video', 'Support video file 04', '', '', 'https://vimeo.com/274860274', '1', '1', '2019-05-02 17:26:28');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (13, 'csv', 'CSV Support file 05', 'csv_sup_file05.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file05.csv', '1', '1', '2019-05-02 17:27:57');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (14, 'pdf', 'PDF Support file 05', 'pdf_sup_file05.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file05.pdf', '1', '1', '2019-05-02 17:28:20');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (15, 'video', 'Support video file 05', '', '', 'https://vimeo.com/81038116', '1', '1', '2019-05-02 17:28:43');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (16, 'csv', 'CSV Support file 06', 'csv_sup_file06.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file06.csv', '1', '1', '2019-05-02 17:29:45');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (17, 'pdf', 'PDF Support file 06', 'pdf_sup_file06.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file06.pdf', '1', '1', '2019-05-02 17:30:05');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (18, 'video', 'Support video file 06', '', '', 'https://vimeo.com/152994829', '1', '1', '2019-05-02 17:30:57');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (19, 'csv', 'CSV Support file 07', 'csv_sup_file07.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file07.csv', '1', '1', '2019-05-02 17:31:20');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (20, 'pdf', 'PDF Support file 07', 'pdf_sup_file07.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file07.pdf', '1', '1', '2019-05-02 17:31:41');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (21, 'video', 'Support video file 07', '', '', 'https://vimeo.com/210481766', '1', '1', '2019-05-02 17:32:02');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (22, 'video', 'Support video file 08', '', '', 'https://vimeo.com/274860274', '1', '1', '2019-05-03 21:21:09');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (23, 'csv', 'CSV Support file 08', 'csv_sup_file08.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file08.csv', '1', '1', '2019-05-03 21:59:42');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (24, 'csv', 'CSV Support file 08', 'csv_sup_file08.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file08.csv', '1', '1', '2019-05-04 01:36:02');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (25, 'video', 'Support video file 09', '', '', 'https://vimeo.com/81038116', '1', '1', '2019-05-04 20:08:36');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (26, 'csv', 'CSV Support file 09', 'csv_sup_file09.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file09.csv', '1', '1', '2019-05-04 20:11:32');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (27, 'video', 'Video new 01', '', '', 'https://vimeo.com/152994829', '1', '1', '2019-05-05 01:34:14');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (28, 'csv', 'CSV file new 01', 'csv_sup_file091.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file091.csv', '1', '1', '2019-05-05 01:36:03');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (29, 'pdf', 'PDF file new 01', 'pdf_sup_file09.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file09.pdf', '1', '1', '2019-05-05 01:36:39');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (30, 'csv', 'New CSV title 10', 'csv_sup_file10.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file10.csv', '1', '1', '2019-05-11 19:54:56');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (31, 'pdf', 'New PDF File 10', 'pdf_sup_file10.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file10.pdf', '1', '1', '2019-05-11 19:56:02');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (32, 'video', 'NEW Video File title 10', '', '', 'http://vimeo.com/100902001', '1', '1', '2019-05-11 19:58:25');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (33, 'csv', 'SV01', 'csv_sup_file051.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file051.csv', '1', '1', '2019-05-11 21:16:52');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (34, 'pdf', 'New PDF02', 'pdf_sup_file071.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file071.pdf', '1', '1', '2019-05-11 21:17:43');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (35, 'csv', 'CSV20', 'csv_sup_file061.csv', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/csv_sup_file061.csv', '1', '1', '2019-05-11 21:19:58');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (36, 'pdf', 'PDF02', 'pdf_sup_file031.pdf', 'support_files', 'http://190.186.69.196/srvr_gensites/atempsite.online/uploads/support_files/pdf_sup_file031.pdf', '1', '1', '2019-05-11 21:20:28');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (37, 'video', 'Video20', '', '', 'https://www.video.com', '1', '1', '2019-05-11 21:21:01');
INSERT INTO `tbl_file` (`file_id`, `type`, `title`, `file_name`, `file_folder`, `file_url`, `is_used`, `active`, `cdate`) VALUES (38, 'video', 'Youtube Video 01', '', '', 'https://www.youtube.com/watch?v=G1TO1fbzPsA', '1', '1', '2019-05-31 17:26:33');


#
# TABLE STRUCTURE FOR: tbl_file_access
#

DROP TABLE IF EXISTS `tbl_file_access`;

CREATE TABLE `tbl_file_access` (
  `file_access_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `access_pid` int(11) NOT NULL,
  `file_pid` int(11) NOT NULL,
  PRIMARY KEY (`file_access_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_file_iso
#

DROP TABLE IF EXISTS `tbl_file_iso`;

CREATE TABLE `tbl_file_iso` (
  `file_iso_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `iso_pid` int(11) NOT NULL,
  `file_pid` int(11) NOT NULL,
  PRIMARY KEY (`file_iso_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_file_nist
#

DROP TABLE IF EXISTS `tbl_file_nist`;

CREATE TABLE `tbl_file_nist` (
  `file_nist_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nist_pid` int(11) NOT NULL,
  `file_pid` int(11) NOT NULL,
  PRIMARY KEY (`file_nist_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_file_question
#

DROP TABLE IF EXISTS `tbl_file_question`;

CREATE TABLE `tbl_file_question` (
  `file_q_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `q_pid` int(11) NOT NULL,
  `file_pid` int(11) NOT NULL,
  PRIMARY KEY (`file_q_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_file_question` (`file_q_id`, `q_pid`, `file_pid`) VALUES (1, 1, 2);
INSERT INTO `tbl_file_question` (`file_q_id`, `q_pid`, `file_pid`) VALUES (2, 1, 1);
INSERT INTO `tbl_file_question` (`file_q_id`, `q_pid`, `file_pid`) VALUES (3, 1, 3);
INSERT INTO `tbl_file_question` (`file_q_id`, `q_pid`, `file_pid`) VALUES (4, 1, 38);
INSERT INTO `tbl_file_question` (`file_q_id`, `q_pid`, `file_pid`) VALUES (5, 1, 37);


#
# TABLE STRUCTURE FOR: tbl_file_req
#

DROP TABLE IF EXISTS `tbl_file_req`;

CREATE TABLE `tbl_file_req` (
  `file_req_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `req_pid` int(11) NOT NULL,
  `file_pid` int(11) NOT NULL,
  PRIMARY KEY (`file_req_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_iso_ctrl
#

DROP TABLE IF EXISTS `tbl_iso_ctrl`;

CREATE TABLE `tbl_iso_ctrl` (
  `iso_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idx` varchar(15) NOT NULL COMMENT 'alphanumeric index',
  `title` varchar(250) NOT NULL,
  `description` text,
  `active` char(1) NOT NULL COMMENT '[0=disabled][1=enabled]',
  `total` decimal(5,2) NOT NULL COMMENT 'calculated percentage',
  `nist_pid` int(11) NOT NULL,
  PRIMARY KEY (`iso_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_iso_ctrl` (`iso_id`, `idx`, `title`, `description`, `active`, `total`, `nist_pid`) VALUES (1, '1.1.1.1', 'Iso control_1_1_1_1', 'dsfsadf', '1', '0.00', 1);
INSERT INTO `tbl_iso_ctrl` (`iso_id`, `idx`, `title`, `description`, `active`, `total`, `nist_pid`) VALUES (2, '1.1.1.2', 'Iso control_1_1_1_2', 'saldkfj; asd;flsakj f', '1', '0.00', 1);
INSERT INTO `tbl_iso_ctrl` (`iso_id`, `idx`, `title`, `description`, `active`, `total`, `nist_pid`) VALUES (3, '1.1.1.3', 'Iso control_1_1_1_3', 'alksdfj alksdj ', '1', '0.00', 1);
INSERT INTO `tbl_iso_ctrl` (`iso_id`, `idx`, `title`, `description`, `active`, `total`, `nist_pid`) VALUES (4, '1.1.2.1', 'Iso control_1_1_2_1', 'ads asdsad', '1', '0.00', 2);
INSERT INTO `tbl_iso_ctrl` (`iso_id`, `idx`, `title`, `description`, `active`, `total`, `nist_pid`) VALUES (5, '1.1.2.2', 'Iso control_1_1_2_2', 'sdfas asdfsdfs', '1', '0.00', 2);


#
# TABLE STRUCTURE FOR: tbl_nist_ctrl
#

DROP TABLE IF EXISTS `tbl_nist_ctrl`;

CREATE TABLE `tbl_nist_ctrl` (
  `nist_id` int(11) NOT NULL AUTO_INCREMENT,
  `idx` varchar(15) NOT NULL COMMENT 'alphanumeric index',
  `title` varchar(250) NOT NULL,
  `description` text,
  `active` char(1) NOT NULL COMMENT '[0=disabled][1=enabled]',
  `total` decimal(5,2) NOT NULL COMMENT 'calculated percentage',
  `req_pid` int(11) NOT NULL,
  PRIMARY KEY (`nist_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_nist_ctrl` (`nist_id`, `idx`, `title`, `description`, `active`, `total`, `req_pid`) VALUES (1, '1.1.1', 'Nist control_1_1_1', 'sakdjh', '1', '10.00', 1);
INSERT INTO `tbl_nist_ctrl` (`nist_id`, `idx`, `title`, `description`, `active`, `total`, `req_pid`) VALUES (2, '1.1.2', 'Nist control_1_1_2', 'sdfsdfsd', '1', '0.00', 1);
INSERT INTO `tbl_nist_ctrl` (`nist_id`, `idx`, `title`, `description`, `active`, `total`, `req_pid`) VALUES (3, '1.1.3', 'Nist control_1_1_3', 'sdfasf', '1', '0.00', 1);


#
# TABLE STRUCTURE FOR: tbl_question
#

DROP TABLE IF EXISTS `tbl_question`;

CREATE TABLE `tbl_question` (
  `q_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` varchar(250) NOT NULL,
  `active` char(1) NOT NULL COMMENT '[0=disabled][1=enabled]',
  `qfor` char(1) NOT NULL COMMENT 'question for [n=nist][i=iso]',
  `yes` char(1) NOT NULL COMMENT '[options :: 1 and 0 ] [value= 100]',
  `alt_approach` char(1) NOT NULL COMMENT '[options :: 1 and 0 ] [value= 100]',
  `partially` char(1) NOT NULL COMMENT '[options :: 1 and 0 ] [value= 50]',
  `no` char(1) NOT NULL COMMENT '[options :: 1 and 0 ] [value= 0]',
  `does_not_apply` char(1) NOT NULL COMMENT '[options :: 1 and 0 ] [not included in calculation]',
  `description` text COMMENT 'only when answers yes = 1',
  `total` decimal(5,2) NOT NULL DEFAULT '0.00',
  `is_done` char(1) NOT NULL DEFAULT '0' COMMENT '[0=no][1=yes]',
  `ctrl_fk` int(11) NOT NULL COMMENT 'this is foreing key from nist or iso',
  PRIMARY KEY (`q_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_question` (`q_id`, `question`, `active`, `qfor`, `yes`, `alt_approach`, `partially`, `no`, `does_not_apply`, `description`, `total`, `is_done`, `ctrl_fk`) VALUES (1, 'Nist Question_1_1_1_1', '1', 'n', '0', '0', '1', '0', '0', '', '50.00', '1', 1);
INSERT INTO `tbl_question` (`q_id`, `question`, `active`, `qfor`, `yes`, `alt_approach`, `partially`, `no`, `does_not_apply`, `description`, `total`, `is_done`, `ctrl_fk`) VALUES (2, 'Nist Question_1_1_1_2', '1', 'n', '0', '0', '0', '0', '0', '', '0.00', '0', 1);
INSERT INTO `tbl_question` (`q_id`, `question`, `active`, `qfor`, `yes`, `alt_approach`, `partially`, `no`, `does_not_apply`, `description`, `total`, `is_done`, `ctrl_fk`) VALUES (3, 'Nist Question_1_1_3_1', '1', 'n', '0', '0', '0', '0', '0', '', '0.00', '0', 3);
INSERT INTO `tbl_question` (`q_id`, `question`, `active`, `qfor`, `yes`, `alt_approach`, `partially`, `no`, `does_not_apply`, `description`, `total`, `is_done`, `ctrl_fk`) VALUES (4, 'Nist Question_1_1_3_2', '1', 'n', '0', '0', '0', '0', '0', '', '0.00', '0', 3);
INSERT INTO `tbl_question` (`q_id`, `question`, `active`, `qfor`, `yes`, `alt_approach`, `partially`, `no`, `does_not_apply`, `description`, `total`, `is_done`, `ctrl_fk`) VALUES (5, 'Nist Question_1_1_3_3', '1', 'n', '0', '0', '0', '0', '0', '', '0.00', '0', 3);
INSERT INTO `tbl_question` (`q_id`, `question`, `active`, `qfor`, `yes`, `alt_approach`, `partially`, `no`, `does_not_apply`, `description`, `total`, `is_done`, `ctrl_fk`) VALUES (6, 'Iso Qestion_1_1_1_1_1', '1', 'i', '0', '0', '0', '0', '0', '', '0.00', '0', 1);
INSERT INTO `tbl_question` (`q_id`, `question`, `active`, `qfor`, `yes`, `alt_approach`, `partially`, `no`, `does_not_apply`, `description`, `total`, `is_done`, `ctrl_fk`) VALUES (7, 'Iso Qestion_1_1_1_1_2', '1', 'i', '0', '0', '0', '0', '0', '', '0.00', '0', 1);
INSERT INTO `tbl_question` (`q_id`, `question`, `active`, `qfor`, `yes`, `alt_approach`, `partially`, `no`, `does_not_apply`, `description`, `total`, `is_done`, `ctrl_fk`) VALUES (8, 'Iso Qestion_1_1_1_1_3', '1', 'i', '0', '0', '0', '0', '0', '', '0.00', '0', 1);
INSERT INTO `tbl_question` (`q_id`, `question`, `active`, `qfor`, `yes`, `alt_approach`, `partially`, `no`, `does_not_apply`, `description`, `total`, `is_done`, `ctrl_fk`) VALUES (9, 'Nist Question_1_1_1_3', '1', 'n', '0', '0', '0', '0', '0', '', '0.00', '0', 1);


#
# TABLE STRUCTURE FOR: tbl_requirement
#

DROP TABLE IF EXISTS `tbl_requirement`;

CREATE TABLE `tbl_requirement` (
  `req_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idx` varchar(15) NOT NULL COMMENT 'alphanumeric index',
  `title` varchar(250) NOT NULL,
  `description` text,
  `active` char(1) NOT NULL COMMENT '[0-disabled][1=enabled]',
  `total` decimal(5,2) NOT NULL COMMENT 'calculated percentage',
  `access_pid` int(11) NOT NULL,
  PRIMARY KEY (`req_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_requirement` (`req_id`, `idx`, `title`, `description`, `active`, `total`, `access_pid`) VALUES (1, '1.1', 'Requirement_1_1', 'req desc', '1', '3.33', 1);
INSERT INTO `tbl_requirement` (`req_id`, `idx`, `title`, `description`, `active`, `total`, `access_pid`) VALUES (2, '1.2', 'Requirement_1_2', 'req desc', '1', '0.00', 1);
INSERT INTO `tbl_requirement` (`req_id`, `idx`, `title`, `description`, `active`, `total`, `access_pid`) VALUES (3, '1.3', 'Requirement_1_3', 'req desc', '1', '0.00', 1);


#
# TABLE STRUCTURE FOR: tbl_user_question
#

DROP TABLE IF EXISTS `tbl_user_question`;

CREATE TABLE `tbl_user_question` (
  `user_q_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `q_pid` int(11) NOT NULL,
  `admin_pid` int(11) NOT NULL,
  `user_type` char(1) NOT NULL COMMENT '[u=user][m=manager]',
  `data` text COMMENT 'json that contains the answer information',
  `is_done` char(1) DEFAULT '0' COMMENT '[0=no][1=yes]',
  `date_n` int(11) NOT NULL DEFAULT '0',
  `date_d` datetime DEFAULT NULL,
  PRIMARY KEY (`user_q_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_user_question` (`user_q_id`, `q_pid`, `admin_pid`, `user_type`, `data`, `is_done`, `date_n`, `date_d`) VALUES (1, 1, 39, 'u', '{\"opt\":\"y\",\"desc\":\"asda asd\",\"value\":\"100\"}', '1', 1559264714, '2019-05-30 22:05:14');
INSERT INTO `tbl_user_question` (`user_q_id`, `q_pid`, `admin_pid`, `user_type`, `data`, `is_done`, `date_n`, `date_d`) VALUES (2, 1, 40, 'u', '', '0', 0, NULL);
INSERT INTO `tbl_user_question` (`user_q_id`, `q_pid`, `admin_pid`, `user_type`, `data`, `is_done`, `date_n`, `date_d`) VALUES (3, 6, 41, 'u', '', '0', 0, NULL);
INSERT INTO `tbl_user_question` (`user_q_id`, `q_pid`, `admin_pid`, `user_type`, `data`, `is_done`, `date_n`, `date_d`) VALUES (4, 6, 40, 'u', '', '0', 0, NULL);
INSERT INTO `tbl_user_question` (`user_q_id`, `q_pid`, `admin_pid`, `user_type`, `data`, `is_done`, `date_n`, `date_d`) VALUES (5, 3, 40, 'u', '', '0', 0, NULL);
INSERT INTO `tbl_user_question` (`user_q_id`, `q_pid`, `admin_pid`, `user_type`, `data`, `is_done`, `date_n`, `date_d`) VALUES (6, 3, 39, 'u', '', '0', 0, NULL);
INSERT INTO `tbl_user_question` (`user_q_id`, `q_pid`, `admin_pid`, `user_type`, `data`, `is_done`, `date_n`, `date_d`) VALUES (7, 4, 39, 'u', '', '0', 0, NULL);
INSERT INTO `tbl_user_question` (`user_q_id`, `q_pid`, `admin_pid`, `user_type`, `data`, `is_done`, `date_n`, `date_d`) VALUES (8, 6, 39, 'u', '', '0', 0, NULL);
INSERT INTO `tbl_user_question` (`user_q_id`, `q_pid`, `admin_pid`, `user_type`, `data`, `is_done`, `date_n`, `date_d`) VALUES (9, 1, 38, 'm', '{\"opt\":\"p\",\"desc\":\"\",\"value\":\"50\"}', '1', 1559264778, '2019-05-30 22:06:18');


#
# TABLE STRUCTURE FOR: test_user
#

DROP TABLE IF EXISTS `test_user`;

CREATE TABLE `test_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `mobile_no` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `test_user` (`id`, `username`, `email`, `mobile_no`) VALUES (1, 'nauman', 'naumanahmedcs@gmail.com', '3468548054');
INSERT INTO `test_user` (`id`, `username`, `email`, `mobile_no`) VALUES (2, 'ahmed', 'ahmed@gmail.com', '445684332545');


