<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class User_model extends MY_Model {

    public function __construct() {
        $this->table = 'users';
        $this->primary_key = 'UserID';
        $this->return_as = "array";
        parent::__construct();
    }

    function getLoginSession() {
        return $this->session->userdata('login_data');
    }

    public function dropdown_active($id = null) {
        $datarr = null;
        if ($id) {
            $datarr = $this->order_by('FirstName')->where(array('Stat'=>1,'UserID'=>$id))->get_all();
        } else {
            $datarr = $this->order_by('FirstName')->where(array('Stat'=>1))->get_all();
        }
        $ddarray[''] = '--Select--';
        foreach ($datarr as $row) {
            $ddarray[$row['UserID']] = $row['FirstName'].' '. $row['LastName'];
        }
        return $ddarray;
    }

    public function dropdown_agent($id = null) {
        $datarr = null;
        if ($id) {
            $datarr = $this->order_by('FirstName')->where(array('Stat'=>1,'UserID'=>$id))->get_all();
        } else {
            $datarr = $this->order_by('FirstName')->where(array('Stat'=>1,'RoleID'=>4))->get_all();
        }
        $ddarray[''] = '--Select--';
        if($datarr){
            foreach ($datarr as $row) {
                switch ($row['RoleID']) {
                    case 1: $rolelabel = 'Admin'; break;
                    case 3: $rolelabel = 'Contractor'; break;
                    case 4: $rolelabel = 'Agent'; break;
                    default: $rolelabel = 'Unknown';
                };
                $ddarray[$row['UserID']] = $rolelabel.' - '. $row['FirstName'].' '. $row['LastName'];
            }
        }
        return $ddarray;
    }

    public function dropdown_contractor($id = null) {
        $datarr = null;
        if ($id) {
            $datarr = $this->order_by('FirstName')->where(array('Stat'=>1,'UserID'=>$id))->get_all();
        } else {
            $datarr = $this->order_by('FirstName')->where(array('Stat'=>1,'RoleID'=>3))->get_all();
        }
        $ddarray[''] = '--Select--';
        if($datarr){
            foreach ($datarr as $row) {
                switch ($row['RoleID']) {
                    case 1: $rolelabel = 'Admin'; break;
                    case 3: $rolelabel = 'Contractor'; break;
                    case 4: $rolelabel = 'Agent'; break;
                    default: $rolelabel = 'Unknown';
                };
                $ddarray[$row['UserID']] = $rolelabel.' - '. $row['FirstName'].' '. $row['LastName'];
            }
        }
        return $ddarray;
    }

    public function dropdown_allusers($id = null) {
        $datarr = null;
        if ($id) {
            $datarr = $this->order_by('RoleID','FirstName')->where(array('Stat'=>1,'UserID'=>$id))->get_all();
        } else {
            $datarr = $this->order_by('RoleID','FirstName')->where(array('Stat'=>1))->get_all();
        }
        $ddarray[''] = '--Select--';
        if($datarr){
            foreach ($datarr as $row) {
                switch ($row['RoleID']) {
                    case 1: $rolelabel = 'Admin'; break;
                    case 3: $rolelabel = 'Contractor'; break;
                    case 4: $rolelabel = 'Agent'; break;
                    default: $rolelabel = 'Unknown';
                };
                $ddarray[$row['UserID']] = $rolelabel.' - '. $row['FirstName'].' '. $row['LastName'];
            }
        }
        return $ddarray;
    }



}

 