<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_appointment extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'AppointmentID' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'UserID' => array(
                'type' => 'INT',
                'constraint' => 4,
                'null' => TRUE
            ),
            'OfficeID' => array(
                'type' => 'INT',
                'constraint' => 4,
                'null' => TRUE
            ),
            'FirstName' => array(
                'type' => 'VARCHAR',
                'constraint' => 14,
                'null' => TRUE
            ),
            'Email' => array(
                'type' => 'VARCHAR',
                'constraint' => 30,
                'null' => TRUE
            ),
            'LastName' => array(
                'type' => 'VARCHAR',
                'constraint' => 14,
                'null' => TRUE
            ),
            'Address' => array(
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ),
            'AddressLine2' => array(
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ),
            'City' => array(
                'type' => 'VARCHAR',
                'constraint' => 14,
                'null' => TRUE
            ),
            'State' => array(
                'type' => 'VARCHAR',
                'constraint' => 5,
                'null' => TRUE
            ),
            'Zip' => array(
                'type' => 'VARCHAR',
                'constraint' => 10,
                'null' => TRUE
            ),
            'Phone' => array(
                'type' => 'VARCHAR',
                'constraint' => 15,
                'null' => TRUE
            ),
            'When' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'RoofAge' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE
            ),
            'RoofType' => array(
                'type' => 'VARCHAR',
                'constraint' => 12,
                'null' => TRUE
            ),
            'Ladder' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE
            ),
            'Insured' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE
            ),
            'InsuranceCompany' => array(
                'type' => 'VARCHAR',
                'constraint' => 25,
                'null' => TRUE
            ),
            'Status' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => TRUE,
                'default' => 'New'
            ),
            'Reason' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => TRUE
            ),
            'AssignedTo' => array(
                'type' => 'INT',
                'constraint' => 4,
                'null' => TRUE
            ),
            'Time' => array(
                'type' => 'TIME',
                'null' => TRUE
            ),
            'Created_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Updated_at' => array(
                'type' => 'DATE',
                'null' => TRUE
            ),
            'Stat' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
                'default' => 1
            )
        ));
        $this->dbforge->add_key('AppointmentID', TRUE);
        $this->dbforge->create_table('appointments');

    }

    public function down() {
        $this->dbforge->drop_table('appointments');
    }

}