<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_mainmenu extends CI_Migration {

    public function up() {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'title' => array(
                'type' => 'VARCHAR',
                'constraint' => 150,
                'null' => TRUE
            ),
            'url' => array(
                'type' => 'VARCHAR',
                'constraint' => 150,
                'null' => TRUE
            ),
            'position' => array(
                'type' => 'VARCHAR',
                'constraint' => 150,
                'null' => TRUE
            ),
            'target' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ),
            'parent_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ),
            'show_menu' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ),
            'type' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ),
            'icon' => array(
                'type' => 'VARCHAR',
                'constraint' => 150,
                'null' => TRUE
            ),
            'tooltip' => array(
                'type' => 'VARCHAR',
                'constraint' => 150,
                'null' => TRUE
            )
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('mainmenu');

        $data = array(
            array('title' => 'Home','url' => 'index.php/admin','position' => 0,'target' => 0,'parent_id' => 0,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-home'),
            array('title' => 'Setting','url' => 'index.php/settings','position' => 9,'target' => 2,'parent_id' => 0,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-cogs'),
            array('title' => 'User','url' => 'settings/user','position' => 0,'target' => 2,'parent_id' => 2,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-user-circle'),
            array('title' => 'Role','url' => 'settings/role','position' => 1,'target' => 2,'parent_id' => 2,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-clock-o'),
            array('title' => 'Office','url' => 'settings/office','position' => 2,'target' => 2,'parent_id' => 2,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-university'),
            array('title' => 'Appointment','url' => 'index.php/appointment','position' => 1,'target' => 6,'parent_id' => 0,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-calendar-check-o'),
            array('title' => 'Add Appointment','url' => 'appointment/add_appointment','position' => 1,'target' => 6,'parent_id' => 6,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-plus-circle'),
            array('title' => 'Report','url' => 'appointment/appointment_report','position' => 2,'target' => 6,'parent_id' => 6,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-line-chart'),
            array('title' => 'Insurance','url' => 'settings/insurance','position' => 3,'target' => 2,'parent_id' => 2,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-drivers-license-o'),
            array('title' => 'Home','url' => 'index.php/admin/contractor','position' => 0,'target' => 10,'parent_id' => 0,'show_menu' => 1,'type' => 3,'icon' => 'fa fa-home'),
            array('title' => 'Account','url' => 'index.php/contractor/edit_contractor','position' => 1,'target' => 11,'parent_id' => 0,'show_menu' => 1,'type' => 3,'icon' => 'fa fa-user-circle'),
            array('title' => 'Appointment Limit','url' => 'settings/appointment_limit','position' => 4,'target' => 2,'parent_id' => 2,'show_menu' => 1,'type' => 1,'icon' => 'fa fa-adjust'),
            array('title' => 'Appointment','url' => 'index.php/appointment','position' => 1,'target' => 13,'parent_id' => 0,'show_menu' => 1,'type' => 4,'icon' => 'fa fa-calendar-check-o'),
            array('title' => 'Add Appointment','url' => 'appointment/add_appointment','position' => 1,'target' => 13,'parent_id' => 13,'show_menu' => 4,'type' => 1,'icon' => 'fa fa-plus-circle'),
            array('title' => 'Home','url' => 'index.php/admin/agent','position' => 0,'target' => 15,'parent_id' => 0,'show_menu' => 1,'type' => 4,'icon' => 'fa fa-home'),

        );
        $this->db->insert_batch('mainmenu', $data);
    }

    public function down() {
        $this->dbforge->drop_table('mainmenu');
    }

}