<?php defined('BASEPATH') OR exit('No direct script access allowed');

	class Payment extends MY_Controller {
		function __construct(){
			parent::__construct();
			$this->load->library('rbac');
			$this->load->helper('sendsms_helper');
			$this->load->model('admin/payment_model', 'payment_model');
			$this->load->model('admin/rent_model', 'rent');
			$this->load->library('pagination');
			$this->load->library('datatable');
			$this->rbac->check_module_access();
		}	
	
		
		public function pay(){
			$this->session->unset_userdata('propbill_id_number');
			$this->session->unset_userdata('property_number');
			$this->session->unset_userdata('father_name');
			$this->session->unset_userdata('market');
			$data['year']= $this->rent->get_single_finnacial_year();
			$data['title']="Rent Payment";
			$data['wards'] = $this->rent->get_all_wards();
			$data['markets'] = $this->rent->get_all_market_lists();
			$data['view'] = 'admin/payment/pay';
			$this->load->view('layout', $data);
		}
		public function view_bill(){
			$this->session->unset_userdata('propbill_id_number');
			$this->session->unset_userdata('property_number');
			$this->session->unset_userdata('father_name');
			$this->session->unset_userdata('market');
			$data['year']= $this->rent->get_single_finnacial_year();
			$data['title']="View bill";
			$data['wards'] = $this->rent->get_all_wards();
			$data['markets'] = $this->rent->get_all_market_lists();
			$data['view'] = 'admin/payment/view_bill';
			$this->load->view('layout', $data);
		}
		public function receipt_posting(){
			$this->session->unset_userdata('propbill_id_number');
			$this->session->unset_userdata('property_number');
			$this->session->unset_userdata('market');
			$this->session->unset_userdata('father_name');
			$data['year']= $this->rent->get_single_finnacial_year();
			$data['title']="Receipt Posting";
			$data['wards'] = $this->rent->get_all_wards();
			$data['markets'] = $this->rent->get_all_market_lists();
			$data['view'] = 'admin/payment/receipt_posting';
			$this->load->view('layout', $data);
		}
		public function search(){
			
			$this->session->set_userdata('property_id_number',$this->input->post('property_id_number'));
			$this->session->set_userdata('property_number',$this->input->post('property_number'));
			$this->session->set_userdata('market',$this->input->post('market'));
			$this->session->set_userdata('father_name',$this->input->post('father_name'));
			
		}
		function billpay()
		{
			$id = $this->input->post('property_id');
			$fy = $this->input->post('financial_year');
			$message = 1;    
			$this->load->library('form_validation');
			$this->load->model('payment_model');       
			$data = array();

			$payment_mode=$this->input->post('r3');

			$receiptno ="";
			$deposit_receipt_date ="";
			$payer_name ="";

			if($payment_mode == 'cash')
			{
				$receiptno=$this->input->post('cash_receiptno');
				$deposit_receipt_date=$this->input->post('cash_deposit_receipt_date');
				$payer_name=$this->input->post('cash_payer_name');
			}
			elseif($payment_mode == 'cheque')
			{
				$receiptno=$this->input->post('cheque_receiptno');
				$deposit_receipt_date=$this->input->post('cheque_deposit_receipt_date');
				$payer_name=$this->input->post('cheque_payer_name');
			}
			else
			{

			}

			if($receiptno == '')
			{
				$total_records=$this->payment_model->get_total_records();
				$fixed = '01';
				$number = $fixed.mt_rand( 10000000, 99999999);
				//echo $number;

				$receiptno=$total_records+1;

				$check_receiptno=$this->payment_model->check_receiptno1($receiptno);

				if($check_receiptno)
				{
					$receiptno=$receiptno+1;
				}

			}
			else
			{
				$receiptno = $receiptno;
			}

			// print_r($receiptno);
			// die;
			$check_receiptno1=$this->payment_model->check_receiptno1($receiptno);

			if($check_receiptno1)
			{
				echo json_encode(array('statusCode' => 201));
			}
			else
			{
			$data['rent_demand_registerid']=$this->input->post('rent_demand_registerid');
			$data['financial_year']=$this->input->post('financial_year');
			$data['property_id_number']=$this->input->post('property_id');
			$data['deposit_current_month']=$this->input->post('deposit_current_month');
			if($this->input->post('ampaid') == 'full' && $this->input->post('payment_type') == 'yearly')
			{
				 $data['deposit_outstanding_deposit']=$this->input->post('current_due_rent');
				 $data['demand_current_month_rent'] = $this->input->post('deposit_outstanding_deposit');
				 $data['deposit_gst'] = $this->input->post('demand_gst');
				 $gstamountpaid = $this->input->post('demand_gst');
				 if($this->input->post('deposit_gst')>0) $gstamountpaid = $gstamountpaid+$this->input->post('deposit_gst');
			}elseif($this->input->post('ampaid') == 'partial' && $this->input->post('payment_type') == 'yearly')
			{
				 $data['deposit_outstanding_deposit']=$this->input->post('partialpaidamount');
				 //$data['demand_current_month_rent'] = $this->input->post('deposit_outstanding_deposit');
				 $gstamountpaid ='';
				 if($this->input->post('deposit_bakaya_gst')>0)
				 {
					$data['deposit_gst'] = $this->input->post('deposit_gst') - $this->input->post('deposit_bakaya_gst');
					$gstamountpaid = $this->input->post('deposit_bakaya_gst');
				 }
			}
			else
			{
			$data['deposit_outstanding_deposit']=$this->input->post('current_due_rent');
			$data['demand_current_month_rent'] = $this->input->post('deposit_outstanding_deposit');
			$data['deposit_gst'] = $this->input->post('demand_gst'); //$this->input->post('deposit_gst');
			$gstamountpaid = $this->input->post('demand_gst');//$this->input->post('deposit_bakaya_gst');
			}
			
			$data['deposit_late_fee']=$this->input->post('deposit_late_fee');
			$data['deposit_total_pay']=$this->input->post('deposit_total_pay');
			$receipt_number = $this->input->post('deposit_receipt_number');
			$data['deposit_receipt_number']= isset($receipt_number) ? $receipt_number : $receiptno;
			$data['deposit_receipt_date']=$deposit_receipt_date;
			$data['deposit_depositor']=$payer_name;
			$data['deposit_comment']=$this->input->post('deposit_comment');
			$data['paid_at']=date('Y-m-d');
			if($this->input->post('ampaid') == 'full' && $this->input->post('payment_type') == 'yearly')
			{
				$data['paid_amount'] = $this->input->post('paidamount');
				
			}elseif($this->input->post('ampaid') == 'partial' && $this->input->post('payment_type') == 'yearly')
			{
				$paidAmount = $this->input->post('partialpaidamount');
				if($gstamountpaid>0) $paidAmount = $this->input->post('partialpaidamount') + $gstamountpaid;
				$data['paid_amount'] = $paidAmount;
			}else{
				$paidAmount = $this->input->post('paidamount');
				//if($gstamountpaid>0) $paidAmount = $this->input->post('paidamount') + $gstamountpaid;
				$data['paid_amount'] = $paidAmount;
			}
			$data['deposit_gst'] = $gstamountpaid;
			$data['paid_partial_or_full']=$this->input->post('ampaid');
			$data['payment_mode']=$payment_mode;
			$data['payment_type']=$this->input->post('payment_type');
			$data['chequeno']=$this->input->post('chequeno');
			$data['bank_name']=$this->input->post('bank_name');
			//print_r($data);
			//die;
			$this->form_validation->set_data($data);			
			$data['is_active'] = 0;
			$textMsg = "Dear {#var#},
Your bill generated and amount is {#amt#} and your payment is due on {#date#}.
Please make a payment of {#amount#}, before the due date.

NPP Gonda UP. ";
			$textMsg = str_replace("{#var#}", 'Awadh', stripcslashes($textMsg));
			$textMsg = str_replace("{#amt#}", '20', stripcslashes($textMsg));
			$textMsg = str_replace("{#date#}", '2020-12-20', stripcslashes($textMsg));
			$textMsg = str_replace("{#amount#}", '2020', stripcslashes($textMsg));
			//sendsms( '9317579316', $textMsg );
			//die;
			//print_r($data);
			
			$this->db->insert('rent_demand_register_payments',$data);
			$recept_id = $this->db->insert_id();
			if($this->input->post('ampaid') == 'full' && $this->input->post('payment_type') == 'yearly' && !empty($recept_id))
			{	
			 // माँग पक्ष
			 $this->db->set('demand_due_rent',0);
			 $this->db->set('demand_bakaya_gst',0);
			 $this->db->set('demand_total_gst',0);
			 $this->db->set('demand_total_deposit_money_yog',0);
			 $this->db->set('demand_total_deposit_money',0);
			 //जमा पक्ष
			 $this->db->set('deposit_current_month',$this->input->post('deposit_outstanding_deposit'));
			 $this->db->set('deposit_outstanding_deposit',$this->input->post('current_due_rent'));
			 $this->db->set('deposit_bakaya_gst',$this->input->post('deposit_gst'));
			 $this->db->set('deposit_total_gst',$this->input->post('deposit_gst')+$this->input->post('demand_gst'));
			 $this->db->set('deposit_total_pay',$this->input->post('deposit_total_pay'));
			 $this->db->set('deposit_gst',$this->input->post('demand_gst'));
			 $this->db->set('deposit_receipt_number',$this->input->post('cash_receiptno'));
			 $this->db->set('deposit_receipt_date',$this->input->post('cash_deposit_receipt_date'));
			 $this->db->set('deposit_depositor',$this->input->post('cash_payer_name'));
			 $this->db->set('deposit_comment',$this->input->post('deposit_comment'));
			 $this->db->set('awashesh_amount',0);
			 $this->db->where('property_id_number',$this->input->post('property_id'));
			 $this->db->update('rent_demand_register_details_'.$fy);	
			}elseif($this->input->post('ampaid') == 'partial' && $this->input->post('payment_type') == 'yearly' && !empty($recept_id))
			{
				
			 //$jma_rent = $this->payment_model->get_bill_data_model_by_register($id);
			 $jma_rent = $this->payment_model->get_bill_data_model_by_register_year($id,$fy);
			 //print_r($jma_rent);
			 // माँग पक्ष
			 if($this->input->post('current_due_rent')>0){
				 // deduct paid amount by bakaya rent
			 $this->db->set('demand_due_rent ',$this->input->post('current_due_rent') - ($this->input->post('partialpaidamount')));
			 }
			 if($this->input->post('demand_bakaya_gst')>0){
				 // deduct paid Gst amount by bakaya GST
			 $this->db->set('demand_bakaya_gst ',$this->input->post('deposit_gst') - $this->input->post('deposit_bakaya_gst'));
			 }
			 $demand_total_gst = $jma_rent['demand_total_gst'];
			 //echo '<br/>';
			 //echo "2=>".$this->input->post('deposit_bakaya_gst');
			 if($this->input->post('deposit_bakaya_gst')>0) $demand_total_gst = $jma_rent['demand_total_gst']-$this->input->post('deposit_bakaya_gst');
			 $this->db->set('demand_total_gst',$demand_total_gst); // deduct paid GST by All GST
			 //$this->db->set('demand_total_deposit_money_yog',$jma_rent['demand_total_deposit_money_yog']-$this->input->post('partialpaidamount')); // deduct paid amount by money yog
			 $demand_total_deposit_moneys = $jma_rent['demand_total_deposit_money']-$this->input->post('partialpaidamount');
			 if($this->input->post('deposit_bakaya_gst')>0)$demand_total_deposit_moneys = $jma_rent['demand_total_deposit_money']-($this->input->post('partialpaidamount')+$this->input->post('deposit_bakaya_gst'));
			 //$this->db->set('demand_total_deposit_money ',$demand_total_deposit_moneys);	
			 //जमा पक्ष
			 $awasheshtotal = $jma_rent['awashesh_amount']-($this->input->post('partialpaidamount'));
			 if($this->input->post('deposit_bakaya_gst')>0)$awasheshtotal = $jma_rent['awashesh_amount']-($this->input->post('partialpaidamount')+$this->input->post('deposit_bakaya_gst'));
			 $awashesh_amount_pending = $awasheshtotal;			 
			 $total_paid_till_now = $jma_rent['deposit_outstanding_deposit']+$this->input->post('partialpaidamount');
			 $deposit_total_pay_till_now = $jma_rent['deposit_total_pay']+$this->input->post('partialpaidamount');
			 if($this->input->post('deposit_bakaya_gst')>0) $deposit_total_pay_till_now = $jma_rent['deposit_total_pay']+($this->input->post('partialpaidamount')+$this->input->post('deposit_bakaya_gst'));
			 $this->db->set('deposit_outstanding_deposit ',$total_paid_till_now);
			 if($this->input->post('deposit_bakaya_gst')>0){
				$deposit_bakaya_gst_till_now = $jma_rent['deposit_bakaya_gst']+$this->input->post('deposit_bakaya_gst');
				$this->db->set('deposit_bakaya_gst ',$deposit_bakaya_gst_till_now);
				$deposit_total_gst_till_now = $jma_rent['deposit_total_gst']+$this->input->post('deposit_bakaya_gst');
				$this->db->set('deposit_total_gst ',$deposit_total_gst_till_now);
			 }
			 $this->db->set('deposit_total_pay ',$deposit_total_pay_till_now);
			 //$this->db->set('demand_total_gst ',$awashesh_amount_pending);
			 $this->db->set('deposit_receipt_number',$this->input->post('cash_receiptno'));
			 $this->db->set('deposit_receipt_date',$this->input->post('cash_deposit_receipt_date'));
			 $this->db->set('deposit_depositor',$this->input->post('cash_payer_name'));
			 $this->db->set('deposit_comment',$this->input->post('deposit_comment'));
			 $this->db->set('awashesh_amount ',$awashesh_amount_pending);
			 $this->db->where('property_id_number',$this->input->post('property_id'));
			 $this->db->update('rent_demand_register_details_'.$fy);
			}else{
				 //$jma_rent = $this->payment_model->get_bill_data_model_by_register($id);
			 $jma_rent = $this->payment_model->get_bill_data_model_by_register_year($id,$fy);
			 //print_r($jma_rent);
			 // माँग पक्ष
			 if($this->input->post('current_due_rent')>0){
			 $this->db->set('demand_due_rent',$this->input->post('current_due_rent') - ($this->input->post('deposit_outstanding_deposit')));
			 }else
			 {
				  $this->db->set('demand_due_rent',0);
			 }
			 if($this->input->post('demand_bakaya_gst')>0){
			 $this->db->set('demand_bakaya_gst',$this->input->post('deposit_gst') - $this->input->post('demand_gst'));
			 }else{
				 $this->db->set('demand_bakaya_gst',0);
			 }
			 $demand_total_gst = $jma_rent['demand_total_gst'];
			 //$row['demand_gst'],
			 //$row['demand_bakaya_gst'],
			 //$row['demand_total_gst'], 
			 //echo '<br/>';
			 //echo "2=>".$this->input->post('deposit_bakaya_gst');
			 if($this->input->post('deposit_bakaya_gst')>0){ $demand_total_gst = $jma_rent['demand_total_gst']-$this->input->post('deposit_bakaya_gst');}else{
				 $demand_total_gst = 0;
			 }
			 $this->db->set('demand_total_gst',$demand_total_gst);
			 $demand_total_deposit_money_yog = $jma_rent['demand_total_deposit_money_yog'];
			 if($this->input->post('partialpaidamount')>0) $demand_total_deposit_money_yog = $jma_rent['demand_total_deposit_money_yog']-$this->input->post('partialpaidamount');
			 $this->db->set('demand_total_deposit_money_yog',$demand_total_deposit_money_yog);
			 $demand_total_deposit_moneys ='';
			 if($this->input->post('partialpaidamount')>0) $demand_total_deposit_moneys = $jma_rent['demand_total_deposit_money'];
			 if($this->input->post('deposit_bakaya_gst')>0)$demand_total_deposit_moneys = $jma_rent['demand_total_deposit_money']-($this->input->post('partialpaidamount')+$this->input->post('deposit_bakaya_gst'));
			 $this->db->set('demand_total_deposit_money ',$demand_total_deposit_moneys);	
			 //जमा पक्ष
			 $awasheshtotal = $jma_rent['demand_total_deposit_money']-($this->input->post('paidamount'));
			 if($this->input->post('deposit_bakaya_gst')>0)$awasheshtotal = $jma_rent['demand_total_deposit_money']-($this->input->post('paidamount')+$this->input->post('deposit_bakaya_gst'));
			 $awashesh_amount_pending = $awasheshtotal;			 
			
			 //$this->db->set('deposit_outstanding_deposit ',$awashesh_amount_pending);
			 //$this->db->set('deposit_bakaya_gst ',$awashesh_amount_pending);
			 //$this->db->set('deposit_total_gst ',$awashesh_amount_pending);
			 //$this->db->set('deposit_total_pay ',$awashesh_amount_pending);
			 //$this->db->set('demand_total_gst ',$awashesh_amount_pending);
			 $this->db->set('deposit_receipt_number',$this->input->post('cash_receiptno'));
			 $this->db->set('deposit_receipt_date',$this->input->post('cash_deposit_receipt_date'));
			 $this->db->set('deposit_depositor',$this->input->post('cash_payer_name'));
			 $this->db->set('deposit_comment',$this->input->post('deposit_comment'));
			 $this->db->set('awashesh_amount ',$awashesh_amount_pending);
			 $this->db->where('property_id_number',$this->input->post('property_id'));
			 $this->db->update('rent_demand_register_details_'.$fy);
			}				
			//$this->rent_model->insert($data);
			//if($recept_id) sendsms( '919317579316', 'Hello world, this is a test message' );
			$url = 'receipt/'. $recept_id;
			$rec['redirect_url']=$url;
			echo json_encode($rec);
			}


			
			
			//redirect('admin/payment/receipt/'. $recept_id);
		}

		function billpay2()
		{
			$id = $this->input->post('property_id');
			$fy = $this->input->post('financial_year');
			$message = 1;    
			$this->load->library('form_validation');
			$this->load->model('payment_model');       
			$data = array();

			$payment_mode=$this->input->post('r3');
			$jma_rent = $this->payment_model->get_bill_data_model_by_register_year($id,$fy);			
			$receiptno="";
			$deposit_receipt_date="";
			$payer_name="";
			$recept_id = "";
			if($payment_mode == 'cash')
			{
				$receiptno=$this->input->post('cash_receiptno');
				$deposit_receipt_date=$this->input->post('cash_deposit_receipt_date');
				$payer_name=$this->input->post('cash_payer_name');
			}
			elseif($payment_mode == 'cheque')
			{
				$receiptno=$this->input->post('cheque_receiptno');
				$deposit_receipt_date=$this->input->post('cheque_deposit_receipt_date');
				$payer_name=$this->input->post('cheque_payer_name');
			}
			else
			{

			}

			if($receiptno == '')
			{
				$total_records=$this->payment_model->get_total_records();
				$fixed = '01';
				$number = $fixed.mt_rand( 10000000, 99999999);
				//echo $number;

				$receiptno=$total_records+1;

				$check_receiptno=$this->payment_model->check_receiptno1($receiptno);

				if($check_receiptno)
				{
					$receiptno=$receiptno+1;
				}

			}
			else
			{
				$receiptno=$receiptno;
			}

			// print_r($receiptno);
			// die;
			$check_receiptno1=$this->payment_model->check_receiptno1($receiptno);

			if($check_receiptno1)
			{
				echo json_encode(array('statusCode' => 201));
			}
			else
			{
				$data['rent_demand_registerid']=$this->input->post('rent_demand_registerid');
				$data['financial_year']=$this->input->post('financial_year');
				$data['property_id_number']=$this->input->post('property_id');
				$data['deposit_current_month']=$this->input->post('deposit_current_month');
				$data['deposit_outstanding_deposit']=$this->input->post('deposit_outstanding_deposit');
				$data['deposit_gst']=$this->input->post('deposit_gst');
				$data['deposit_late_fee']=$this->input->post('deposit_late_fee');
				$data['deposit_total_pay']=$this->input->post('deposit_total_pay');
				$data['deposit_receipt_number']=$receiptno;
				$data['deposit_receipt_date']=$deposit_receipt_date;
				$data['deposit_depositor']=$payer_name;
				//$data['deposit_comment']=$this->input->post('deposit_comment');
				$data['paid_at']=date('Y-m-d');
				$data['paid_amount']=$this->input->post('paidamount');
				//$data['paid_partial_or_full']=$this->input->post('ampaid');
				$data['payment_mode']=$payment_mode;
				$data['chequeno']=$this->input->post('chequeno');
				$data['bank_name']=$this->input->post('bank_name');
				$data['cheque_date']=$this->input->post('cheque_date');
				$data['ifsc']=$this->input->post('ifsc');
				//print_r($data);
				//die;
				$this->form_validation->set_data($data);		
				$data['is_active'] = 0;
				//echo '<pre>';
				//print_r($this->input->post());
				//print_r($jma_rent);
				//die;
				if($jma_rent['demand_due_rent']>0 && $jma_rent['awashesh_amount']>0){
				$this->db->insert('rent_demand_register_payments',$data);
				$recept_id = $this->db->insert_id();
				}
				if(!empty($recept_id)){
					 
					 // माँग पक्ष
					 if($this->input->post('current_due_rent')>0){
						 // deduct paid amount by bakaya rent
					 $this->db->set('demand_due_rent ',$jma_rent['demand_due_rent']-$this->input->post('current_due_rent'));
					 }
					 if($this->input->post('demand_bakaya_gst')>0){
						 // deduct paid Gst amount by bakaya GST
					 $this->db->set('demand_bakaya_gst',$jma_rent['demand_bakaya_gst']-$this->input->post('deposit_gst'));
					 }
					 $demand_total_gst = $jma_rent['demand_total_gst'];
					 $paid_total_gst = 0;
					 if($this->input->post('deposit_gst')>0)$paid_total_gst+= $this->input->post('deposit_gst');
					 if($this->input->post('demand_gst')>0)$paid_total_gst+= $this->input->post('demand_gst');
					 //echo '<br/>';
					 //echo "2=>".$this->input->post('deposit_bakaya_gst');
					 if($this->input->post('deposit_gst')>0 || $this->input->post('demand_gst')>0) $demand_total_gst = $jma_rent['demand_total_gst']-$paid_total_gst;
					 $this->db->set('demand_total_gst',$demand_total_gst); // deduct paid GST by All GST
					 //$this->db->set('demand_total_deposit_money_yog',$jma_rent['demand_total_deposit_money_yog']-$this->input->post('partialpaidamount')); // deduct paid amount by money yog
					 $demand_total_deposit_moneys = $jma_rent['demand_total_deposit_money']-$this->input->post('paidamount');
					 if($this->input->post('deposit_bakaya_gst')>0)$demand_total_deposit_moneys = $jma_rent['demand_total_deposit_money']-($this->input->post('partialpaidamount')+$this->input->post('deposit_bakaya_gst'));
					 //$this->db->set('demand_total_deposit_money ',$demand_total_deposit_moneys);	
					 //जमा पक्ष
					 $awasheshtotal = $jma_rent['awashesh_amount'];
					 if($this->input->post('deposit_gst')>0 || $this->input->post('demand_gst')>0)$awasheshtotal = $jma_rent['awashesh_amount']-($this->input->post('paidamount')+$paid_total_gst);
					 $awashesh_amount_pending = $awasheshtotal;			 
					 $total_paid_till_now = $jma_rent['deposit_outstanding_deposit']+$this->input->post('paidamount');
					 $deposit_total_pay_till_now = $jma_rent['deposit_total_pay']+$this->input->post('paidamount');
					 if($this->input->post('deposit_gst')>0 || $this->input->post('demand_gst')>0) $deposit_total_pay_till_now = $jma_rent['deposit_total_pay']+($this->input->post('paidamount')+$paid_total_gst);
					 $this->db->set('deposit_outstanding_deposit ',$total_paid_till_now);
					 if($this->input->post('deposit_gst')>0){
						$deposit_bakaya_gst_till_now = $jma_rent['deposit_bakaya_gst']+$this->input->post('deposit_gst');
						$this->db->set('deposit_bakaya_gst ',$deposit_bakaya_gst_till_now);						
					 }
					 if($this->input->post('deposit_gst')>0 || $this->input->post('demand_gst')>0){
						$deposit_total_gst_till_now = $jma_rent['deposit_total_gst']+$paid_total_gst;
						$this->db->set('deposit_total_gst ',$deposit_total_gst_till_now);
					 }
					 $this->db->set('deposit_total_pay ',$deposit_total_pay_till_now);
					 //$this->db->set('demand_total_gst ',$awashesh_amount_pending);
					 $this->db->set('deposit_receipt_number',$this->input->post('cash_receiptno'));
					 $this->db->set('deposit_receipt_date',$this->input->post('cash_deposit_receipt_date'));
					 $this->db->set('deposit_depositor',$this->input->post('cash_payer_name'));
					 $this->db->set('deposit_comment',$this->input->post('deposit_comment'));
					 $this->db->set('awashesh_amount ',$awashesh_amount_pending);
					 $this->db->where('property_id_number',$this->input->post('property_id'));
					 $this->db->update('rent_demand_register_details_'.$fy);
				$url = 'receipt1/'. $recept_id;
				$rec['redirect_url']='<button type="submit" class="btn btn-info "><a href="receipt1/'.$recept_id.'" style="color: #fff;">View receipt</a></button>';
				echo json_encode($rec);
				}else{
					echo json_encode(array('statusCode' => 205));
				}
				
			}

			//redirect('admin/payment/receipt/'. $recept_id);
		}
		public function receipt($id=0)
		{
			//$this->rbac->check_operation_access(); // check opration permission

			$data['receipt_detail'] = $this->payment_model->get_receipt_by_id($id);
			$data['receipt_detail']['items_detail'] = $this->payment_model->get_all_pay_by_id($data['receipt_detail']['property_id_number']);
			$data['receipt_detail']['address'] = $this->payment_model->get_pay_address_by_id($data['receipt_detail']['rent_demand_registerid']);
			$data['view'] = 'admin/payment/receipt_view';
			$this->load->view('layout', $data);
		}

		public function receipt1($id=0)
		{
			//$this->rbac->check_operation_access(); // check opration permission

			// print_r($id);
			// die;

			$data['receipt_detail'] = $this->payment_model->get_receipt_by_id($id);
			$data['receipt_detail']['items_detail'] = $this->payment_model->get_all_pay_by_id($data['receipt_detail']['property_id_number']);
			$data['receipt_detail']['address'] = $this->payment_model->get_pay_address_by_id($data['receipt_detail']['rent_demand_registerid']);
			$data['view'] = 'admin/payment/receipt_view1';
			$this->load->view('layout', $data);
		}
		// Server-side processing Datatable Example with Advance Search
		public function advance_datatable_json($id){
            //$id = $this->input->get('id');			
			$records = $this->payment_model->get_all_users_by_advance_search($id);
			$data = array();
			$i=0;
			//print_r($records['data']);
			foreach ($records['data']  as $row) 
			{   
				if($row['awashesh_amount']>0){
					$button = '<button type="button" class="btn btn-info pay_now" relid="'.$row['property_id_number'].'" fny="'.$row['financial_year'].'">Pay now </button>';}else{
						$button = '';
					}
				 if($row['allotment_date'] !=='0000-00-00'){
					 $alotDate = date_time($row['allotment_date']);
				 }else
				 {
					 $alotDate = '';
				 }
				$Market_names = $this->rent->get_MarketALL($row['market']);
				$status = ($row['is_active'] == 1)? 'checked': '';
				$data[]= array(
					$row['rent_demand_registerid'],
					$row['property_id_number'],
					$row['property_number'],
					$row['father_name'],
					$row['ward_name'],
					$row['m_name'],
					$Market_names[0]->market_name,
					$row['mobile_number'],
					$alotDate,
					$button					
				);
			}
			$records['data']=$data;
			echo json_encode($records);						   
		}
		public function get_bill_view()
			{
			$id = $this->input->get('id');
			$fy = $this->input->get('fy');						
			$this->load->library('utils');
			$jma_rent = $this->payment_model->get_bill_data_model($id,$fy);
			$jma_rent_last = $this->payment_model->get_bill_data_model_last($id,$fy);
			//echo '<pre>';
			//print_r($jma_rent_last);
			$paidCount = count($jma_rent);
			$billamout = isset($paidCount) ? $paidCount : 0;
			if($billamout <= 0){
				//echo $billamout;
				//echo $id.','.$fy;
				$jma_rent = $this->payment_model->get_bill_data_model_by_register_year($id,$fy);
				//print_r($jma_rent);
				//die;
				$demand_cmonth_rent = $jma_rent['demand_current_month_rent'];
				$demand_gst = $demand_cmonth_rent*18/100;//$jma_rent['demand_gst'];
				$demand_latefee = $jma_rent['demand_late_fee'];			
				$demand_total_amt = $jma_rent['demand_total_deposit_money'];			 
				$currentlatefee = $demand_latefee;			
				$deposit_month = $jma_rent['created_at'];
				$month = explode("-",$deposit_month);			
				$depo_month = $month[1]; //deposit date month 
				$current_month= date('Y-m-d');		
				$cmonth = explode("-",$current_month);
				$curent_month = $cmonth[1]; // current running month
				$month_latefee = $depo_month - $curent_month;		
				$total_latefee = $month_latefee * $currentlatefee; // total late fee (depost mont - curent month = latefee x month)
				//check if same month 
				
				if($depo_month=$curent_month){
					$total_currentamt = $demand_cmonth_rent + $demand_gst + $jma_rent['demand_bakaya_gst']+ $jma_rent['demand_due_rent'];
					$data['gst']= $demand_gst;	
				}else{
					$total_currentamt = (($demand_cmonth_rent * $month_latefee)+ ($demand_gst * $month_latefee)+ $jma_rent['demand_bakaya_gst']+ $jma_rent['demand_due_rent']+ $total_latefee);
					//$data['gst']= $demand_gst * $month_latefee;	
					$data['gst']= $demand_gst;
				}
				
				$data['currentmonth']= $demand_cmonth_rent;		
				$data['late_fee']= $total_latefee;			
						
				$data['rent_demand_registerid']=$jma_rent['rent_demand_registerid'];
				$data['property_id_number']=$jma_rent['property_id_number'];
				$data['totalgrantamt']= $total_currentamt;
				$data['pending']=$jma_rent['demand_due_rent'];
				$data['pendingGst']=$jma_rent['demand_bakaya_gst'];
			}else{
				$totalpaid=0;
				$totaldeposit=0;
				$pendingamt = 0;
				$pendingtotal = 0;
				$totalgstpaid = 0;		
				foreach($jma_rent as $number => $number_array)
				{
					foreach($number_array as $key => $rentAmt)
					{
						//print "Array number: $number, contains $data with $user_data.  <br>";
						if($key=='deposit_total_pay')$totaldeposit +=$rentAmt;
						if($key=='paid_amount')$totalpaid +=$rentAmt;
						if($key=='deposit_gst')$totalgstpaid +=$rentAmt;
					}
				}
				
				$jma_rent = $this->payment_model->get_bill_data_model_by_register_year($id,$fy);
				//echo '<pre>';
				//print_r($jma_rent);
				$total =  $totaldeposit;
				$total = $jma_rent['demand_total_deposit_money'];			
				$paidtotal = $totalpaid;
				$pendingamt = ($total - $paidtotal);// totalamt - totalpaidamt
				$pendingtotal = $pendingamt; //total pending amt
				$currentm = $jma_rent['demand_current_month_rent'];//$jma_rent['deposit_outstanding_deposit'];
				$currentgst = $jma_rent['deposit_gst'];
				$currentlatefee = $jma_rent['deposit_late_fee'];			
				$deposit_month = $jma_rent_last['paid_at'];
				$month = explode("-",$deposit_month);			
				$depo_month = $month[1]; //deposit date month 
				$current_month= date('Y-m-d');		
				$cmonth = explode("-",$current_month);
				$curent_month = $cmonth[1]; // current running month
				$month_latefee = $curent_month-$depo_month;		
				$total_latefee = $month_latefee * $currentlatefee; // total late fee (depost mont - curent month = latefee x month)			
				$currentpending = $pendingtotal;			
				$totallate ='';
				//echo $total ."!==". $paidtotal;
				if($total !== $paidtotal) $totallate = $currentlatefee; // if tatol mag != total jma (then charge late_fee)
				//$total_currentamt = (($currentm * $month_latefee)+ ($currentgst * $month_latefee)+ $total_latefee + $currentpending);
				$total_currentamt = $pendingamt+ ($jma_rent['demand_total_gst']-$totalgstpaid);		
				//$data['demand'] = $this->rent->getdata_rentpayment($id);
				if($pendingtotal-($jma_rent['demand_total_gst']-$totalgstpaid)>0){
				$data['pending']= $jma_rent['demand_due_rent']; //$pendingtotal-($jma_rent['demand_total_gst']-$totalgstpaid);
				}else{
					$data['pending']=0;
				}
				$data['currentmonth']= $currentm;
				$data['gst']= $jma_rent['demand_current_month_rent']*18/100;//$currentgst * $month_latefee;
				$pendinggstpaid = $jma_rent['demand_total_gst'];
				if($totalgstpaid>0) $pendinggstpaid = $jma_rent['demand_total_gst']-$totalgstpaid;
				if($pendinggstpaid<0) $pendinggstpaid=0;
				$data['pendingGst'] = $pendinggstpaid;
				if($depo_month === $curent_month && $jma_rent_last['paid_partial_or_full'] == 'full')
				{
					$data['currentmonth']= 0;
					$data['gst'] = 0;
				}
				$data['late_fee']= $total_latefee;
				$data['receipt_number']= $jma_rent['deposit_receipt_number'];
				$data['receipt_date']= $jma_rent['deposit_receipt_date'];
				$data['deposit_depositor']= $jma_rent['deposit_depositor'];
				$data['deposit_comment']= $jma_rent['deposit_comment'];
				$data['rent_demand_registerid']=$jma_rent['rent_demand_registerid'];
				$data['property_id_number']=$jma_rent['property_id_number'];
				if($pendingtotal > 0 ){
				$data['totalgrantamt']= $currentpending;//$jma_rent['demand_current_month_rent']*18/100+$jma_rent['demand_bakaya_gst']+$jma_rent['demand_current_month_rent']+$pendingtotal;
				}else{
					$data['totalgrantamt']= $jma_rent['demand_total_deposit_money'];//$jma_rent['demand_current_month_rent']*18/100+$jma_rent['demand_bakaya_gst']+$jma_rent['demand_current_month_rent'];
				}
				
				//die;
			}
			
			$fixed = '00';
			$number = $fixed.mt_rand( 100, 999);
			//$jma_rent['deposit_receipt_number']
			$data['receipt_number'] = $number;
			$mnth=date('m');
			$yearr=date('Y');
			$data['month']='';
			if($mnth==1)
			{
				$data['month'].='जनवरी, '.$yearr;
			}
			elseif($mnth==2)
			{
				$data['month'].='फरवरी, '.$yearr;
			}
			elseif($mnth==3)
			{
				$data['month'].='मार्च, '.$yearr;
			}
			elseif($mnth==4)
			{
				$data['month'].='अप्रैल, '.$yearr;
			}
			elseif($mnth==5)
			{
				$data['month'].='मई, '.$yearr;
			}
			elseif($mnth==6)
			{
				$data['month'].='जून, '.$yearr;
			}
			elseif($mnth==7)
			{
				$data['month'].='जुलाई, '.$yearr;
			}
			elseif($mnth==8)
			{
				$data['month'].='अगस्त, '.$yearr;
			}
			elseif($mnth==9)
			{
				$data['month'].='सितम्बर, '.$yearr;
			}
			elseif($mnth==10)
			{
				$data['month']='अक्टूबर, '.$yearr;
			}
			elseif($mnth==11)
			{
				$data['month'].='नवम्बर, '.$yearr;
			}
			elseif($mnth==12)
			{
				$data['month'].='दिसम्बर, '.$yearr;
			}

			$data['current_date']=date('d-m-Y');
			//echo "awa".$jma_rent['rent_demand_registerid'];
			$data['customer_address']['address'] = $this->payment_model->get_pay_address_by_id($jma_rent['rent_demand_registerid'],$fy);
			//print_r($data);
			$data['view'] = 'admin/payment/view_pending_bill';
			$this->load->view('layout', $data);
			//echo json_encode($data); 
			//exit();
			}
		public function bill_search(){
				
			$this->session->set_userdata('propbill_id_number',$this->input->post('property_id_number'));
			$this->session->set_userdata('property_number',$this->input->post('property_number'));
			$this->session->set_userdata('father_name',$this->input->post('father_name'));
			$this->session->set_userdata('market',$this->input->post('market'));
			
		}
		public function bill_datatable_json($id){
			
			$records = $this->payment_model->get_all_bill_by_search($id);
			$data = array();
			$i=0;
			foreach ($records['data']  as $row) 
			{  
				$status = ($row['is_active'] == 1)? 'checked': '';
				$Market_names = $this->rent->get_MarketALL($row['market']);
				$allotment_date ='';
				if(strtotime($row['allotment_date'])>0)$allotment_date = date_time($row['allotment_date']);
				$data[]= array(
					++$i,
					$row['property_id_number'],
					$row['property_number'],
					$row['father_name'],
					$row['ward_name'],
					$row['m_name'],
					$Market_names[0]->market_name,
					$row['mobile_number'],
					$allotment_date,
					'<button type="submit" class="btn btn-info "><a href="get_bill_view?id='.$row['property_id_number'].'&fy='.$row['financial_year'].'" style="color: #fff;">View bill</a></button>'					
					// '<button type="submit" class="btn btn-info view_detail" relid="'.$row['property_id_number'].'">View Invoice</button>&nbsp;<button type="submit" class="btn btn-info "><a href="get_bill_view?id='.$row['property_id_number'].'" style="color: #fff;">View bill</a></button>'
				);
			}
			$records['data']=$data;
			//print($data);
			echo json_encode($records);						   
		}
		public function bill_datatable_json2($id){				   					   
			$records = $this->payment_model->get_all_bill_by_search($id);
			$data = array();
			$i=0;
			foreach ($records['data']  as $row) 
			{  
				$status = ($row['is_active'] == 1)? 'checked': '';
				$Market_names = $this->rent->get_MarketALL($row['market']);
				$allotment_date ='';
				//echo strtotime($row['allotment_date']);
				if(strtotime($row['allotment_date'])>0)$allotment_date = date_time($row['allotment_date']);
				$data[]= array(
					++$i,
					$row['property_id_number'],
					$row['property_number'],
					$row['father_name'],
					$row['ward_name'],
					$row['m_name'],
					$Market_names[0]->market_name,
					$row['mobile_number'],
					$allotment_date,					
					'<button type="submit" class="btn btn-info view_detail" relid="'.$row['property_id_number'].'" fy='.$row['financial_year'].'>Receipt Posting</button>'

					// '<button type="submit" class="btn btn-info view_detail" relid="'.$row['property_id_number'].'">View Invoice</button>&nbsp;<button type="submit" class="btn btn-info "><a href="get_bill_view?id='.$row['property_id_number'].'" style="color: #fff;">View bill</a></button>'
				);
			}
			$records['data']=$data;
			//print($data);
			echo json_encode($records);						   
		}
		
		public function get_bill_data1()
			{
				
			$id = trim($this->input->get('id'));
			$fy = trim($this->input->get('fny'));			
			$this->load->library('utils');
			$jma_rent = $this->payment_model->get_bill_data_model($id,$fy);
			//print_r($jma_rent);
			$checkArray = count($jma_rent);
			$paidamout = isset($checkArray) ? $checkArray : 0;
			if($paidamout <= 0 || $paidamout ===''){
				//$data='';
				$jma_rent = $this->payment_model->get_bill_data_model_by_register_year($id,$fy);
				//print_r($jma_rent);			
				$demand_cmonth_rent = $jma_rent['demand_current_month_rent'];
				$demand_gst = $jma_rent['demand_gst'];
				$demand_latefee = $jma_rent['demand_late_fee'];			
				$demand_total_amt = $jma_rent['demand_total_deposit_money'];			 
				$currentlatefee = $demand_latefee;
				$awashesh_amount = $jma_rent['awashesh_amount'];
				$deposit_month = $jma_rent['created_at'];
				$month = explode("-",$deposit_month);			
				$depo_month = $month[1]; //deposit date month 

				$current_month= date('Y-m-d');		
				$cmonth = explode("-",$current_month);
				$curent_month = $cmonth[1]; // current running month
				$month_latefee = $curent_month - $depo_month;
				$month_for_total = $month_latefee+1;
						
				$total_latefee = $month_latefee * $currentlatefee; // total late fee (depost mont - curent month = latefee x month)
				//check if same month 
				if($depo_month == $curent_month && $awashesh_amount <=0){
					$total_currentamt = $demand_cmonth_rent + $demand_gst;
					$data['gst']= $demand_gst;	
				}else{
					//$total_currentamt = (($demand_cmonth_rent * $month_for_total)+ ($demand_gst * $month_for_total)+ $total_latefee + $awashesh_amount);
					$total_currentamt = $awashesh_amount;
					$data['gst']= $jma_rent['demand_bakaya_gst'];//$demand_gst * $month_for_total;	
				}	
				//print_r($jma_rent);
				$data['pending'] = $jma_rent['demand_due_rent'];
				$data['financial_year']= '<option value="'.$jma_rent['financial_year'].'">2021-2022</option>';
				$data['currentmonth']= $demand_cmonth_rent; //$demand_cmonth_rent;
				$data['currentyeartotal']= $demand_cmonth_rent*12;     
				$data['demand_gst']= $demand_cmonth_rent*18/100;			
				$data['late_fee']= $total_latefee;					
				$data['rent_demand_registerid']=$jma_rent['rent_demand_registerid'];
				$data['property_id_number']=$jma_rent['property_id_number'];
				$data['totalgrantamt']= $total_currentamt;
			}else{
				$totalpaid=0;
				$totaldeposit=0;
				$totalgstpaid=0;
				//print_r($jma_rent[0]);			
				foreach($jma_rent as $number => $number_array)
				{
				foreach($number_array as $key => $rentAmt)
					{
						//print "Array number: $number, contains $data with $user_data.  <br>";
						if($key=='deposit_outstanding_deposit')$totaldeposit +=$rentAmt;
						if($key=='paid_amount')$totalpaid +=$rentAmt;
						if($key=='deposit_gst')$totalgstpaid +=$rentAmt;
					}
				}
					
				$jma_rent = $this->payment_model->get_bill_data_model_by_register_year($id,$fy);
				//print_r($jma_rent);
				$totalpaid =  $totaldeposit+$totalgstpaid;
				//echo '<br/>';
				$total = $jma_rent['demand_total_deposit_money'];		
				$paidtotal = $totalpaid;			
				$pendingamt = ($total - $paidtotal);// totalamt - totalpaidamt
				$pendingtotal = $pendingamt;//$pendingamt; //total pending amt
				$currentm = $jma_rent['demand_current_month_rent'];
				$currentgst = $jma_rent['deposit_gst'];
				$currentlatefee = $jma_rent['deposit_late_fee'];
				//$pending_awadhesh = $jma_rent['awashesh_amount'] - $jma_rent['paid_amount'];
				//$awashesh_amount = isset($jma_rent['awashesh_amount']) ? $jma_rent['awashesh_amount'] : $pending_awadhesh;			
				//$deposit_month = $jma_rent['paid_at'];
				//$month = explode("-",$deposit_month);			
				//$depo_month = $month[1]; //deposit date month
				$current_month = date('Y-m-d');		
				$cmonth = explode("-",$current_month);
				$curent_month = $cmonth[1]; // current running month
				//$month_latefee = $curent_month-$depo_month;		
				//$total_latefee = $month_latefee * $currentlatefee; // total late fee (depost mont - curent month = latefee x month)			
				$currentpending = $pendingtotal;			
				$totallate ='';
				if($total !== $paidtotal) $totallate = $currentlatefee; // if tatol mag != total jma (then charge late_fee)
				//$total_currentamt = (($currentm * $month_latefee)+ ($currentgst * $month_latefee)+ $total_latefee + $currentpending + $awashesh_amount);	
				$total_currentamt = $pendingtotal;
				//echo $jma_rent['demand_due_rent'].'-'.$totaldeposit;
				$finalPending = $jma_rent['demand_due_rent']-$totaldeposit;
				if($finalPending<0) $finalPending = $jma_rent['demand_due_rent'];
				$data['pending']= $finalPending;//$pendingtotal-($jma_rent['demand_total_gst']-$totalgstpaid);
				$data['financial_year']= '<option value="'.$jma_rent['financial_year'].'">2021-2022</option>';
				$data['currentmonth']= $currentm; //$currentm * $month_latefee;
				$data['currentyeartotal']= $currentm*12;
				$data['demand_gst']= $currentm*18/100;
				//echo $jma_rent['demand_bakaya_gst'].'-'.$totalgstpaid;
				if($paidtotal > $currentgst){
					$finlgst = $jma_rent['demand_total_gst']-$totalgstpaid;
				}else{
					$finlgst = $currentgst-$paidtotal;
				}
				$finalGST = $jma_rent['demand_bakaya_gst']-$totalgstpaid;
				if($finalGST<0) $finalGST=0;
				$data['gst']= $finalGST;//$currentgst * $month_latefee;
				//$data['late_fee']= $total_latefee;
				//$data['receipt_number']= $jma_rent['deposit_receipt_number'];
				//$data['receipt_date']= $jma_rent['deposit_receipt_date'];
				//$data['deposit_depositor']= $jma_rent['deposit_depositor'];
				//$data['deposit_comment']= $jma_rent['deposit_comment'];
				$data['rent_demand_registerid']=$jma_rent['rent_demand_registerid'];
				$data['property_id_number']=$jma_rent['property_id_number'];
				$data['totalgrantamt']= $total_currentamt;			
			}
				echo json_encode($data); 
				exit();
			}

			public function get_bill_data()
			{
			$id = $this->input->get('id');
			$fy = trim($this->input->get('fny'));
			$this->load->library('utils');
			$jma_rent = $this->payment_model->get_bill_data_model($id,$fy);	
			$register_details = $this->payment_model->get_bill_data_model_by_register_year($id,$fy);
			//echo '<pre>';
			//print_r($jma_rent);
			//print_r($register_details);
			$checkArray = count($jma_rent);
			$paidamout = isset($checkArray) ? $checkArray : 0;
			//$rent_id = isset($jma_rent['rent_demand_registerid']) ? count($jma_rent['rent_demand_registerid']) : 0;
			
			if($paidamout>0){
			$rent_demandregisterid = $register_details['rent_demand_registerid'];

			$data['deposit_receipt_number']=$register_details['deposit_receipt_number'];

			$result = $this->payment_model->get_receipt_posting_details($rent_demandregisterid,$fy);
			//print_r($result);
			$data['rent_demand_registerid']=$result['rent_demand_registerid'];
			
			//$data['ward_no']=$result['ward_no'];
			$markets = $this->payment_model->get_marketname_by_id($register_details['market']);
			
			$wards = $this->payment_model->get_wardname_by_id($register_details['ward']);
			
			$financial_years = $this->payment_model->get_finnacial_year_by_id($register_details['financial_year']);
			
			$village_info = $this->payment_model->get_mohalla_village_name($register_details['village_address']);
			
			$data['ward_name']=$wards['ward_name'];
			$data['market_name']=$markets['market_name'];
			$data['village_address']=$village_info['name'];
			
			$data['father_name']=$result['father_name'];
			
			$data['mobile_number']=$result['mobile_number'];
			
			$data['property_type']=$result['property'];
			
			$data['property_id_number']=$id;
			
			//$data['ward_id']=$result['ward_id'];
			
			$data['finnancial_id']=$fy;
			$data['finnancial_year']=$result['year'];
			
			}else{
				
			$markets = $this->payment_model->get_marketname_by_id($register_details['market']);
			
			$wards = $this->payment_model->get_wardname_by_id($register_details['ward']);
			
			$financial_years = $this->payment_model->get_finnacial_year_by_id($register_details['financial_year']);
			
			$village_info = $this->payment_model->get_mohalla_village_name($register_details['village_address']);
			
			$data['deposit_receipt_number']=0;
			$data['rent_demand_registerid']=$register_details['rent_demand_registerid'];
			$data['ward_name']=$wards['ward_name'];
			$data['market_name']=$markets['market_name'];
			$data['village_address']=$village_info['name'];
			$data['father_name']=$register_details['father_name'];
			$data['mobile_number']=$register_details['mobile_number'];
			$data['property_type']=$register_details['property_type'];
			$data['property_id_number']=$register_details['property_id_number'];			
			$data['finnancial_id']=$fy;
			$data['finnancial_year']=$financial_years['year'];
			}
			echo json_encode($data); 
			exit();
			}
		function list_data(){
			$data['info'] = $this->rent->get_all();
			$data['view'] = 'admin/rents/lists';
			$this->load->view('layout', $data);
		}
		
		public function edit($id=""){
			$data['title']="Rent";
			$this->load->library('utils');
			$data['rent'] = $this->rent->get_rent_by_id($id);
			$data['view'] = 'admin/rents/edit';
			$this->load->view('layout', $data);
		}
		public function viewbill($id=""){
			//$this->session->unset_userdata('propbill_id_number');
			$data['title']="Reciept View Data";
			//$this->load->library('utils');
			$data['reciept_view'] = $this->payment_model->get_recieptbill_data_model($id);
			$data['view'] = 'admin/payment/viewbill';
			$this->load->view('layout', $data);
			//print_r($data['reciept_view']);
			///die;
		}
		public function get_viewbill_data()
			{
				$id = $this->input->get('id');
				$get_student = $this->payment_model->get_viewbill_data_model($id);
				//print_r($get_student);
				echo json_encode($get_student); 
				exit();
			}
			// view bill invoice one by one 
		public function view_bill_invoice()
		{			
			$id = $this->input->get('invoice_id');				
			$data['receipt_view_invoice'] = $this->payment_model->get_view_invoice_by_id($id);
			//$data['receipt_view_invoice']['items_detail'] = $this->payment_model->get_all_pay_by_id($data['receipt_view_invoice']['property_id_number']);
			$data['receipt_view_invoice']['address'] = $this->payment_model->get_pay_address_by_id($data['receipt_view_invoice']['rent_demand_registerid']);
			$data['view'] = 'admin/payment/viewbill';
			$this->load->view('layout', $data);			
		}

	}
